/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationsignals.model.ApplicationSignalsResponse;
import software.amazon.awssdk.services.applicationsignals.model.ServiceDependenciesCopier;
import software.amazon.awssdk.services.applicationsignals.model.ServiceDependency;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListServiceDependenciesResponse
extends ApplicationSignalsResponse
implements ToCopyableBuilder<Builder, ListServiceDependenciesResponse> {
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(ListServiceDependenciesResponse.getter(ListServiceDependenciesResponse::startTime)).setter(ListServiceDependenciesResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(ListServiceDependenciesResponse.getter(ListServiceDependenciesResponse::endTime)).setter(ListServiceDependenciesResponse.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<List<ServiceDependency>> SERVICE_DEPENDENCIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ServiceDependencies").getter(ListServiceDependenciesResponse.getter(ListServiceDependenciesResponse::serviceDependencies)).setter(ListServiceDependenciesResponse.setter(Builder::serviceDependencies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceDependencies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceDependency::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListServiceDependenciesResponse.getter(ListServiceDependenciesResponse::nextToken)).setter(ListServiceDependenciesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD, END_TIME_FIELD, SERVICE_DEPENDENCIES_FIELD, NEXT_TOKEN_FIELD));
    private final Instant startTime;
    private final Instant endTime;
    private final List<ServiceDependency> serviceDependencies;
    private final String nextToken;

    private ListServiceDependenciesResponse(BuilderImpl builder) {
        super(builder);
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.serviceDependencies = builder.serviceDependencies;
        this.nextToken = builder.nextToken;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final boolean hasServiceDependencies() {
        return this.serviceDependencies != null && !(this.serviceDependencies instanceof SdkAutoConstructList);
    }

    public final List<ServiceDependency> serviceDependencies() {
        return this.serviceDependencies;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceDependencies() ? this.serviceDependencies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceDependenciesResponse)) {
            return false;
        }
        ListServiceDependenciesResponse other = (ListServiceDependenciesResponse)((Object)obj);
        return Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && this.hasServiceDependencies() == other.hasServiceDependencies() && Objects.equals(this.serviceDependencies(), other.serviceDependencies()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListServiceDependenciesResponse").add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("ServiceDependencies", this.hasServiceDependencies() ? this.serviceDependencies() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "ServiceDependencies": {
                return Optional.ofNullable(clazz.cast(this.serviceDependencies()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListServiceDependenciesResponse, T> g) {
        return obj -> g.apply((ListServiceDependenciesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationSignalsResponse.BuilderImpl
    implements Builder {
        private Instant startTime;
        private Instant endTime;
        private List<ServiceDependency> serviceDependencies = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServiceDependenciesResponse model) {
            super(model);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.serviceDependencies(model.serviceDependencies);
            this.nextToken(model.nextToken);
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final List<ServiceDependency.Builder> getServiceDependencies() {
            List<ServiceDependency.Builder> result = ServiceDependenciesCopier.copyToBuilder(this.serviceDependencies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceDependencies(Collection<ServiceDependency.BuilderImpl> serviceDependencies) {
            this.serviceDependencies = ServiceDependenciesCopier.copyFromBuilder(serviceDependencies);
        }

        @Override
        public final Builder serviceDependencies(Collection<ServiceDependency> serviceDependencies) {
            this.serviceDependencies = ServiceDependenciesCopier.copy(serviceDependencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceDependencies(ServiceDependency ... serviceDependencies) {
            this.serviceDependencies(Arrays.asList(serviceDependencies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceDependencies(Consumer<ServiceDependency.Builder> ... serviceDependencies) {
            this.serviceDependencies(Stream.of(serviceDependencies).map(c -> (ServiceDependency)((ServiceDependency.Builder)ServiceDependency.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListServiceDependenciesResponse build() {
            return new ListServiceDependenciesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApplicationSignalsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListServiceDependenciesResponse> {
        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder serviceDependencies(Collection<ServiceDependency> var1);

        public Builder serviceDependencies(ServiceDependency ... var1);

        public Builder serviceDependencies(Consumer<ServiceDependency.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

