/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.applicationsignals.model.AttributesCopier;
import software.amazon.awssdk.services.applicationsignals.model.MetricDataQueriesCopier;
import software.amazon.awssdk.services.applicationsignals.model.MetricDataQuery;
import software.amazon.awssdk.services.applicationsignals.model.MonitoredRequestCountMetricDataQueries;
import software.amazon.awssdk.services.applicationsignals.model.ServiceLevelIndicatorMetricType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RequestBasedServiceLevelIndicatorMetric
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RequestBasedServiceLevelIndicatorMetric> {
    private static final SdkField<Map<String, String>> KEY_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("KeyAttributes").getter(RequestBasedServiceLevelIndicatorMetric.getter(RequestBasedServiceLevelIndicatorMetric::keyAttributes)).setter(RequestBasedServiceLevelIndicatorMetric.setter(Builder::keyAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> OPERATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperationName").getter(RequestBasedServiceLevelIndicatorMetric.getter(RequestBasedServiceLevelIndicatorMetric::operationName)).setter(RequestBasedServiceLevelIndicatorMetric.setter(Builder::operationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationName").build()}).build();
    private static final SdkField<String> METRIC_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricType").getter(RequestBasedServiceLevelIndicatorMetric.getter(RequestBasedServiceLevelIndicatorMetric::metricTypeAsString)).setter(RequestBasedServiceLevelIndicatorMetric.setter(Builder::metricType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricType").build()}).build();
    private static final SdkField<List<MetricDataQuery>> TOTAL_REQUEST_COUNT_METRIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TotalRequestCountMetric").getter(RequestBasedServiceLevelIndicatorMetric.getter(RequestBasedServiceLevelIndicatorMetric::totalRequestCountMetric)).setter(RequestBasedServiceLevelIndicatorMetric.setter(Builder::totalRequestCountMetric)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalRequestCountMetric").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricDataQuery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<MonitoredRequestCountMetricDataQueries> MONITORED_REQUEST_COUNT_METRIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MonitoredRequestCountMetric").getter(RequestBasedServiceLevelIndicatorMetric.getter(RequestBasedServiceLevelIndicatorMetric::monitoredRequestCountMetric)).setter(RequestBasedServiceLevelIndicatorMetric.setter(Builder::monitoredRequestCountMetric)).constructor(MonitoredRequestCountMetricDataQueries::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoredRequestCountMetric").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ATTRIBUTES_FIELD, OPERATION_NAME_FIELD, METRIC_TYPE_FIELD, TOTAL_REQUEST_COUNT_METRIC_FIELD, MONITORED_REQUEST_COUNT_METRIC_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, String> keyAttributes;
    private final String operationName;
    private final String metricType;
    private final List<MetricDataQuery> totalRequestCountMetric;
    private final MonitoredRequestCountMetricDataQueries monitoredRequestCountMetric;

    private RequestBasedServiceLevelIndicatorMetric(BuilderImpl builder) {
        this.keyAttributes = builder.keyAttributes;
        this.operationName = builder.operationName;
        this.metricType = builder.metricType;
        this.totalRequestCountMetric = builder.totalRequestCountMetric;
        this.monitoredRequestCountMetric = builder.monitoredRequestCountMetric;
    }

    public final boolean hasKeyAttributes() {
        return this.keyAttributes != null && !(this.keyAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> keyAttributes() {
        return this.keyAttributes;
    }

    public final String operationName() {
        return this.operationName;
    }

    public final ServiceLevelIndicatorMetricType metricType() {
        return ServiceLevelIndicatorMetricType.fromValue(this.metricType);
    }

    public final String metricTypeAsString() {
        return this.metricType;
    }

    public final boolean hasTotalRequestCountMetric() {
        return this.totalRequestCountMetric != null && !(this.totalRequestCountMetric instanceof SdkAutoConstructList);
    }

    public final List<MetricDataQuery> totalRequestCountMetric() {
        return this.totalRequestCountMetric;
    }

    public final MonitoredRequestCountMetricDataQueries monitoredRequestCountMetric() {
        return this.monitoredRequestCountMetric;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeyAttributes() ? this.keyAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.operationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTotalRequestCountMetric() ? this.totalRequestCountMetric() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoredRequestCountMetric());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestBasedServiceLevelIndicatorMetric)) {
            return false;
        }
        RequestBasedServiceLevelIndicatorMetric other = (RequestBasedServiceLevelIndicatorMetric)obj;
        return this.hasKeyAttributes() == other.hasKeyAttributes() && Objects.equals(this.keyAttributes(), other.keyAttributes()) && Objects.equals(this.operationName(), other.operationName()) && Objects.equals(this.metricTypeAsString(), other.metricTypeAsString()) && this.hasTotalRequestCountMetric() == other.hasTotalRequestCountMetric() && Objects.equals(this.totalRequestCountMetric(), other.totalRequestCountMetric()) && Objects.equals(this.monitoredRequestCountMetric(), other.monitoredRequestCountMetric());
    }

    public final String toString() {
        return ToString.builder((String)"RequestBasedServiceLevelIndicatorMetric").add("KeyAttributes", this.hasKeyAttributes() ? this.keyAttributes() : null).add("OperationName", (Object)this.operationName()).add("MetricType", (Object)this.metricTypeAsString()).add("TotalRequestCountMetric", this.hasTotalRequestCountMetric() ? this.totalRequestCountMetric() : null).add("MonitoredRequestCountMetric", (Object)this.monitoredRequestCountMetric()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyAttributes": {
                return Optional.ofNullable(clazz.cast(this.keyAttributes()));
            }
            case "OperationName": {
                return Optional.ofNullable(clazz.cast(this.operationName()));
            }
            case "MetricType": {
                return Optional.ofNullable(clazz.cast(this.metricTypeAsString()));
            }
            case "TotalRequestCountMetric": {
                return Optional.ofNullable(clazz.cast(this.totalRequestCountMetric()));
            }
            case "MonitoredRequestCountMetric": {
                return Optional.ofNullable(clazz.cast(this.monitoredRequestCountMetric()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RequestBasedServiceLevelIndicatorMetric, T> g) {
        return obj -> g.apply((RequestBasedServiceLevelIndicatorMetric)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> keyAttributes = DefaultSdkAutoConstructMap.getInstance();
        private String operationName;
        private String metricType;
        private List<MetricDataQuery> totalRequestCountMetric = DefaultSdkAutoConstructList.getInstance();
        private MonitoredRequestCountMetricDataQueries monitoredRequestCountMetric;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestBasedServiceLevelIndicatorMetric model) {
            this.keyAttributes(model.keyAttributes);
            this.operationName(model.operationName);
            this.metricType(model.metricType);
            this.totalRequestCountMetric(model.totalRequestCountMetric);
            this.monitoredRequestCountMetric(model.monitoredRequestCountMetric);
        }

        public final Map<String, String> getKeyAttributes() {
            if (this.keyAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.keyAttributes;
        }

        public final void setKeyAttributes(Map<String, String> keyAttributes) {
            this.keyAttributes = AttributesCopier.copy(keyAttributes);
        }

        @Override
        public final Builder keyAttributes(Map<String, String> keyAttributes) {
            this.keyAttributes = AttributesCopier.copy(keyAttributes);
            return this;
        }

        public final String getOperationName() {
            return this.operationName;
        }

        public final void setOperationName(String operationName) {
            this.operationName = operationName;
        }

        @Override
        public final Builder operationName(String operationName) {
            this.operationName = operationName;
            return this;
        }

        public final String getMetricType() {
            return this.metricType;
        }

        public final void setMetricType(String metricType) {
            this.metricType = metricType;
        }

        @Override
        public final Builder metricType(String metricType) {
            this.metricType = metricType;
            return this;
        }

        @Override
        public final Builder metricType(ServiceLevelIndicatorMetricType metricType) {
            this.metricType(metricType == null ? null : metricType.toString());
            return this;
        }

        public final List<MetricDataQuery.Builder> getTotalRequestCountMetric() {
            List<MetricDataQuery.Builder> result = MetricDataQueriesCopier.copyToBuilder(this.totalRequestCountMetric);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTotalRequestCountMetric(Collection<MetricDataQuery.BuilderImpl> totalRequestCountMetric) {
            this.totalRequestCountMetric = MetricDataQueriesCopier.copyFromBuilder(totalRequestCountMetric);
        }

        @Override
        public final Builder totalRequestCountMetric(Collection<MetricDataQuery> totalRequestCountMetric) {
            this.totalRequestCountMetric = MetricDataQueriesCopier.copy(totalRequestCountMetric);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder totalRequestCountMetric(MetricDataQuery ... totalRequestCountMetric) {
            this.totalRequestCountMetric(Arrays.asList(totalRequestCountMetric));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder totalRequestCountMetric(Consumer<MetricDataQuery.Builder> ... totalRequestCountMetric) {
            this.totalRequestCountMetric(Stream.of(totalRequestCountMetric).map(c -> (MetricDataQuery)((MetricDataQuery.Builder)MetricDataQuery.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final MonitoredRequestCountMetricDataQueries.Builder getMonitoredRequestCountMetric() {
            return this.monitoredRequestCountMetric != null ? this.monitoredRequestCountMetric.toBuilder() : null;
        }

        public final void setMonitoredRequestCountMetric(MonitoredRequestCountMetricDataQueries.BuilderImpl monitoredRequestCountMetric) {
            this.monitoredRequestCountMetric = monitoredRequestCountMetric != null ? monitoredRequestCountMetric.build() : null;
        }

        @Override
        public final Builder monitoredRequestCountMetric(MonitoredRequestCountMetricDataQueries monitoredRequestCountMetric) {
            this.monitoredRequestCountMetric = monitoredRequestCountMetric;
            return this;
        }

        public RequestBasedServiceLevelIndicatorMetric build() {
            return new RequestBasedServiceLevelIndicatorMetric(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RequestBasedServiceLevelIndicatorMetric> {
        public Builder keyAttributes(Map<String, String> var1);

        public Builder operationName(String var1);

        public Builder metricType(String var1);

        public Builder metricType(ServiceLevelIndicatorMetricType var1);

        public Builder totalRequestCountMetric(Collection<MetricDataQuery> var1);

        public Builder totalRequestCountMetric(MetricDataQuery ... var1);

        public Builder totalRequestCountMetric(Consumer<MetricDataQuery.Builder> ... var1);

        public Builder monitoredRequestCountMetric(MonitoredRequestCountMetricDataQueries var1);

        default public Builder monitoredRequestCountMetric(Consumer<MonitoredRequestCountMetricDataQueries.Builder> monitoredRequestCountMetric) {
            return this.monitoredRequestCountMetric((MonitoredRequestCountMetricDataQueries)((MonitoredRequestCountMetricDataQueries.Builder)MonitoredRequestCountMetricDataQueries.builder().applyMutation(monitoredRequestCountMetric)).build());
        }
    }
}

