/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationsignals.model.ApplicationSignalsRequest;
import software.amazon.awssdk.services.applicationsignals.model.ServiceLevelObjectiveIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetServiceLevelObjectiveBudgetReportRequest
extends ApplicationSignalsRequest
implements ToCopyableBuilder<Builder, BatchGetServiceLevelObjectiveBudgetReportRequest> {
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Timestamp").getter(BatchGetServiceLevelObjectiveBudgetReportRequest.getter(BatchGetServiceLevelObjectiveBudgetReportRequest::timestamp)).setter(BatchGetServiceLevelObjectiveBudgetReportRequest.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()}).build();
    private static final SdkField<List<String>> SLO_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SloIds").getter(BatchGetServiceLevelObjectiveBudgetReportRequest.getter(BatchGetServiceLevelObjectiveBudgetReportRequest::sloIds)).setter(BatchGetServiceLevelObjectiveBudgetReportRequest.setter(Builder::sloIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SloIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FIELD, SLO_IDS_FIELD));
    private final Instant timestamp;
    private final List<String> sloIds;

    private BatchGetServiceLevelObjectiveBudgetReportRequest(BuilderImpl builder) {
        super(builder);
        this.timestamp = builder.timestamp;
        this.sloIds = builder.sloIds;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public final boolean hasSloIds() {
        return this.sloIds != null && !(this.sloIds instanceof SdkAutoConstructList);
    }

    public final List<String> sloIds() {
        return this.sloIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSloIds() ? this.sloIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetServiceLevelObjectiveBudgetReportRequest)) {
            return false;
        }
        BatchGetServiceLevelObjectiveBudgetReportRequest other = (BatchGetServiceLevelObjectiveBudgetReportRequest)((Object)obj);
        return Objects.equals(this.timestamp(), other.timestamp()) && this.hasSloIds() == other.hasSloIds() && Objects.equals(this.sloIds(), other.sloIds());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetServiceLevelObjectiveBudgetReportRequest").add("Timestamp", (Object)this.timestamp()).add("SloIds", this.hasSloIds() ? this.sloIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "SloIds": {
                return Optional.ofNullable(clazz.cast(this.sloIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetServiceLevelObjectiveBudgetReportRequest, T> g) {
        return obj -> g.apply((BatchGetServiceLevelObjectiveBudgetReportRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationSignalsRequest.BuilderImpl
    implements Builder {
        private Instant timestamp;
        private List<String> sloIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetServiceLevelObjectiveBudgetReportRequest model) {
            super(model);
            this.timestamp(model.timestamp);
            this.sloIds(model.sloIds);
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final Collection<String> getSloIds() {
            if (this.sloIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sloIds;
        }

        public final void setSloIds(Collection<String> sloIds) {
            this.sloIds = ServiceLevelObjectiveIdsCopier.copy(sloIds);
        }

        @Override
        public final Builder sloIds(Collection<String> sloIds) {
            this.sloIds = ServiceLevelObjectiveIdsCopier.copy(sloIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sloIds(String ... sloIds) {
            this.sloIds(Arrays.asList(sloIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetServiceLevelObjectiveBudgetReportRequest build() {
            return new BatchGetServiceLevelObjectiveBudgetReportRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApplicationSignalsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetServiceLevelObjectiveBudgetReportRequest> {
        public Builder timestamp(Instant var1);

        public Builder sloIds(Collection<String> var1);

        public Builder sloIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

