/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.applicationsignals.model.Goal;
import software.amazon.awssdk.services.applicationsignals.model.ServiceLevelIndicator;
import software.amazon.awssdk.services.applicationsignals.model.ServiceLevelObjectiveBudgetStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceLevelObjectiveBudgetReport
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceLevelObjectiveBudgetReport> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ServiceLevelObjectiveBudgetReport.getter(ServiceLevelObjectiveBudgetReport::arn)).setter(ServiceLevelObjectiveBudgetReport.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ServiceLevelObjectiveBudgetReport.getter(ServiceLevelObjectiveBudgetReport::name)).setter(ServiceLevelObjectiveBudgetReport.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> BUDGET_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BudgetStatus").getter(ServiceLevelObjectiveBudgetReport.getter(ServiceLevelObjectiveBudgetReport::budgetStatusAsString)).setter(ServiceLevelObjectiveBudgetReport.setter(Builder::budgetStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BudgetStatus").build()}).build();
    private static final SdkField<Double> ATTAINMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Attainment").getter(ServiceLevelObjectiveBudgetReport.getter(ServiceLevelObjectiveBudgetReport::attainment)).setter(ServiceLevelObjectiveBudgetReport.setter(Builder::attainment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attainment").build()}).build();
    private static final SdkField<Integer> TOTAL_BUDGET_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalBudgetSeconds").getter(ServiceLevelObjectiveBudgetReport.getter(ServiceLevelObjectiveBudgetReport::totalBudgetSeconds)).setter(ServiceLevelObjectiveBudgetReport.setter(Builder::totalBudgetSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalBudgetSeconds").build()}).build();
    private static final SdkField<Integer> BUDGET_SECONDS_REMAINING_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BudgetSecondsRemaining").getter(ServiceLevelObjectiveBudgetReport.getter(ServiceLevelObjectiveBudgetReport::budgetSecondsRemaining)).setter(ServiceLevelObjectiveBudgetReport.setter(Builder::budgetSecondsRemaining)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BudgetSecondsRemaining").build()}).build();
    private static final SdkField<ServiceLevelIndicator> SLI_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Sli").getter(ServiceLevelObjectiveBudgetReport.getter(ServiceLevelObjectiveBudgetReport::sli)).setter(ServiceLevelObjectiveBudgetReport.setter(Builder::sli)).constructor(ServiceLevelIndicator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sli").build()}).build();
    private static final SdkField<Goal> GOAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Goal").getter(ServiceLevelObjectiveBudgetReport.getter(ServiceLevelObjectiveBudgetReport::goal)).setter(ServiceLevelObjectiveBudgetReport.setter(Builder::goal)).constructor(Goal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Goal").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, BUDGET_STATUS_FIELD, ATTAINMENT_FIELD, TOTAL_BUDGET_SECONDS_FIELD, BUDGET_SECONDS_REMAINING_FIELD, SLI_FIELD, GOAL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final String budgetStatus;
    private final Double attainment;
    private final Integer totalBudgetSeconds;
    private final Integer budgetSecondsRemaining;
    private final ServiceLevelIndicator sli;
    private final Goal goal;

    private ServiceLevelObjectiveBudgetReport(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.budgetStatus = builder.budgetStatus;
        this.attainment = builder.attainment;
        this.totalBudgetSeconds = builder.totalBudgetSeconds;
        this.budgetSecondsRemaining = builder.budgetSecondsRemaining;
        this.sli = builder.sli;
        this.goal = builder.goal;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final ServiceLevelObjectiveBudgetStatus budgetStatus() {
        return ServiceLevelObjectiveBudgetStatus.fromValue(this.budgetStatus);
    }

    public final String budgetStatusAsString() {
        return this.budgetStatus;
    }

    public final Double attainment() {
        return this.attainment;
    }

    public final Integer totalBudgetSeconds() {
        return this.totalBudgetSeconds;
    }

    public final Integer budgetSecondsRemaining() {
        return this.budgetSecondsRemaining;
    }

    public final ServiceLevelIndicator sli() {
        return this.sli;
    }

    public final Goal goal() {
        return this.goal;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.budgetStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.attainment());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalBudgetSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.budgetSecondsRemaining());
        hashCode = 31 * hashCode + Objects.hashCode(this.sli());
        hashCode = 31 * hashCode + Objects.hashCode(this.goal());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceLevelObjectiveBudgetReport)) {
            return false;
        }
        ServiceLevelObjectiveBudgetReport other = (ServiceLevelObjectiveBudgetReport)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.budgetStatusAsString(), other.budgetStatusAsString()) && Objects.equals(this.attainment(), other.attainment()) && Objects.equals(this.totalBudgetSeconds(), other.totalBudgetSeconds()) && Objects.equals(this.budgetSecondsRemaining(), other.budgetSecondsRemaining()) && Objects.equals(this.sli(), other.sli()) && Objects.equals(this.goal(), other.goal());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceLevelObjectiveBudgetReport").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("BudgetStatus", (Object)this.budgetStatusAsString()).add("Attainment", (Object)this.attainment()).add("TotalBudgetSeconds", (Object)this.totalBudgetSeconds()).add("BudgetSecondsRemaining", (Object)this.budgetSecondsRemaining()).add("Sli", (Object)this.sli()).add("Goal", (Object)this.goal()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "BudgetStatus": {
                return Optional.ofNullable(clazz.cast(this.budgetStatusAsString()));
            }
            case "Attainment": {
                return Optional.ofNullable(clazz.cast(this.attainment()));
            }
            case "TotalBudgetSeconds": {
                return Optional.ofNullable(clazz.cast(this.totalBudgetSeconds()));
            }
            case "BudgetSecondsRemaining": {
                return Optional.ofNullable(clazz.cast(this.budgetSecondsRemaining()));
            }
            case "Sli": {
                return Optional.ofNullable(clazz.cast(this.sli()));
            }
            case "Goal": {
                return Optional.ofNullable(clazz.cast(this.goal()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceLevelObjectiveBudgetReport, T> g) {
        return obj -> g.apply((ServiceLevelObjectiveBudgetReport)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String budgetStatus;
        private Double attainment;
        private Integer totalBudgetSeconds;
        private Integer budgetSecondsRemaining;
        private ServiceLevelIndicator sli;
        private Goal goal;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceLevelObjectiveBudgetReport model) {
            this.arn(model.arn);
            this.name(model.name);
            this.budgetStatus(model.budgetStatus);
            this.attainment(model.attainment);
            this.totalBudgetSeconds(model.totalBudgetSeconds);
            this.budgetSecondsRemaining(model.budgetSecondsRemaining);
            this.sli(model.sli);
            this.goal(model.goal);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getBudgetStatus() {
            return this.budgetStatus;
        }

        public final void setBudgetStatus(String budgetStatus) {
            this.budgetStatus = budgetStatus;
        }

        @Override
        public final Builder budgetStatus(String budgetStatus) {
            this.budgetStatus = budgetStatus;
            return this;
        }

        @Override
        public final Builder budgetStatus(ServiceLevelObjectiveBudgetStatus budgetStatus) {
            this.budgetStatus(budgetStatus == null ? null : budgetStatus.toString());
            return this;
        }

        public final Double getAttainment() {
            return this.attainment;
        }

        public final void setAttainment(Double attainment) {
            this.attainment = attainment;
        }

        @Override
        public final Builder attainment(Double attainment) {
            this.attainment = attainment;
            return this;
        }

        public final Integer getTotalBudgetSeconds() {
            return this.totalBudgetSeconds;
        }

        public final void setTotalBudgetSeconds(Integer totalBudgetSeconds) {
            this.totalBudgetSeconds = totalBudgetSeconds;
        }

        @Override
        public final Builder totalBudgetSeconds(Integer totalBudgetSeconds) {
            this.totalBudgetSeconds = totalBudgetSeconds;
            return this;
        }

        public final Integer getBudgetSecondsRemaining() {
            return this.budgetSecondsRemaining;
        }

        public final void setBudgetSecondsRemaining(Integer budgetSecondsRemaining) {
            this.budgetSecondsRemaining = budgetSecondsRemaining;
        }

        @Override
        public final Builder budgetSecondsRemaining(Integer budgetSecondsRemaining) {
            this.budgetSecondsRemaining = budgetSecondsRemaining;
            return this;
        }

        public final ServiceLevelIndicator.Builder getSli() {
            return this.sli != null ? this.sli.toBuilder() : null;
        }

        public final void setSli(ServiceLevelIndicator.BuilderImpl sli) {
            this.sli = sli != null ? sli.build() : null;
        }

        @Override
        public final Builder sli(ServiceLevelIndicator sli) {
            this.sli = sli;
            return this;
        }

        public final Goal.Builder getGoal() {
            return this.goal != null ? this.goal.toBuilder() : null;
        }

        public final void setGoal(Goal.BuilderImpl goal) {
            this.goal = goal != null ? goal.build() : null;
        }

        @Override
        public final Builder goal(Goal goal) {
            this.goal = goal;
            return this;
        }

        public ServiceLevelObjectiveBudgetReport build() {
            return new ServiceLevelObjectiveBudgetReport(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceLevelObjectiveBudgetReport> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder budgetStatus(String var1);

        public Builder budgetStatus(ServiceLevelObjectiveBudgetStatus var1);

        public Builder attainment(Double var1);

        public Builder totalBudgetSeconds(Integer var1);

        public Builder budgetSecondsRemaining(Integer var1);

        public Builder sli(ServiceLevelIndicator var1);

        default public Builder sli(Consumer<ServiceLevelIndicator.Builder> sli) {
            return this.sli((ServiceLevelIndicator)((ServiceLevelIndicator.Builder)ServiceLevelIndicator.builder().applyMutation(sli)).build());
        }

        public Builder goal(Goal var1);

        default public Builder goal(Consumer<Goal.Builder> goal) {
            return this.goal((Goal)((Goal.Builder)Goal.builder().applyMutation(goal)).build());
        }
    }
}

