/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationsignals.model.ApplicationSignalsResponse;
import software.amazon.awssdk.services.applicationsignals.model.LogGroupReferencesCopier;
import software.amazon.awssdk.services.applicationsignals.model.Service;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetServiceResponse
extends ApplicationSignalsResponse
implements ToCopyableBuilder<Builder, GetServiceResponse> {
    private static final SdkField<Service> SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Service").getter(GetServiceResponse.getter(GetServiceResponse::service)).setter(GetServiceResponse.setter(Builder::service)).constructor(Service::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Service").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(GetServiceResponse.getter(GetServiceResponse::startTime)).setter(GetServiceResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(GetServiceResponse.getter(GetServiceResponse::endTime)).setter(GetServiceResponse.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<List<Map<String, String>>> LOG_GROUP_REFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LogGroupReferences").getter(GetServiceResponse.getter(GetServiceResponse::logGroupReferences)).setter(GetServiceResponse.setter(Builder::logGroupReferences)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroupReferences").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_FIELD, START_TIME_FIELD, END_TIME_FIELD, LOG_GROUP_REFERENCES_FIELD));
    private final Service service;
    private final Instant startTime;
    private final Instant endTime;
    private final List<Map<String, String>> logGroupReferences;

    private GetServiceResponse(BuilderImpl builder) {
        super(builder);
        this.service = builder.service;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.logGroupReferences = builder.logGroupReferences;
    }

    public final Service service() {
        return this.service;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final boolean hasLogGroupReferences() {
        return this.logGroupReferences != null && !(this.logGroupReferences instanceof SdkAutoConstructList);
    }

    public final List<Map<String, String>> logGroupReferences() {
        return this.logGroupReferences;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.service());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogGroupReferences() ? this.logGroupReferences() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServiceResponse)) {
            return false;
        }
        GetServiceResponse other = (GetServiceResponse)((Object)obj);
        return Objects.equals(this.service(), other.service()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && this.hasLogGroupReferences() == other.hasLogGroupReferences() && Objects.equals(this.logGroupReferences(), other.logGroupReferences());
    }

    public final String toString() {
        return ToString.builder((String)"GetServiceResponse").add("Service", (Object)this.service()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("LogGroupReferences", this.hasLogGroupReferences() ? this.logGroupReferences() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Service": {
                return Optional.ofNullable(clazz.cast(this.service()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "LogGroupReferences": {
                return Optional.ofNullable(clazz.cast(this.logGroupReferences()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetServiceResponse, T> g) {
        return obj -> g.apply((GetServiceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationSignalsResponse.BuilderImpl
    implements Builder {
        private Service service;
        private Instant startTime;
        private Instant endTime;
        private List<Map<String, String>> logGroupReferences = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetServiceResponse model) {
            super(model);
            this.service(model.service);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.logGroupReferences(model.logGroupReferences);
        }

        public final Service.Builder getService() {
            return this.service != null ? this.service.toBuilder() : null;
        }

        public final void setService(Service.BuilderImpl service) {
            this.service = service != null ? service.build() : null;
        }

        @Override
        public final Builder service(Service service) {
            this.service = service;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Collection<? extends Map<String, String>> getLogGroupReferences() {
            if (this.logGroupReferences instanceof SdkAutoConstructList) {
                return null;
            }
            return this.logGroupReferences;
        }

        public final void setLogGroupReferences(Collection<? extends Map<String, String>> logGroupReferences) {
            this.logGroupReferences = LogGroupReferencesCopier.copy(logGroupReferences);
        }

        @Override
        public final Builder logGroupReferences(Collection<? extends Map<String, String>> logGroupReferences) {
            this.logGroupReferences = LogGroupReferencesCopier.copy(logGroupReferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logGroupReferences(Map<String, String> ... logGroupReferences) {
            this.logGroupReferences(Arrays.asList(logGroupReferences));
            return this;
        }

        @Override
        public GetServiceResponse build() {
            return new GetServiceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApplicationSignalsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetServiceResponse> {
        public Builder service(Service var1);

        default public Builder service(Consumer<Service.Builder> service) {
            return this.service((Service)((Service.Builder)Service.builder().applyMutation(service)).build());
        }

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder logGroupReferences(Collection<? extends Map<String, String>> var1);

        public Builder logGroupReferences(Map<String, String> ... var1);
    }
}

