/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateWorkloadRequest extends ApplicationInsightsRequest implements
        ToCopyableBuilder<UpdateWorkloadRequest.Builder, UpdateWorkloadRequest> {
    private static final SdkField<String> RESOURCE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceGroupName").getter(getter(UpdateWorkloadRequest::resourceGroupName))
            .setter(setter(Builder::resourceGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceGroupName").build()).build();

    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComponentName").getter(getter(UpdateWorkloadRequest::componentName))
            .setter(setter(Builder::componentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentName").build()).build();

    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkloadId").getter(getter(UpdateWorkloadRequest::workloadId)).setter(setter(Builder::workloadId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadId").build()).build();

    private static final SdkField<WorkloadConfiguration> WORKLOAD_CONFIGURATION_FIELD = SdkField
            .<WorkloadConfiguration> builder(MarshallingType.SDK_POJO).memberName("WorkloadConfiguration")
            .getter(getter(UpdateWorkloadRequest::workloadConfiguration)).setter(setter(Builder::workloadConfiguration))
            .constructor(WorkloadConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_GROUP_NAME_FIELD,
            COMPONENT_NAME_FIELD, WORKLOAD_ID_FIELD, WORKLOAD_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String resourceGroupName;

    private final String componentName;

    private final String workloadId;

    private final WorkloadConfiguration workloadConfiguration;

    private UpdateWorkloadRequest(BuilderImpl builder) {
        super(builder);
        this.resourceGroupName = builder.resourceGroupName;
        this.componentName = builder.componentName;
        this.workloadId = builder.workloadId;
        this.workloadConfiguration = builder.workloadConfiguration;
    }

    /**
     * <p>
     * The name of the resource group.
     * </p>
     * 
     * @return The name of the resource group.
     */
    public final String resourceGroupName() {
        return resourceGroupName;
    }

    /**
     * <p>
     * The name of the component.
     * </p>
     * 
     * @return The name of the component.
     */
    public final String componentName() {
        return componentName;
    }

    /**
     * <p>
     * The ID of the workload.
     * </p>
     * 
     * @return The ID of the workload.
     */
    public final String workloadId() {
        return workloadId;
    }

    /**
     * <p>
     * The configuration settings of the workload. The value is the escaped JSON of the configuration.
     * </p>
     * 
     * @return The configuration settings of the workload. The value is the escaped JSON of the configuration.
     */
    public final WorkloadConfiguration workloadConfiguration() {
        return workloadConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(componentName());
        hashCode = 31 * hashCode + Objects.hashCode(workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(workloadConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkloadRequest)) {
            return false;
        }
        UpdateWorkloadRequest other = (UpdateWorkloadRequest) obj;
        return Objects.equals(resourceGroupName(), other.resourceGroupName())
                && Objects.equals(componentName(), other.componentName()) && Objects.equals(workloadId(), other.workloadId())
                && Objects.equals(workloadConfiguration(), other.workloadConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateWorkloadRequest").add("ResourceGroupName", resourceGroupName())
                .add("ComponentName", componentName()).add("WorkloadId", workloadId())
                .add("WorkloadConfiguration", workloadConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceGroupName":
            return Optional.ofNullable(clazz.cast(resourceGroupName()));
        case "ComponentName":
            return Optional.ofNullable(clazz.cast(componentName()));
        case "WorkloadId":
            return Optional.ofNullable(clazz.cast(workloadId()));
        case "WorkloadConfiguration":
            return Optional.ofNullable(clazz.cast(workloadConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceGroupName", RESOURCE_GROUP_NAME_FIELD);
        map.put("ComponentName", COMPONENT_NAME_FIELD);
        map.put("WorkloadId", WORKLOAD_ID_FIELD);
        map.put("WorkloadConfiguration", WORKLOAD_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkloadRequest, T> g) {
        return obj -> g.apply((UpdateWorkloadRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ApplicationInsightsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateWorkloadRequest> {
        /**
         * <p>
         * The name of the resource group.
         * </p>
         * 
         * @param resourceGroupName
         *        The name of the resource group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceGroupName(String resourceGroupName);

        /**
         * <p>
         * The name of the component.
         * </p>
         * 
         * @param componentName
         *        The name of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentName(String componentName);

        /**
         * <p>
         * The ID of the workload.
         * </p>
         * 
         * @param workloadId
         *        The ID of the workload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadId(String workloadId);

        /**
         * <p>
         * The configuration settings of the workload. The value is the escaped JSON of the configuration.
         * </p>
         * 
         * @param workloadConfiguration
         *        The configuration settings of the workload. The value is the escaped JSON of the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadConfiguration(WorkloadConfiguration workloadConfiguration);

        /**
         * <p>
         * The configuration settings of the workload. The value is the escaped JSON of the configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link WorkloadConfiguration.Builder} avoiding
         * the need to create one manually via {@link WorkloadConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkloadConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #workloadConfiguration(WorkloadConfiguration)}.
         * 
         * @param workloadConfiguration
         *        a consumer that will call methods on {@link WorkloadConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workloadConfiguration(WorkloadConfiguration)
         */
        default Builder workloadConfiguration(Consumer<WorkloadConfiguration.Builder> workloadConfiguration) {
            return workloadConfiguration(WorkloadConfiguration.builder().applyMutation(workloadConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApplicationInsightsRequest.BuilderImpl implements Builder {
        private String resourceGroupName;

        private String componentName;

        private String workloadId;

        private WorkloadConfiguration workloadConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkloadRequest model) {
            super(model);
            resourceGroupName(model.resourceGroupName);
            componentName(model.componentName);
            workloadId(model.workloadId);
            workloadConfiguration(model.workloadConfiguration);
        }

        public final String getResourceGroupName() {
            return resourceGroupName;
        }

        public final void setResourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
        }

        @Override
        public final Builder resourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
            return this;
        }

        public final String getComponentName() {
            return componentName;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        @Override
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final String getWorkloadId() {
            return workloadId;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final WorkloadConfiguration.Builder getWorkloadConfiguration() {
            return workloadConfiguration != null ? workloadConfiguration.toBuilder() : null;
        }

        public final void setWorkloadConfiguration(WorkloadConfiguration.BuilderImpl workloadConfiguration) {
            this.workloadConfiguration = workloadConfiguration != null ? workloadConfiguration.build() : null;
        }

        @Override
        public final Builder workloadConfiguration(WorkloadConfiguration workloadConfiguration) {
            this.workloadConfiguration = workloadConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWorkloadRequest build() {
            return new UpdateWorkloadRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
