/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.applicationinsights.ApplicationInsightsClient;
import software.amazon.awssdk.services.applicationinsights.internal.UserAgentUtils;
import software.amazon.awssdk.services.applicationinsights.model.ListWorkloadsRequest;
import software.amazon.awssdk.services.applicationinsights.model.ListWorkloadsResponse;

public class ListWorkloadsIterable
implements SdkIterable<ListWorkloadsResponse> {
    private final ApplicationInsightsClient client;
    private final ListWorkloadsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWorkloadsIterable(ApplicationInsightsClient client, ListWorkloadsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListWorkloadsResponseFetcher();
    }

    public Iterator<ListWorkloadsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListWorkloadsResponseFetcher
    implements SyncPageFetcher<ListWorkloadsResponse> {
        private ListWorkloadsResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkloadsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWorkloadsResponse nextPage(ListWorkloadsResponse previousPage) {
            if (previousPage == null) {
                return ListWorkloadsIterable.this.client.listWorkloads(ListWorkloadsIterable.this.firstRequest);
            }
            return ListWorkloadsIterable.this.client.listWorkloads((ListWorkloadsRequest)((Object)ListWorkloadsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

