/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FeedbackKey {
    INSIGHTS_FEEDBACK("INSIGHTS_FEEDBACK"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FeedbackKey> VALUE_MAP;
    private final String value;

    private FeedbackKey(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FeedbackKey fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FeedbackKey> knownValues() {
        EnumSet<FeedbackKey> knownValues = EnumSet.allOf(FeedbackKey.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FeedbackKey.class, FeedbackKey::toString);
    }
}

