/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.applicationinsights.model.ApplicationInfo;
import software.amazon.awssdk.services.applicationinsights.model.ApplicationInsightsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateApplicationResponse
extends ApplicationInsightsResponse
implements ToCopyableBuilder<Builder, CreateApplicationResponse> {
    private static final SdkField<ApplicationInfo> APPLICATION_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApplicationInfo").getter(CreateApplicationResponse.getter(CreateApplicationResponse::applicationInfo)).setter(CreateApplicationResponse.setter(Builder::applicationInfo)).constructor(ApplicationInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_INFO_FIELD));
    private final ApplicationInfo applicationInfo;

    private CreateApplicationResponse(BuilderImpl builder) {
        super(builder);
        this.applicationInfo = builder.applicationInfo;
    }

    public final ApplicationInfo applicationInfo() {
        return this.applicationInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationInfo());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationResponse)) {
            return false;
        }
        CreateApplicationResponse other = (CreateApplicationResponse)((Object)obj);
        return Objects.equals(this.applicationInfo(), other.applicationInfo());
    }

    public final String toString() {
        return ToString.builder((String)"CreateApplicationResponse").add("ApplicationInfo", (Object)this.applicationInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationInfo": {
                return Optional.ofNullable(clazz.cast(this.applicationInfo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateApplicationResponse, T> g) {
        return obj -> g.apply((CreateApplicationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationInsightsResponse.BuilderImpl
    implements Builder {
        private ApplicationInfo applicationInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationResponse model) {
            super(model);
            this.applicationInfo(model.applicationInfo);
        }

        public final ApplicationInfo.Builder getApplicationInfo() {
            return this.applicationInfo != null ? this.applicationInfo.toBuilder() : null;
        }

        public final void setApplicationInfo(ApplicationInfo.BuilderImpl applicationInfo) {
            this.applicationInfo = applicationInfo != null ? applicationInfo.build() : null;
        }

        @Override
        public final Builder applicationInfo(ApplicationInfo applicationInfo) {
            this.applicationInfo = applicationInfo;
            return this;
        }

        @Override
        public CreateApplicationResponse build() {
            return new CreateApplicationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApplicationInsightsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateApplicationResponse> {
        public Builder applicationInfo(ApplicationInfo var1);

        default public Builder applicationInfo(Consumer<ApplicationInfo.Builder> applicationInfo) {
            return this.applicationInfo((ApplicationInfo)((ApplicationInfo.Builder)ApplicationInfo.builder().applyMutation(applicationInfo)).build());
        }
    }
}

