/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.applicationinsights.ApplicationInsightsClient;
import software.amazon.awssdk.services.applicationinsights.internal.UserAgentUtils;
import software.amazon.awssdk.services.applicationinsights.model.ListConfigurationHistoryRequest;
import software.amazon.awssdk.services.applicationinsights.model.ListConfigurationHistoryResponse;

public class ListConfigurationHistoryIterable
implements SdkIterable<ListConfigurationHistoryResponse> {
    private final ApplicationInsightsClient client;
    private final ListConfigurationHistoryRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListConfigurationHistoryIterable(ApplicationInsightsClient client, ListConfigurationHistoryRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListConfigurationHistoryResponseFetcher();
    }

    public Iterator<ListConfigurationHistoryResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListConfigurationHistoryResponseFetcher
    implements SyncPageFetcher<ListConfigurationHistoryResponse> {
        private ListConfigurationHistoryResponseFetcher() {
        }

        public boolean hasNextPage(ListConfigurationHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListConfigurationHistoryResponse nextPage(ListConfigurationHistoryResponse previousPage) {
            if (previousPage == null) {
                return ListConfigurationHistoryIterable.this.client.listConfigurationHistory(ListConfigurationHistoryIterable.this.firstRequest);
            }
            return ListConfigurationHistoryIterable.this.client.listConfigurationHistory((ListConfigurationHistoryRequest)((Object)ListConfigurationHistoryIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

