/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationinsights.model.ApplicationInsightsRequest;
import software.amazon.awssdk.services.applicationinsights.model.GroupingType;
import software.amazon.awssdk.services.applicationinsights.model.Tag;
import software.amazon.awssdk.services.applicationinsights.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateApplicationRequest
extends ApplicationInsightsRequest
implements ToCopyableBuilder<Builder, CreateApplicationRequest> {
    private static final SdkField<String> RESOURCE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceGroupName").getter(CreateApplicationRequest.getter(CreateApplicationRequest::resourceGroupName)).setter(CreateApplicationRequest.setter(Builder::resourceGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceGroupName").build()}).build();
    private static final SdkField<Boolean> OPS_CENTER_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("OpsCenterEnabled").getter(CreateApplicationRequest.getter(CreateApplicationRequest::opsCenterEnabled)).setter(CreateApplicationRequest.setter(Builder::opsCenterEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsCenterEnabled").build()}).build();
    private static final SdkField<Boolean> CWE_MONITOR_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CWEMonitorEnabled").getter(CreateApplicationRequest.getter(CreateApplicationRequest::cweMonitorEnabled)).setter(CreateApplicationRequest.setter(Builder::cweMonitorEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CWEMonitorEnabled").build()}).build();
    private static final SdkField<String> OPS_ITEM_SNS_TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OpsItemSNSTopicArn").getter(CreateApplicationRequest.getter(CreateApplicationRequest::opsItemSNSTopicArn)).setter(CreateApplicationRequest.setter(Builder::opsItemSNSTopicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsItemSNSTopicArn").build()}).build();
    private static final SdkField<String> SNS_NOTIFICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SNSNotificationArn").getter(CreateApplicationRequest.getter(CreateApplicationRequest::snsNotificationArn)).setter(CreateApplicationRequest.setter(Builder::snsNotificationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SNSNotificationArn").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateApplicationRequest.getter(CreateApplicationRequest::tags)).setter(CreateApplicationRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> AUTO_CONFIG_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoConfigEnabled").getter(CreateApplicationRequest.getter(CreateApplicationRequest::autoConfigEnabled)).setter(CreateApplicationRequest.setter(Builder::autoConfigEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoConfigEnabled").build()}).build();
    private static final SdkField<Boolean> AUTO_CREATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoCreate").getter(CreateApplicationRequest.getter(CreateApplicationRequest::autoCreate)).setter(CreateApplicationRequest.setter(Builder::autoCreate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoCreate").build()}).build();
    private static final SdkField<String> GROUPING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupingType").getter(CreateApplicationRequest.getter(CreateApplicationRequest::groupingTypeAsString)).setter(CreateApplicationRequest.setter(Builder::groupingType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupingType").build()}).build();
    private static final SdkField<Boolean> ATTACH_MISSING_PERMISSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AttachMissingPermission").getter(CreateApplicationRequest.getter(CreateApplicationRequest::attachMissingPermission)).setter(CreateApplicationRequest.setter(Builder::attachMissingPermission)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachMissingPermission").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_GROUP_NAME_FIELD, OPS_CENTER_ENABLED_FIELD, CWE_MONITOR_ENABLED_FIELD, OPS_ITEM_SNS_TOPIC_ARN_FIELD, SNS_NOTIFICATION_ARN_FIELD, TAGS_FIELD, AUTO_CONFIG_ENABLED_FIELD, AUTO_CREATE_FIELD, GROUPING_TYPE_FIELD, ATTACH_MISSING_PERMISSION_FIELD));
    private final String resourceGroupName;
    private final Boolean opsCenterEnabled;
    private final Boolean cweMonitorEnabled;
    private final String opsItemSNSTopicArn;
    private final String snsNotificationArn;
    private final List<Tag> tags;
    private final Boolean autoConfigEnabled;
    private final Boolean autoCreate;
    private final String groupingType;
    private final Boolean attachMissingPermission;

    private CreateApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.resourceGroupName = builder.resourceGroupName;
        this.opsCenterEnabled = builder.opsCenterEnabled;
        this.cweMonitorEnabled = builder.cweMonitorEnabled;
        this.opsItemSNSTopicArn = builder.opsItemSNSTopicArn;
        this.snsNotificationArn = builder.snsNotificationArn;
        this.tags = builder.tags;
        this.autoConfigEnabled = builder.autoConfigEnabled;
        this.autoCreate = builder.autoCreate;
        this.groupingType = builder.groupingType;
        this.attachMissingPermission = builder.attachMissingPermission;
    }

    public final String resourceGroupName() {
        return this.resourceGroupName;
    }

    public final Boolean opsCenterEnabled() {
        return this.opsCenterEnabled;
    }

    public final Boolean cweMonitorEnabled() {
        return this.cweMonitorEnabled;
    }

    public final String opsItemSNSTopicArn() {
        return this.opsItemSNSTopicArn;
    }

    public final String snsNotificationArn() {
        return this.snsNotificationArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final Boolean autoConfigEnabled() {
        return this.autoConfigEnabled;
    }

    public final Boolean autoCreate() {
        return this.autoCreate;
    }

    public final GroupingType groupingType() {
        return GroupingType.fromValue(this.groupingType);
    }

    public final String groupingTypeAsString() {
        return this.groupingType;
    }

    public final Boolean attachMissingPermission() {
        return this.attachMissingPermission;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.opsCenterEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.cweMonitorEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.opsItemSNSTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsNotificationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.autoConfigEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoCreate());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachMissingPermission());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationRequest)) {
            return false;
        }
        CreateApplicationRequest other = (CreateApplicationRequest)((Object)obj);
        return Objects.equals(this.resourceGroupName(), other.resourceGroupName()) && Objects.equals(this.opsCenterEnabled(), other.opsCenterEnabled()) && Objects.equals(this.cweMonitorEnabled(), other.cweMonitorEnabled()) && Objects.equals(this.opsItemSNSTopicArn(), other.opsItemSNSTopicArn()) && Objects.equals(this.snsNotificationArn(), other.snsNotificationArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.autoConfigEnabled(), other.autoConfigEnabled()) && Objects.equals(this.autoCreate(), other.autoCreate()) && Objects.equals(this.groupingTypeAsString(), other.groupingTypeAsString()) && Objects.equals(this.attachMissingPermission(), other.attachMissingPermission());
    }

    public final String toString() {
        return ToString.builder((String)"CreateApplicationRequest").add("ResourceGroupName", (Object)this.resourceGroupName()).add("OpsCenterEnabled", (Object)this.opsCenterEnabled()).add("CWEMonitorEnabled", (Object)this.cweMonitorEnabled()).add("OpsItemSNSTopicArn", (Object)this.opsItemSNSTopicArn()).add("SNSNotificationArn", (Object)this.snsNotificationArn()).add("Tags", this.hasTags() ? this.tags() : null).add("AutoConfigEnabled", (Object)this.autoConfigEnabled()).add("AutoCreate", (Object)this.autoCreate()).add("GroupingType", (Object)this.groupingTypeAsString()).add("AttachMissingPermission", (Object)this.attachMissingPermission()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceGroupName": {
                return Optional.ofNullable(clazz.cast(this.resourceGroupName()));
            }
            case "OpsCenterEnabled": {
                return Optional.ofNullable(clazz.cast(this.opsCenterEnabled()));
            }
            case "CWEMonitorEnabled": {
                return Optional.ofNullable(clazz.cast(this.cweMonitorEnabled()));
            }
            case "OpsItemSNSTopicArn": {
                return Optional.ofNullable(clazz.cast(this.opsItemSNSTopicArn()));
            }
            case "SNSNotificationArn": {
                return Optional.ofNullable(clazz.cast(this.snsNotificationArn()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "AutoConfigEnabled": {
                return Optional.ofNullable(clazz.cast(this.autoConfigEnabled()));
            }
            case "AutoCreate": {
                return Optional.ofNullable(clazz.cast(this.autoCreate()));
            }
            case "GroupingType": {
                return Optional.ofNullable(clazz.cast(this.groupingTypeAsString()));
            }
            case "AttachMissingPermission": {
                return Optional.ofNullable(clazz.cast(this.attachMissingPermission()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateApplicationRequest, T> g) {
        return obj -> g.apply((CreateApplicationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationInsightsRequest.BuilderImpl
    implements Builder {
        private String resourceGroupName;
        private Boolean opsCenterEnabled;
        private Boolean cweMonitorEnabled;
        private String opsItemSNSTopicArn;
        private String snsNotificationArn;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Boolean autoConfigEnabled;
        private Boolean autoCreate;
        private String groupingType;
        private Boolean attachMissingPermission;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationRequest model) {
            super(model);
            this.resourceGroupName(model.resourceGroupName);
            this.opsCenterEnabled(model.opsCenterEnabled);
            this.cweMonitorEnabled(model.cweMonitorEnabled);
            this.opsItemSNSTopicArn(model.opsItemSNSTopicArn);
            this.snsNotificationArn(model.snsNotificationArn);
            this.tags(model.tags);
            this.autoConfigEnabled(model.autoConfigEnabled);
            this.autoCreate(model.autoCreate);
            this.groupingType(model.groupingType);
            this.attachMissingPermission(model.attachMissingPermission);
        }

        public final String getResourceGroupName() {
            return this.resourceGroupName;
        }

        public final void setResourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
        }

        @Override
        public final Builder resourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
            return this;
        }

        public final Boolean getOpsCenterEnabled() {
            return this.opsCenterEnabled;
        }

        public final void setOpsCenterEnabled(Boolean opsCenterEnabled) {
            this.opsCenterEnabled = opsCenterEnabled;
        }

        @Override
        public final Builder opsCenterEnabled(Boolean opsCenterEnabled) {
            this.opsCenterEnabled = opsCenterEnabled;
            return this;
        }

        public final Boolean getCweMonitorEnabled() {
            return this.cweMonitorEnabled;
        }

        public final void setCweMonitorEnabled(Boolean cweMonitorEnabled) {
            this.cweMonitorEnabled = cweMonitorEnabled;
        }

        @Override
        public final Builder cweMonitorEnabled(Boolean cweMonitorEnabled) {
            this.cweMonitorEnabled = cweMonitorEnabled;
            return this;
        }

        public final String getOpsItemSNSTopicArn() {
            return this.opsItemSNSTopicArn;
        }

        public final void setOpsItemSNSTopicArn(String opsItemSNSTopicArn) {
            this.opsItemSNSTopicArn = opsItemSNSTopicArn;
        }

        @Override
        public final Builder opsItemSNSTopicArn(String opsItemSNSTopicArn) {
            this.opsItemSNSTopicArn = opsItemSNSTopicArn;
            return this;
        }

        public final String getSnsNotificationArn() {
            return this.snsNotificationArn;
        }

        public final void setSnsNotificationArn(String snsNotificationArn) {
            this.snsNotificationArn = snsNotificationArn;
        }

        @Override
        public final Builder snsNotificationArn(String snsNotificationArn) {
            this.snsNotificationArn = snsNotificationArn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getAutoConfigEnabled() {
            return this.autoConfigEnabled;
        }

        public final void setAutoConfigEnabled(Boolean autoConfigEnabled) {
            this.autoConfigEnabled = autoConfigEnabled;
        }

        @Override
        public final Builder autoConfigEnabled(Boolean autoConfigEnabled) {
            this.autoConfigEnabled = autoConfigEnabled;
            return this;
        }

        public final Boolean getAutoCreate() {
            return this.autoCreate;
        }

        public final void setAutoCreate(Boolean autoCreate) {
            this.autoCreate = autoCreate;
        }

        @Override
        public final Builder autoCreate(Boolean autoCreate) {
            this.autoCreate = autoCreate;
            return this;
        }

        public final String getGroupingType() {
            return this.groupingType;
        }

        public final void setGroupingType(String groupingType) {
            this.groupingType = groupingType;
        }

        @Override
        public final Builder groupingType(String groupingType) {
            this.groupingType = groupingType;
            return this;
        }

        @Override
        public final Builder groupingType(GroupingType groupingType) {
            this.groupingType(groupingType == null ? null : groupingType.toString());
            return this;
        }

        public final Boolean getAttachMissingPermission() {
            return this.attachMissingPermission;
        }

        public final void setAttachMissingPermission(Boolean attachMissingPermission) {
            this.attachMissingPermission = attachMissingPermission;
        }

        @Override
        public final Builder attachMissingPermission(Boolean attachMissingPermission) {
            this.attachMissingPermission = attachMissingPermission;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateApplicationRequest build() {
            return new CreateApplicationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApplicationInsightsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateApplicationRequest> {
        public Builder resourceGroupName(String var1);

        public Builder opsCenterEnabled(Boolean var1);

        public Builder cweMonitorEnabled(Boolean var1);

        public Builder opsItemSNSTopicArn(String var1);

        public Builder snsNotificationArn(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder autoConfigEnabled(Boolean var1);

        public Builder autoCreate(Boolean var1);

        public Builder groupingType(String var1);

        public Builder groupingType(GroupingType var1);

        public Builder attachMissingPermission(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

