/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.applicationinsights.model.DetectedWorkloadCopier;
import software.amazon.awssdk.services.applicationinsights.model.OsType;
import software.amazon.awssdk.services.applicationinsights.model.Tier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationComponent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationComponent> {
    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComponentName").getter(ApplicationComponent.getter(ApplicationComponent::componentName)).setter(ApplicationComponent.setter(Builder::componentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentName").build()}).build();
    private static final SdkField<String> COMPONENT_REMARKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComponentRemarks").getter(ApplicationComponent.getter(ApplicationComponent::componentRemarks)).setter(ApplicationComponent.setter(Builder::componentRemarks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentRemarks").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(ApplicationComponent.getter(ApplicationComponent::resourceType)).setter(ApplicationComponent.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> OS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OsType").getter(ApplicationComponent.getter(ApplicationComponent::osTypeAsString)).setter(ApplicationComponent.setter(Builder::osType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OsType").build()}).build();
    private static final SdkField<String> TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Tier").getter(ApplicationComponent.getter(ApplicationComponent::tierAsString)).setter(ApplicationComponent.setter(Builder::tier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tier").build()}).build();
    private static final SdkField<Boolean> MONITOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Monitor").getter(ApplicationComponent.getter(ApplicationComponent::monitor)).setter(ApplicationComponent.setter(Builder::monitor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Monitor").build()}).build();
    private static final SdkField<Map<String, Map<String, String>>> DETECTED_WORKLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("DetectedWorkload").getter(ApplicationComponent.getter(ApplicationComponent::detectedWorkloadAsStrings)).setter(ApplicationComponent.setter(Builder::detectedWorkloadWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetectedWorkload").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_NAME_FIELD, COMPONENT_REMARKS_FIELD, RESOURCE_TYPE_FIELD, OS_TYPE_FIELD, TIER_FIELD, MONITOR_FIELD, DETECTED_WORKLOAD_FIELD));
    private static final long serialVersionUID = 1L;
    private final String componentName;
    private final String componentRemarks;
    private final String resourceType;
    private final String osType;
    private final String tier;
    private final Boolean monitor;
    private final Map<String, Map<String, String>> detectedWorkload;

    private ApplicationComponent(BuilderImpl builder) {
        this.componentName = builder.componentName;
        this.componentRemarks = builder.componentRemarks;
        this.resourceType = builder.resourceType;
        this.osType = builder.osType;
        this.tier = builder.tier;
        this.monitor = builder.monitor;
        this.detectedWorkload = builder.detectedWorkload;
    }

    public final String componentName() {
        return this.componentName;
    }

    public final String componentRemarks() {
        return this.componentRemarks;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final OsType osType() {
        return OsType.fromValue(this.osType);
    }

    public final String osTypeAsString() {
        return this.osType;
    }

    public final Tier tier() {
        return Tier.fromValue(this.tier);
    }

    public final String tierAsString() {
        return this.tier;
    }

    public final Boolean monitor() {
        return this.monitor;
    }

    public final Map<Tier, Map<String, String>> detectedWorkload() {
        return DetectedWorkloadCopier.copyStringToEnum(this.detectedWorkload);
    }

    public final boolean hasDetectedWorkload() {
        return this.detectedWorkload != null && !(this.detectedWorkload instanceof SdkAutoConstructMap);
    }

    public final Map<String, Map<String, String>> detectedWorkloadAsStrings() {
        return this.detectedWorkload;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.componentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentRemarks());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.osTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitor());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDetectedWorkload() ? this.detectedWorkloadAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationComponent)) {
            return false;
        }
        ApplicationComponent other = (ApplicationComponent)obj;
        return Objects.equals(this.componentName(), other.componentName()) && Objects.equals(this.componentRemarks(), other.componentRemarks()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.osTypeAsString(), other.osTypeAsString()) && Objects.equals(this.tierAsString(), other.tierAsString()) && Objects.equals(this.monitor(), other.monitor()) && this.hasDetectedWorkload() == other.hasDetectedWorkload() && Objects.equals(this.detectedWorkloadAsStrings(), other.detectedWorkloadAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ApplicationComponent").add("ComponentName", (Object)this.componentName()).add("ComponentRemarks", (Object)this.componentRemarks()).add("ResourceType", (Object)this.resourceType()).add("OsType", (Object)this.osTypeAsString()).add("Tier", (Object)this.tierAsString()).add("Monitor", (Object)this.monitor()).add("DetectedWorkload", this.hasDetectedWorkload() ? this.detectedWorkloadAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ComponentName": {
                return Optional.ofNullable(clazz.cast(this.componentName()));
            }
            case "ComponentRemarks": {
                return Optional.ofNullable(clazz.cast(this.componentRemarks()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "OsType": {
                return Optional.ofNullable(clazz.cast(this.osTypeAsString()));
            }
            case "Tier": {
                return Optional.ofNullable(clazz.cast(this.tierAsString()));
            }
            case "Monitor": {
                return Optional.ofNullable(clazz.cast(this.monitor()));
            }
            case "DetectedWorkload": {
                return Optional.ofNullable(clazz.cast(this.detectedWorkloadAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationComponent, T> g) {
        return obj -> g.apply((ApplicationComponent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String componentName;
        private String componentRemarks;
        private String resourceType;
        private String osType;
        private String tier;
        private Boolean monitor;
        private Map<String, Map<String, String>> detectedWorkload = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationComponent model) {
            this.componentName(model.componentName);
            this.componentRemarks(model.componentRemarks);
            this.resourceType(model.resourceType);
            this.osType(model.osType);
            this.tier(model.tier);
            this.monitor(model.monitor);
            this.detectedWorkloadWithStrings(model.detectedWorkload);
        }

        public final String getComponentName() {
            return this.componentName;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        @Override
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final String getComponentRemarks() {
            return this.componentRemarks;
        }

        public final void setComponentRemarks(String componentRemarks) {
            this.componentRemarks = componentRemarks;
        }

        @Override
        public final Builder componentRemarks(String componentRemarks) {
            this.componentRemarks = componentRemarks;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getOsType() {
            return this.osType;
        }

        public final void setOsType(String osType) {
            this.osType = osType;
        }

        @Override
        public final Builder osType(String osType) {
            this.osType = osType;
            return this;
        }

        @Override
        public final Builder osType(OsType osType) {
            this.osType(osType == null ? null : osType.toString());
            return this;
        }

        public final String getTier() {
            return this.tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        public final Builder tier(Tier tier) {
            this.tier(tier == null ? null : tier.toString());
            return this;
        }

        public final Boolean getMonitor() {
            return this.monitor;
        }

        public final void setMonitor(Boolean monitor) {
            this.monitor = monitor;
        }

        @Override
        public final Builder monitor(Boolean monitor) {
            this.monitor = monitor;
            return this;
        }

        public final Map<String, ? extends Map<String, String>> getDetectedWorkload() {
            if (this.detectedWorkload instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.detectedWorkload;
        }

        public final void setDetectedWorkload(Map<String, ? extends Map<String, String>> detectedWorkload) {
            this.detectedWorkload = DetectedWorkloadCopier.copy(detectedWorkload);
        }

        @Override
        public final Builder detectedWorkloadWithStrings(Map<String, ? extends Map<String, String>> detectedWorkload) {
            this.detectedWorkload = DetectedWorkloadCopier.copy(detectedWorkload);
            return this;
        }

        @Override
        public final Builder detectedWorkload(Map<Tier, ? extends Map<String, String>> detectedWorkload) {
            this.detectedWorkload = DetectedWorkloadCopier.copyEnumToString(detectedWorkload);
            return this;
        }

        public ApplicationComponent build() {
            return new ApplicationComponent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationComponent> {
        public Builder componentName(String var1);

        public Builder componentRemarks(String var1);

        public Builder resourceType(String var1);

        public Builder osType(String var1);

        public Builder osType(OsType var1);

        public Builder tier(String var1);

        public Builder tier(Tier var1);

        public Builder monitor(Boolean var1);

        public Builder detectedWorkloadWithStrings(Map<String, ? extends Map<String, String>> var1);

        public Builder detectedWorkload(Map<Tier, ? extends Map<String, String>> var1);
    }
}

