/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.applicationinsights.ApplicationInsightsAsyncClient;
import software.amazon.awssdk.services.applicationinsights.model.ListLogPatternsRequest;
import software.amazon.awssdk.services.applicationinsights.model.ListLogPatternsResponse;

public class ListLogPatternsPublisher
implements SdkPublisher<ListLogPatternsResponse> {
    private final ApplicationInsightsAsyncClient client;
    private final ListLogPatternsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLogPatternsPublisher(ApplicationInsightsAsyncClient client, ListLogPatternsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLogPatternsPublisher(ApplicationInsightsAsyncClient client, ListLogPatternsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLogPatternsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLogPatternsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListLogPatternsResponseFetcher
    implements AsyncPageFetcher<ListLogPatternsResponse> {
        private ListLogPatternsResponseFetcher() {
        }

        public boolean hasNextPage(ListLogPatternsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListLogPatternsResponse> nextPage(ListLogPatternsResponse previousPage) {
            if (previousPage == null) {
                return ListLogPatternsPublisher.this.client.listLogPatterns(ListLogPatternsPublisher.this.firstRequest);
            }
            return ListLogPatternsPublisher.this.client.listLogPatterns((ListLogPatternsRequest)((Object)ListLogPatternsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

