/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.applicationdiscovery.model.AgentInfo;
import software.amazon.awssdk.services.applicationdiscovery.model.AgentsInfoCopier;
import software.amazon.awssdk.services.applicationdiscovery.model.ApplicationDiscoveryResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAgentsResponse
extends ApplicationDiscoveryResponse
implements ToCopyableBuilder<Builder, DescribeAgentsResponse> {
    private static final SdkField<List<AgentInfo>> AGENTS_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeAgentsResponse.getter(DescribeAgentsResponse::agentsInfo)).setter(DescribeAgentsResponse.setter(Builder::agentsInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentsInfo").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AgentInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeAgentsResponse.getter(DescribeAgentsResponse::nextToken)).setter(DescribeAgentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENTS_INFO_FIELD, NEXT_TOKEN_FIELD));
    private final List<AgentInfo> agentsInfo;
    private final String nextToken;

    private DescribeAgentsResponse(BuilderImpl builder) {
        super(builder);
        this.agentsInfo = builder.agentsInfo;
        this.nextToken = builder.nextToken;
    }

    public List<AgentInfo> agentsInfo() {
        return this.agentsInfo;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.agentsInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAgentsResponse)) {
            return false;
        }
        DescribeAgentsResponse other = (DescribeAgentsResponse)((Object)obj);
        return Objects.equals(this.agentsInfo(), other.agentsInfo()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeAgentsResponse").add("AgentsInfo", this.agentsInfo()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agentsInfo": {
                return Optional.ofNullable(clazz.cast(this.agentsInfo()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAgentsResponse, T> g) {
        return obj -> g.apply((DescribeAgentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationDiscoveryResponse.BuilderImpl
    implements Builder {
        private List<AgentInfo> agentsInfo = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAgentsResponse model) {
            super(model);
            this.agentsInfo(model.agentsInfo);
            this.nextToken(model.nextToken);
        }

        public final Collection<AgentInfo.Builder> getAgentsInfo() {
            return this.agentsInfo != null ? (Collection)this.agentsInfo.stream().map(AgentInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder agentsInfo(Collection<AgentInfo> agentsInfo) {
            this.agentsInfo = AgentsInfoCopier.copy(agentsInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentsInfo(AgentInfo ... agentsInfo) {
            this.agentsInfo(Arrays.asList(agentsInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentsInfo(Consumer<AgentInfo.Builder> ... agentsInfo) {
            this.agentsInfo(Stream.of(agentsInfo).map(c -> (AgentInfo)((AgentInfo.Builder)AgentInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAgentsInfo(Collection<AgentInfo.BuilderImpl> agentsInfo) {
            this.agentsInfo = AgentsInfoCopier.copyFromBuilder(agentsInfo);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeAgentsResponse build() {
            return new DescribeAgentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApplicationDiscoveryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAgentsResponse> {
        public Builder agentsInfo(Collection<AgentInfo> var1);

        public Builder agentsInfo(AgentInfo ... var1);

        public Builder agentsInfo(Consumer<AgentInfo.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

