/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartExportTaskResponse extends ApplicationDiscoveryResponse implements
        ToCopyableBuilder<StartExportTaskResponse.Builder, StartExportTaskResponse> {
    private static final SdkField<String> EXPORT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("exportId").getter(getter(StartExportTaskResponse::exportId)).setter(setter(Builder::exportId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String exportId;

    private StartExportTaskResponse(BuilderImpl builder) {
        super(builder);
        this.exportId = builder.exportId;
    }

    /**
     * <p>
     * A unique identifier used to query the status of an export request.
     * </p>
     * 
     * @return A unique identifier used to query the status of an export request.
     */
    public final String exportId() {
        return exportId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(exportId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartExportTaskResponse)) {
            return false;
        }
        StartExportTaskResponse other = (StartExportTaskResponse) obj;
        return Objects.equals(exportId(), other.exportId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartExportTaskResponse").add("ExportId", exportId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "exportId":
            return Optional.ofNullable(clazz.cast(exportId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("exportId", EXPORT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartExportTaskResponse, T> g) {
        return obj -> g.apply((StartExportTaskResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ApplicationDiscoveryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StartExportTaskResponse> {
        /**
         * <p>
         * A unique identifier used to query the status of an export request.
         * </p>
         * 
         * @param exportId
         *        A unique identifier used to query the status of an export request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportId(String exportId);
    }

    static final class BuilderImpl extends ApplicationDiscoveryResponse.BuilderImpl implements Builder {
        private String exportId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartExportTaskResponse model) {
            super(model);
            exportId(model.exportId);
        }

        public final String getExportId() {
            return exportId;
        }

        public final void setExportId(String exportId) {
            this.exportId = exportId;
        }

        @Override
        public final Builder exportId(String exportId) {
            this.exportId = exportId;
            return this;
        }

        @Override
        public StartExportTaskResponse build() {
            return new StartExportTaskResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
