/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates that the exported data must include EC2 instance type matches for on-premises servers that are discovered
 * through Amazon Web Services Application Discovery Service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Ec2RecommendationsExportPreferences implements SdkPojo, Serializable,
        ToCopyableBuilder<Ec2RecommendationsExportPreferences.Builder, Ec2RecommendationsExportPreferences> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enabled").getter(getter(Ec2RecommendationsExportPreferences::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final SdkField<UsageMetricBasis> CPU_PERFORMANCE_METRIC_BASIS_FIELD = SdkField
            .<UsageMetricBasis> builder(MarshallingType.SDK_POJO).memberName("cpuPerformanceMetricBasis")
            .getter(getter(Ec2RecommendationsExportPreferences::cpuPerformanceMetricBasis))
            .setter(setter(Builder::cpuPerformanceMetricBasis)).constructor(UsageMetricBasis::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpuPerformanceMetricBasis").build())
            .build();

    private static final SdkField<UsageMetricBasis> RAM_PERFORMANCE_METRIC_BASIS_FIELD = SdkField
            .<UsageMetricBasis> builder(MarshallingType.SDK_POJO).memberName("ramPerformanceMetricBasis")
            .getter(getter(Ec2RecommendationsExportPreferences::ramPerformanceMetricBasis))
            .setter(setter(Builder::ramPerformanceMetricBasis)).constructor(UsageMetricBasis::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ramPerformanceMetricBasis").build())
            .build();

    private static final SdkField<String> TENANCY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("tenancy")
            .getter(getter(Ec2RecommendationsExportPreferences::tenancyAsString)).setter(setter(Builder::tenancy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tenancy").build()).build();

    private static final SdkField<List<String>> EXCLUDED_INSTANCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("excludedInstanceTypes")
            .getter(getter(Ec2RecommendationsExportPreferences::excludedInstanceTypes))
            .setter(setter(Builder::excludedInstanceTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excludedInstanceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PREFERRED_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("preferredRegion").getter(getter(Ec2RecommendationsExportPreferences::preferredRegion))
            .setter(setter(Builder::preferredRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preferredRegion").build()).build();

    private static final SdkField<ReservedInstanceOptions> RESERVED_INSTANCE_OPTIONS_FIELD = SdkField
            .<ReservedInstanceOptions> builder(MarshallingType.SDK_POJO).memberName("reservedInstanceOptions")
            .getter(getter(Ec2RecommendationsExportPreferences::reservedInstanceOptions))
            .setter(setter(Builder::reservedInstanceOptions)).constructor(ReservedInstanceOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservedInstanceOptions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            CPU_PERFORMANCE_METRIC_BASIS_FIELD, RAM_PERFORMANCE_METRIC_BASIS_FIELD, TENANCY_FIELD, EXCLUDED_INSTANCE_TYPES_FIELD,
            PREFERRED_REGION_FIELD, RESERVED_INSTANCE_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final UsageMetricBasis cpuPerformanceMetricBasis;

    private final UsageMetricBasis ramPerformanceMetricBasis;

    private final String tenancy;

    private final List<String> excludedInstanceTypes;

    private final String preferredRegion;

    private final ReservedInstanceOptions reservedInstanceOptions;

    private Ec2RecommendationsExportPreferences(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.cpuPerformanceMetricBasis = builder.cpuPerformanceMetricBasis;
        this.ramPerformanceMetricBasis = builder.ramPerformanceMetricBasis;
        this.tenancy = builder.tenancy;
        this.excludedInstanceTypes = builder.excludedInstanceTypes;
        this.preferredRegion = builder.preferredRegion;
        this.reservedInstanceOptions = builder.reservedInstanceOptions;
    }

    /**
     * <p>
     * If set to true, the export <a href=
     * "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartExportTask.html#API_StartExportTask_RequestSyntax"
     * >preferences</a> is set to <code>Ec2RecommendationsExportPreferences</code>.
     * </p>
     * 
     * @return If set to true, the export <a href=
     *         "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartExportTask.html#API_StartExportTask_RequestSyntax"
     *         >preferences</a> is set to <code>Ec2RecommendationsExportPreferences</code>.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The recommended EC2 instance type that matches the CPU usage metric of server performance data.
     * </p>
     * 
     * @return The recommended EC2 instance type that matches the CPU usage metric of server performance data.
     */
    public final UsageMetricBasis cpuPerformanceMetricBasis() {
        return cpuPerformanceMetricBasis;
    }

    /**
     * <p>
     * The recommended EC2 instance type that matches the Memory usage metric of server performance data.
     * </p>
     * 
     * @return The recommended EC2 instance type that matches the Memory usage metric of server performance data.
     */
    public final UsageMetricBasis ramPerformanceMetricBasis() {
        return ramPerformanceMetricBasis;
    }

    /**
     * <p>
     * The target tenancy to use for your recommended EC2 instances.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tenancy} will
     * return {@link Tenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tenancyAsString}.
     * </p>
     * 
     * @return The target tenancy to use for your recommended EC2 instances.
     * @see Tenancy
     */
    public final Tenancy tenancy() {
        return Tenancy.fromValue(tenancy);
    }

    /**
     * <p>
     * The target tenancy to use for your recommended EC2 instances.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tenancy} will
     * return {@link Tenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tenancyAsString}.
     * </p>
     * 
     * @return The target tenancy to use for your recommended EC2 instances.
     * @see Tenancy
     */
    public final String tenancyAsString() {
        return tenancy;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExcludedInstanceTypes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasExcludedInstanceTypes() {
        return excludedInstanceTypes != null && !(excludedInstanceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of instance types to exclude from recommendations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExcludedInstanceTypes} method.
     * </p>
     * 
     * @return An array of instance types to exclude from recommendations.
     */
    public final List<String> excludedInstanceTypes() {
        return excludedInstanceTypes;
    }

    /**
     * <p>
     * The target Amazon Web Services Region for the recommendations. You can use any of the Region codes available for
     * the chosen service, as listed in <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Amazon Web
     * Services service endpoints</a> in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * 
     * @return The target Amazon Web Services Region for the recommendations. You can use any of the Region codes
     *         available for the chosen service, as listed in <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Amazon Web Services service endpoints</a>
     *         in the <i>Amazon Web Services General Reference</i>.
     */
    public final String preferredRegion() {
        return preferredRegion;
    }

    /**
     * <p>
     * The contract type for a reserved instance. If blank, we assume an On-Demand instance is preferred.
     * </p>
     * 
     * @return The contract type for a reserved instance. If blank, we assume an On-Demand instance is preferred.
     */
    public final ReservedInstanceOptions reservedInstanceOptions() {
        return reservedInstanceOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(cpuPerformanceMetricBasis());
        hashCode = 31 * hashCode + Objects.hashCode(ramPerformanceMetricBasis());
        hashCode = 31 * hashCode + Objects.hashCode(tenancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasExcludedInstanceTypes() ? excludedInstanceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(preferredRegion());
        hashCode = 31 * hashCode + Objects.hashCode(reservedInstanceOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ec2RecommendationsExportPreferences)) {
            return false;
        }
        Ec2RecommendationsExportPreferences other = (Ec2RecommendationsExportPreferences) obj;
        return Objects.equals(enabled(), other.enabled())
                && Objects.equals(cpuPerformanceMetricBasis(), other.cpuPerformanceMetricBasis())
                && Objects.equals(ramPerformanceMetricBasis(), other.ramPerformanceMetricBasis())
                && Objects.equals(tenancyAsString(), other.tenancyAsString())
                && hasExcludedInstanceTypes() == other.hasExcludedInstanceTypes()
                && Objects.equals(excludedInstanceTypes(), other.excludedInstanceTypes())
                && Objects.equals(preferredRegion(), other.preferredRegion())
                && Objects.equals(reservedInstanceOptions(), other.reservedInstanceOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Ec2RecommendationsExportPreferences").add("Enabled", enabled())
                .add("CpuPerformanceMetricBasis", cpuPerformanceMetricBasis())
                .add("RamPerformanceMetricBasis", ramPerformanceMetricBasis()).add("Tenancy", tenancyAsString())
                .add("ExcludedInstanceTypes", hasExcludedInstanceTypes() ? excludedInstanceTypes() : null)
                .add("PreferredRegion", preferredRegion()).add("ReservedInstanceOptions", reservedInstanceOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "cpuPerformanceMetricBasis":
            return Optional.ofNullable(clazz.cast(cpuPerformanceMetricBasis()));
        case "ramPerformanceMetricBasis":
            return Optional.ofNullable(clazz.cast(ramPerformanceMetricBasis()));
        case "tenancy":
            return Optional.ofNullable(clazz.cast(tenancyAsString()));
        case "excludedInstanceTypes":
            return Optional.ofNullable(clazz.cast(excludedInstanceTypes()));
        case "preferredRegion":
            return Optional.ofNullable(clazz.cast(preferredRegion()));
        case "reservedInstanceOptions":
            return Optional.ofNullable(clazz.cast(reservedInstanceOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("enabled", ENABLED_FIELD);
        map.put("cpuPerformanceMetricBasis", CPU_PERFORMANCE_METRIC_BASIS_FIELD);
        map.put("ramPerformanceMetricBasis", RAM_PERFORMANCE_METRIC_BASIS_FIELD);
        map.put("tenancy", TENANCY_FIELD);
        map.put("excludedInstanceTypes", EXCLUDED_INSTANCE_TYPES_FIELD);
        map.put("preferredRegion", PREFERRED_REGION_FIELD);
        map.put("reservedInstanceOptions", RESERVED_INSTANCE_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Ec2RecommendationsExportPreferences, T> g) {
        return obj -> g.apply((Ec2RecommendationsExportPreferences) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Ec2RecommendationsExportPreferences> {
        /**
         * <p>
         * If set to true, the export <a href=
         * "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartExportTask.html#API_StartExportTask_RequestSyntax"
         * >preferences</a> is set to <code>Ec2RecommendationsExportPreferences</code>.
         * </p>
         * 
         * @param enabled
         *        If set to true, the export <a href=
         *        "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartExportTask.html#API_StartExportTask_RequestSyntax"
         *        >preferences</a> is set to <code>Ec2RecommendationsExportPreferences</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The recommended EC2 instance type that matches the CPU usage metric of server performance data.
         * </p>
         * 
         * @param cpuPerformanceMetricBasis
         *        The recommended EC2 instance type that matches the CPU usage metric of server performance data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpuPerformanceMetricBasis(UsageMetricBasis cpuPerformanceMetricBasis);

        /**
         * <p>
         * The recommended EC2 instance type that matches the CPU usage metric of server performance data.
         * </p>
         * This is a convenience method that creates an instance of the {@link UsageMetricBasis.Builder} avoiding the
         * need to create one manually via {@link UsageMetricBasis#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UsageMetricBasis.Builder#build()} is called immediately and its
         * result is passed to {@link #cpuPerformanceMetricBasis(UsageMetricBasis)}.
         * 
         * @param cpuPerformanceMetricBasis
         *        a consumer that will call methods on {@link UsageMetricBasis.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cpuPerformanceMetricBasis(UsageMetricBasis)
         */
        default Builder cpuPerformanceMetricBasis(Consumer<UsageMetricBasis.Builder> cpuPerformanceMetricBasis) {
            return cpuPerformanceMetricBasis(UsageMetricBasis.builder().applyMutation(cpuPerformanceMetricBasis).build());
        }

        /**
         * <p>
         * The recommended EC2 instance type that matches the Memory usage metric of server performance data.
         * </p>
         * 
         * @param ramPerformanceMetricBasis
         *        The recommended EC2 instance type that matches the Memory usage metric of server performance data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ramPerformanceMetricBasis(UsageMetricBasis ramPerformanceMetricBasis);

        /**
         * <p>
         * The recommended EC2 instance type that matches the Memory usage metric of server performance data.
         * </p>
         * This is a convenience method that creates an instance of the {@link UsageMetricBasis.Builder} avoiding the
         * need to create one manually via {@link UsageMetricBasis#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UsageMetricBasis.Builder#build()} is called immediately and its
         * result is passed to {@link #ramPerformanceMetricBasis(UsageMetricBasis)}.
         * 
         * @param ramPerformanceMetricBasis
         *        a consumer that will call methods on {@link UsageMetricBasis.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ramPerformanceMetricBasis(UsageMetricBasis)
         */
        default Builder ramPerformanceMetricBasis(Consumer<UsageMetricBasis.Builder> ramPerformanceMetricBasis) {
            return ramPerformanceMetricBasis(UsageMetricBasis.builder().applyMutation(ramPerformanceMetricBasis).build());
        }

        /**
         * <p>
         * The target tenancy to use for your recommended EC2 instances.
         * </p>
         * 
         * @param tenancy
         *        The target tenancy to use for your recommended EC2 instances.
         * @see Tenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tenancy
         */
        Builder tenancy(String tenancy);

        /**
         * <p>
         * The target tenancy to use for your recommended EC2 instances.
         * </p>
         * 
         * @param tenancy
         *        The target tenancy to use for your recommended EC2 instances.
         * @see Tenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tenancy
         */
        Builder tenancy(Tenancy tenancy);

        /**
         * <p>
         * An array of instance types to exclude from recommendations.
         * </p>
         * 
         * @param excludedInstanceTypes
         *        An array of instance types to exclude from recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludedInstanceTypes(Collection<String> excludedInstanceTypes);

        /**
         * <p>
         * An array of instance types to exclude from recommendations.
         * </p>
         * 
         * @param excludedInstanceTypes
         *        An array of instance types to exclude from recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludedInstanceTypes(String... excludedInstanceTypes);

        /**
         * <p>
         * The target Amazon Web Services Region for the recommendations. You can use any of the Region codes available
         * for the chosen service, as listed in <a
         * href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Amazon Web Services service endpoints</a> in
         * the <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param preferredRegion
         *        The target Amazon Web Services Region for the recommendations. You can use any of the Region codes
         *        available for the chosen service, as listed in <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Amazon Web Services service
         *        endpoints</a> in the <i>Amazon Web Services General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredRegion(String preferredRegion);

        /**
         * <p>
         * The contract type for a reserved instance. If blank, we assume an On-Demand instance is preferred.
         * </p>
         * 
         * @param reservedInstanceOptions
         *        The contract type for a reserved instance. If blank, we assume an On-Demand instance is preferred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstanceOptions(ReservedInstanceOptions reservedInstanceOptions);

        /**
         * <p>
         * The contract type for a reserved instance. If blank, we assume an On-Demand instance is preferred.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReservedInstanceOptions.Builder} avoiding
         * the need to create one manually via {@link ReservedInstanceOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReservedInstanceOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #reservedInstanceOptions(ReservedInstanceOptions)}.
         * 
         * @param reservedInstanceOptions
         *        a consumer that will call methods on {@link ReservedInstanceOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reservedInstanceOptions(ReservedInstanceOptions)
         */
        default Builder reservedInstanceOptions(Consumer<ReservedInstanceOptions.Builder> reservedInstanceOptions) {
            return reservedInstanceOptions(ReservedInstanceOptions.builder().applyMutation(reservedInstanceOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private UsageMetricBasis cpuPerformanceMetricBasis;

        private UsageMetricBasis ramPerformanceMetricBasis;

        private String tenancy;

        private List<String> excludedInstanceTypes = DefaultSdkAutoConstructList.getInstance();

        private String preferredRegion;

        private ReservedInstanceOptions reservedInstanceOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(Ec2RecommendationsExportPreferences model) {
            enabled(model.enabled);
            cpuPerformanceMetricBasis(model.cpuPerformanceMetricBasis);
            ramPerformanceMetricBasis(model.ramPerformanceMetricBasis);
            tenancy(model.tenancy);
            excludedInstanceTypes(model.excludedInstanceTypes);
            preferredRegion(model.preferredRegion);
            reservedInstanceOptions(model.reservedInstanceOptions);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final UsageMetricBasis.Builder getCpuPerformanceMetricBasis() {
            return cpuPerformanceMetricBasis != null ? cpuPerformanceMetricBasis.toBuilder() : null;
        }

        public final void setCpuPerformanceMetricBasis(UsageMetricBasis.BuilderImpl cpuPerformanceMetricBasis) {
            this.cpuPerformanceMetricBasis = cpuPerformanceMetricBasis != null ? cpuPerformanceMetricBasis.build() : null;
        }

        @Override
        public final Builder cpuPerformanceMetricBasis(UsageMetricBasis cpuPerformanceMetricBasis) {
            this.cpuPerformanceMetricBasis = cpuPerformanceMetricBasis;
            return this;
        }

        public final UsageMetricBasis.Builder getRamPerformanceMetricBasis() {
            return ramPerformanceMetricBasis != null ? ramPerformanceMetricBasis.toBuilder() : null;
        }

        public final void setRamPerformanceMetricBasis(UsageMetricBasis.BuilderImpl ramPerformanceMetricBasis) {
            this.ramPerformanceMetricBasis = ramPerformanceMetricBasis != null ? ramPerformanceMetricBasis.build() : null;
        }

        @Override
        public final Builder ramPerformanceMetricBasis(UsageMetricBasis ramPerformanceMetricBasis) {
            this.ramPerformanceMetricBasis = ramPerformanceMetricBasis;
            return this;
        }

        public final String getTenancy() {
            return tenancy;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        @Override
        public final Builder tenancy(Tenancy tenancy) {
            this.tenancy(tenancy == null ? null : tenancy.toString());
            return this;
        }

        public final Collection<String> getExcludedInstanceTypes() {
            if (excludedInstanceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return excludedInstanceTypes;
        }

        public final void setExcludedInstanceTypes(Collection<String> excludedInstanceTypes) {
            this.excludedInstanceTypes = ExcludedInstanceTypesCopier.copy(excludedInstanceTypes);
        }

        @Override
        public final Builder excludedInstanceTypes(Collection<String> excludedInstanceTypes) {
            this.excludedInstanceTypes = ExcludedInstanceTypesCopier.copy(excludedInstanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedInstanceTypes(String... excludedInstanceTypes) {
            excludedInstanceTypes(Arrays.asList(excludedInstanceTypes));
            return this;
        }

        public final String getPreferredRegion() {
            return preferredRegion;
        }

        public final void setPreferredRegion(String preferredRegion) {
            this.preferredRegion = preferredRegion;
        }

        @Override
        public final Builder preferredRegion(String preferredRegion) {
            this.preferredRegion = preferredRegion;
            return this;
        }

        public final ReservedInstanceOptions.Builder getReservedInstanceOptions() {
            return reservedInstanceOptions != null ? reservedInstanceOptions.toBuilder() : null;
        }

        public final void setReservedInstanceOptions(ReservedInstanceOptions.BuilderImpl reservedInstanceOptions) {
            this.reservedInstanceOptions = reservedInstanceOptions != null ? reservedInstanceOptions.build() : null;
        }

        @Override
        public final Builder reservedInstanceOptions(ReservedInstanceOptions reservedInstanceOptions) {
            this.reservedInstanceOptions = reservedInstanceOptions;
            return this;
        }

        @Override
        public Ec2RecommendationsExportPreferences build() {
            return new Ec2RecommendationsExportPreferences(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
