/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A configuration ID paired with a warning message.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeletionWarning implements SdkPojo, Serializable, ToCopyableBuilder<DeletionWarning.Builder, DeletionWarning> {
    private static final SdkField<String> CONFIGURATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("configurationId").getter(getter(DeletionWarning::configurationId))
            .setter(setter(Builder::configurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationId").build()).build();

    private static final SdkField<Integer> WARNING_CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("warningCode").getter(getter(DeletionWarning::warningCode)).setter(setter(Builder::warningCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("warningCode").build()).build();

    private static final SdkField<String> WARNING_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("warningText").getter(getter(DeletionWarning::warningText)).setter(setter(Builder::warningText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("warningText").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_ID_FIELD,
            WARNING_CODE_FIELD, WARNING_TEXT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String configurationId;

    private final Integer warningCode;

    private final String warningText;

    private DeletionWarning(BuilderImpl builder) {
        this.configurationId = builder.configurationId;
        this.warningCode = builder.warningCode;
        this.warningText = builder.warningText;
    }

    /**
     * <p>
     * The unique identifier of the configuration that produced a warning.
     * </p>
     * 
     * @return The unique identifier of the configuration that produced a warning.
     */
    public final String configurationId() {
        return configurationId;
    }

    /**
     * <p>
     * The integer warning code associated with the warning message.
     * </p>
     * 
     * @return The integer warning code associated with the warning message.
     */
    public final Integer warningCode() {
        return warningCode;
    }

    /**
     * <p>
     * A descriptive message of the warning the associated configuration ID produced.
     * </p>
     * 
     * @return A descriptive message of the warning the associated configuration ID produced.
     */
    public final String warningText() {
        return warningText;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configurationId());
        hashCode = 31 * hashCode + Objects.hashCode(warningCode());
        hashCode = 31 * hashCode + Objects.hashCode(warningText());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletionWarning)) {
            return false;
        }
        DeletionWarning other = (DeletionWarning) obj;
        return Objects.equals(configurationId(), other.configurationId()) && Objects.equals(warningCode(), other.warningCode())
                && Objects.equals(warningText(), other.warningText());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeletionWarning").add("ConfigurationId", configurationId()).add("WarningCode", warningCode())
                .add("WarningText", warningText()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configurationId":
            return Optional.ofNullable(clazz.cast(configurationId()));
        case "warningCode":
            return Optional.ofNullable(clazz.cast(warningCode()));
        case "warningText":
            return Optional.ofNullable(clazz.cast(warningText()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("configurationId", CONFIGURATION_ID_FIELD);
        map.put("warningCode", WARNING_CODE_FIELD);
        map.put("warningText", WARNING_TEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeletionWarning, T> g) {
        return obj -> g.apply((DeletionWarning) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeletionWarning> {
        /**
         * <p>
         * The unique identifier of the configuration that produced a warning.
         * </p>
         * 
         * @param configurationId
         *        The unique identifier of the configuration that produced a warning.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationId(String configurationId);

        /**
         * <p>
         * The integer warning code associated with the warning message.
         * </p>
         * 
         * @param warningCode
         *        The integer warning code associated with the warning message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warningCode(Integer warningCode);

        /**
         * <p>
         * A descriptive message of the warning the associated configuration ID produced.
         * </p>
         * 
         * @param warningText
         *        A descriptive message of the warning the associated configuration ID produced.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warningText(String warningText);
    }

    static final class BuilderImpl implements Builder {
        private String configurationId;

        private Integer warningCode;

        private String warningText;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletionWarning model) {
            configurationId(model.configurationId);
            warningCode(model.warningCode);
            warningText(model.warningText);
        }

        public final String getConfigurationId() {
            return configurationId;
        }

        public final void setConfigurationId(String configurationId) {
            this.configurationId = configurationId;
        }

        @Override
        public final Builder configurationId(String configurationId) {
            this.configurationId = configurationId;
            return this;
        }

        public final Integer getWarningCode() {
            return warningCode;
        }

        public final void setWarningCode(Integer warningCode) {
            this.warningCode = warningCode;
        }

        @Override
        public final Builder warningCode(Integer warningCode) {
            this.warningCode = warningCode;
            return this;
        }

        public final String getWarningText() {
            return warningText;
        }

        public final void setWarningText(String warningText) {
            this.warningText = warningText;
        }

        @Override
        public final Builder warningText(String warningText) {
            this.warningText = warningText;
            return this;
        }

        @Override
        public DeletionWarning build() {
            return new DeletionWarning(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
