/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.applicationdiscovery.ApplicationDiscoveryClient;
import software.amazon.awssdk.services.applicationdiscovery.internal.UserAgentUtils;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeImportTasksRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeImportTasksResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.ImportTask;

public class DescribeImportTasksIterable
implements SdkIterable<DescribeImportTasksResponse> {
    private final ApplicationDiscoveryClient client;
    private final DescribeImportTasksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeImportTasksIterable(ApplicationDiscoveryClient client, DescribeImportTasksRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeImportTasksResponseFetcher();
    }

    public Iterator<DescribeImportTasksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ImportTask> tasks() {
        Function<DescribeImportTasksResponse, Iterator> getIterator = response -> {
            if (response != null && response.tasks() != null) {
                return response.tasks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeImportTasksResponseFetcher
    implements SyncPageFetcher<DescribeImportTasksResponse> {
        private DescribeImportTasksResponseFetcher() {
        }

        public boolean hasNextPage(DescribeImportTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeImportTasksResponse nextPage(DescribeImportTasksResponse previousPage) {
            if (previousPage == null) {
                return DescribeImportTasksIterable.this.client.describeImportTasks(DescribeImportTasksIterable.this.firstRequest);
            }
            return DescribeImportTasksIterable.this.client.describeImportTasks((DescribeImportTasksRequest)((Object)DescribeImportTasksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

