/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListConfigurationsResponse extends ApplicationDiscoveryResponse implements
        ToCopyableBuilder<ListConfigurationsResponse.Builder, ListConfigurationsResponse> {
    private static final SdkField<List<Map<String, String>>> CONFIGURATIONS_FIELD = SdkField
            .<List<Map<String, String>>> builder(MarshallingType.LIST)
            .memberName("configurations")
            .getter(getter(ListConfigurationsResponse::configurations))
            .setter(setter(Builder::configurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Map<String, String>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListConfigurationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Map<String, String>> configurations;

    private final String nextToken;

    private ListConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.configurations = builder.configurations;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Configurations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConfigurations() {
        return configurations != null && !(configurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns configuration details, including the configuration ID, attribute names, and attribute values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfigurations} method.
     * </p>
     * 
     * @return Returns configuration details, including the configuration ID, attribute names, and attribute values.
     */
    public final List<Map<String, String>> configurations() {
        return configurations;
    }

    /**
     * <p>
     * Token to retrieve the next set of results. For example, if your call to ListConfigurations returned 100 items,
     * but you set <code>ListConfigurationsRequest$maxResults</code> to 10, you received a set of 10 results along with
     * this token. Use this token in the next query to retrieve the next set of 10.
     * </p>
     * 
     * @return Token to retrieve the next set of results. For example, if your call to ListConfigurations returned 100
     *         items, but you set <code>ListConfigurationsRequest$maxResults</code> to 10, you received a set of 10
     *         results along with this token. Use this token in the next query to retrieve the next set of 10.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasConfigurations() ? configurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConfigurationsResponse)) {
            return false;
        }
        ListConfigurationsResponse other = (ListConfigurationsResponse) obj;
        return hasConfigurations() == other.hasConfigurations() && Objects.equals(configurations(), other.configurations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListConfigurationsResponse")
                .add("Configurations", hasConfigurations() ? configurations() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configurations":
            return Optional.ofNullable(clazz.cast(configurations()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListConfigurationsResponse, T> g) {
        return obj -> g.apply((ListConfigurationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationDiscoveryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListConfigurationsResponse> {
        /**
         * <p>
         * Returns configuration details, including the configuration ID, attribute names, and attribute values.
         * </p>
         * 
         * @param configurations
         *        Returns configuration details, including the configuration ID, attribute names, and attribute values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurations(Collection<? extends Map<String, String>> configurations);

        /**
         * <p>
         * Returns configuration details, including the configuration ID, attribute names, and attribute values.
         * </p>
         * 
         * @param configurations
         *        Returns configuration details, including the configuration ID, attribute names, and attribute values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurations(Map<String, String>... configurations);

        /**
         * <p>
         * Token to retrieve the next set of results. For example, if your call to ListConfigurations returned 100
         * items, but you set <code>ListConfigurationsRequest$maxResults</code> to 10, you received a set of 10 results
         * along with this token. Use this token in the next query to retrieve the next set of 10.
         * </p>
         * 
         * @param nextToken
         *        Token to retrieve the next set of results. For example, if your call to ListConfigurations returned
         *        100 items, but you set <code>ListConfigurationsRequest$maxResults</code> to 10, you received a set of
         *        10 results along with this token. Use this token in the next query to retrieve the next set of 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ApplicationDiscoveryResponse.BuilderImpl implements Builder {
        private List<Map<String, String>> configurations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConfigurationsResponse model) {
            super(model);
            configurations(model.configurations);
            nextToken(model.nextToken);
        }

        public final Collection<? extends Map<String, String>> getConfigurations() {
            if (configurations instanceof SdkAutoConstructList) {
                return null;
            }
            return configurations;
        }

        public final void setConfigurations(Collection<? extends Map<String, String>> configurations) {
            this.configurations = ConfigurationsCopier.copy(configurations);
        }

        @Override
        public final Builder configurations(Collection<? extends Map<String, String>> configurations) {
            this.configurations = ConfigurationsCopier.copy(configurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurations(Map<String, String>... configurations) {
            configurations(Arrays.asList(configurations));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListConfigurationsResponse build() {
            return new ListConfigurationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
