/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.applicationdiscovery.model.ApplicationDiscoveryException;
import software.amazon.awssdk.services.applicationdiscovery.model.AssociateConfigurationItemsToApplicationRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.AssociateConfigurationItemsToApplicationResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.AuthorizationErrorException;
import software.amazon.awssdk.services.applicationdiscovery.model.BatchDeleteImportDataRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.BatchDeleteImportDataResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.ConflictErrorException;
import software.amazon.awssdk.services.applicationdiscovery.model.CreateApplicationRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.CreateApplicationResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.CreateTagsRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.CreateTagsResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.DeleteApplicationsRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.DeleteApplicationsResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.DeleteTagsRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.DeleteTagsResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeAgentsRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeAgentsResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeConfigurationsRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeConfigurationsResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeContinuousExportsRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeContinuousExportsResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeExportTasksRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeExportTasksResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeImportTasksRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeImportTasksResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeTagsRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeTagsResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.DisassociateConfigurationItemsFromApplicationRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.DisassociateConfigurationItemsFromApplicationResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.GetDiscoverySummaryRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.GetDiscoverySummaryResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.HomeRegionNotSetException;
import software.amazon.awssdk.services.applicationdiscovery.model.InvalidParameterException;
import software.amazon.awssdk.services.applicationdiscovery.model.InvalidParameterValueException;
import software.amazon.awssdk.services.applicationdiscovery.model.ListConfigurationsRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.ListConfigurationsResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.ListServerNeighborsRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.ListServerNeighborsResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.OperationNotPermittedException;
import software.amazon.awssdk.services.applicationdiscovery.model.ResourceInUseException;
import software.amazon.awssdk.services.applicationdiscovery.model.ResourceNotFoundException;
import software.amazon.awssdk.services.applicationdiscovery.model.ServerInternalErrorException;
import software.amazon.awssdk.services.applicationdiscovery.model.StartContinuousExportRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.StartContinuousExportResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.StartDataCollectionByAgentIdsRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.StartDataCollectionByAgentIdsResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.StartExportTaskRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.StartExportTaskResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.StartImportTaskRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.StartImportTaskResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.StopContinuousExportRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.StopContinuousExportResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.StopDataCollectionByAgentIdsRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.StopDataCollectionByAgentIdsResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.UpdateApplicationRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.UpdateApplicationResponse;
import software.amazon.awssdk.services.applicationdiscovery.paginators.DescribeContinuousExportsIterable;
import software.amazon.awssdk.services.applicationdiscovery.paginators.DescribeImportTasksIterable;

/**
 * Service client for accessing AWS Application Discovery Service. This can be created using the static
 * {@link #builder()} method.
 *
 * <fullname>Amazon Web Services Application Discovery Service</fullname>
 * <p>
 * Amazon Web Services Application Discovery Service (Application Discovery Service) helps you plan application
 * migration projects. It automatically identifies servers, virtual machines (VMs), and network dependencies in your
 * on-premises data centers. For more information, see the <a
 * href="http://aws.amazon.com/application-discovery/faqs/">Amazon Web Services Application Discovery Service FAQ</a>.
 * </p>
 * <p>
 * Application Discovery Service offers three ways of performing discovery and collecting data about your on-premises
 * servers:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <b>Agentless discovery</b> using Amazon Web Services Application Discovery Service Agentless Collector (Agentless
 * Collector), which doesn't require you to install an agent on each host.
 * </p>
 * <ul>
 * <li>
 * <p>
 * Agentless Collector gathers server information regardless of the operating systems, which minimizes the time required
 * for initial on-premises infrastructure assessment.
 * </p>
 * </li>
 * <li>
 * <p>
 * Agentless Collector doesn't collect information about network dependencies, only agent-based discovery collects that
 * information.
 * </p>
 * </li>
 * </ul>
 * </li>
 * </ul>
 * <ul>
 * <li>
 * <p>
 * <b>Agent-based discovery</b> using the Amazon Web Services Application Discovery Agent (Application Discovery Agent)
 * collects a richer set of data than agentless discovery, which you install on one or more hosts in your data center.
 * </p>
 * <ul>
 * <li>
 * <p>
 * The agent captures infrastructure and application information, including an inventory of running processes, system
 * performance information, resource utilization, and network dependencies.
 * </p>
 * </li>
 * <li>
 * <p>
 * The information collected by agents is secured at rest and in transit to the Application Discovery Service database
 * in the Amazon Web Services cloud. For more information, see <a
 * href="https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-agent.html">Amazon Web Services
 * Application Discovery Agent</a>.
 * </p>
 * </li>
 * </ul>
 * </li>
 * </ul>
 * <ul>
 * <li>
 * <p>
 * <b>Amazon Web Services Partner Network (APN) solutions</b> integrate with Application Discovery Service, enabling you
 * to import details of your on-premises environment directly into Amazon Web Services Migration Hub (Migration Hub)
 * without using Agentless Collector or Application Discovery Agent.
 * </p>
 * <ul>
 * <li>
 * <p>
 * Third-party application discovery tools can query Amazon Web Services Application Discovery Service, and they can
 * write to the Application Discovery Service database using the public API.
 * </p>
 * </li>
 * <li>
 * <p>
 * In this way, you can import data into Migration Hub and view it, so that you can associate applications with servers
 * and track migrations.
 * </p>
 * </li>
 * </ul>
 * </li>
 * </ul>
 * <p>
 * <b>Working With This Guide</b>
 * </p>
 * <p>
 * This API reference provides descriptions, syntax, and usage examples for each of the actions and data types for
 * Application Discovery Service. The topic for each action shows the API request parameters and the response.
 * Alternatively, you can use one of the Amazon Web Services SDKs to access an API that is tailored to the programming
 * language or platform that you're using. For more information, see <a href="http://aws.amazon.com/tools/#SDKs">Amazon
 * Web Services SDKs</a>.
 * </p>
 * <note>
 * <ul>
 * <li>
 * <p>
 * Remember that you must set your Migration Hub home Region before you call any of these APIs.
 * </p>
 * </li>
 * <li>
 * <p>
 * You must make API calls for write actions (create, notify, associate, disassociate, import, or put) while in your
 * home Region, or a <code>HomeRegionNotSetException</code> error is returned.
 * </p>
 * </li>
 * <li>
 * <p>
 * API calls for read actions (list, describe, stop, and delete) are permitted outside of your home Region.
 * </p>
 * </li>
 * <li>
 * <p>
 * Although it is unlikely, the Migration Hub home Region could change. If you call APIs outside the home Region, an
 * <code>InvalidInputException</code> is returned.
 * </p>
 * </li>
 * <li>
 * <p>
 * You must call <code>GetHomeRegion</code> to obtain the latest Migration Hub home Region.
 * </p>
 * </li>
 * </ul>
 * </note>
 * <p>
 * This guide is intended for use with the <a
 * href="https://docs.aws.amazon.com/application-discovery/latest/userguide/">Amazon Web Services Application Discovery
 * Service User Guide</a>.
 * </p>
 * <important>
 * <p>
 * All data is handled according to the <a href="https://aws.amazon.com/privacy/">Amazon Web Services Privacy
 * Policy</a>. You can operate Application Discovery Service offline to inspect collected data before it is shared with
 * the service.
 * </p>
 * </important>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ApplicationDiscoveryClient extends AwsClient {
    String SERVICE_NAME = "discovery";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "discovery";

    /**
     * <p>
     * Associates one or more configuration items with an application.
     * </p>
     *
     * @param associateConfigurationItemsToApplicationRequest
     * @return Result of the AssociateConfigurationItemsToApplication operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.AssociateConfigurationItemsToApplication
     */
    default AssociateConfigurationItemsToApplicationResponse associateConfigurationItemsToApplication(
            AssociateConfigurationItemsToApplicationRequest associateConfigurationItemsToApplicationRequest)
            throws AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException,
            ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException, SdkClientException,
            ApplicationDiscoveryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates one or more configuration items with an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AssociateConfigurationItemsToApplicationRequest.Builder} avoiding the need to create one manually via
     * {@link AssociateConfigurationItemsToApplicationRequest#builder()}
     * </p>
     *
     * @param associateConfigurationItemsToApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link AssociateConfigurationItemsToApplicationRequest.Builder} to create a request.
     * @return Result of the AssociateConfigurationItemsToApplication operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.AssociateConfigurationItemsToApplication
     */
    default AssociateConfigurationItemsToApplicationResponse associateConfigurationItemsToApplication(
            Consumer<AssociateConfigurationItemsToApplicationRequest.Builder> associateConfigurationItemsToApplicationRequest)
            throws AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException,
            ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException, SdkClientException,
            ApplicationDiscoveryException {
        return associateConfigurationItemsToApplication(AssociateConfigurationItemsToApplicationRequest.builder()
                .applyMutation(associateConfigurationItemsToApplicationRequest).build());
    }

    /**
     * <p>
     * Deletes one or more import tasks, each identified by their import ID. Each import task has a number of records
     * that can identify servers or applications.
     * </p>
     * <p>
     * Amazon Web Services Application Discovery Service has built-in matching logic that will identify when discovered
     * servers match existing entries that you've previously discovered, the information for the already-existing
     * discovered server is updated. When you delete an import task that contains records that were used to match, the
     * information in those matched records that comes from the deleted records will also be deleted.
     * </p>
     *
     * @param batchDeleteImportDataRequest
     * @return Result of the BatchDeleteImportData operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.BatchDeleteImportData
     */
    default BatchDeleteImportDataResponse batchDeleteImportData(BatchDeleteImportDataRequest batchDeleteImportDataRequest)
            throws AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException,
            ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException, SdkClientException,
            ApplicationDiscoveryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes one or more import tasks, each identified by their import ID. Each import task has a number of records
     * that can identify servers or applications.
     * </p>
     * <p>
     * Amazon Web Services Application Discovery Service has built-in matching logic that will identify when discovered
     * servers match existing entries that you've previously discovered, the information for the already-existing
     * discovered server is updated. When you delete an import task that contains records that were used to match, the
     * information in those matched records that comes from the deleted records will also be deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteImportDataRequest.Builder} avoiding the
     * need to create one manually via {@link BatchDeleteImportDataRequest#builder()}
     * </p>
     *
     * @param batchDeleteImportDataRequest
     *        A {@link Consumer} that will call methods on {@link BatchDeleteImportDataRequest.Builder} to create a
     *        request.
     * @return Result of the BatchDeleteImportData operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.BatchDeleteImportData
     */
    default BatchDeleteImportDataResponse batchDeleteImportData(
            Consumer<BatchDeleteImportDataRequest.Builder> batchDeleteImportDataRequest) throws AuthorizationErrorException,
            InvalidParameterException, InvalidParameterValueException, ServerInternalErrorException, HomeRegionNotSetException,
            AwsServiceException, SdkClientException, ApplicationDiscoveryException {
        return batchDeleteImportData(BatchDeleteImportDataRequest.builder().applyMutation(batchDeleteImportDataRequest).build());
    }

    /**
     * <p>
     * Creates an application with the given name and description.
     * </p>
     *
     * @param createApplicationRequest
     * @return Result of the CreateApplication operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.CreateApplication
     */
    default CreateApplicationResponse createApplication(CreateApplicationRequest createApplicationRequest)
            throws AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException,
            ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException, SdkClientException,
            ApplicationDiscoveryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an application with the given name and description.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link CreateApplicationRequest#builder()}
     * </p>
     *
     * @param createApplicationRequest
     *        A {@link Consumer} that will call methods on {@link CreateApplicationRequest.Builder} to create a request.
     * @return Result of the CreateApplication operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.CreateApplication
     */
    default CreateApplicationResponse createApplication(Consumer<CreateApplicationRequest.Builder> createApplicationRequest)
            throws AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException,
            ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException, SdkClientException,
            ApplicationDiscoveryException {
        return createApplication(CreateApplicationRequest.builder().applyMutation(createApplicationRequest).build());
    }

    /**
     * <p>
     * Creates one or more tags for configuration items. Tags are metadata that help you categorize IT assets. This API
     * accepts a list of multiple configuration items.
     * </p>
     * <important>
     * <p>
     * Do not store sensitive information (like personal data) in tags.
     * </p>
     * </important>
     *
     * @param createTagsRequest
     * @return Result of the CreateTags operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws ResourceNotFoundException
     *         The specified configuration ID was not located. Verify the configuration ID and try again.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.CreateTags
     */
    default CreateTagsResponse createTags(CreateTagsRequest createTagsRequest) throws AuthorizationErrorException,
            ResourceNotFoundException, InvalidParameterException, InvalidParameterValueException, ServerInternalErrorException,
            HomeRegionNotSetException, AwsServiceException, SdkClientException, ApplicationDiscoveryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates one or more tags for configuration items. Tags are metadata that help you categorize IT assets. This API
     * accepts a list of multiple configuration items.
     * </p>
     * <important>
     * <p>
     * Do not store sensitive information (like personal data) in tags.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTagsRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTagsRequest#builder()}
     * </p>
     *
     * @param createTagsRequest
     *        A {@link Consumer} that will call methods on {@link CreateTagsRequest.Builder} to create a request.
     * @return Result of the CreateTags operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws ResourceNotFoundException
     *         The specified configuration ID was not located. Verify the configuration ID and try again.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.CreateTags
     */
    default CreateTagsResponse createTags(Consumer<CreateTagsRequest.Builder> createTagsRequest)
            throws AuthorizationErrorException, ResourceNotFoundException, InvalidParameterException,
            InvalidParameterValueException, ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException,
            SdkClientException, ApplicationDiscoveryException {
        return createTags(CreateTagsRequest.builder().applyMutation(createTagsRequest).build());
    }

    /**
     * <p>
     * Deletes a list of applications and their associations with configuration items.
     * </p>
     *
     * @param deleteApplicationsRequest
     * @return Result of the DeleteApplications operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.DeleteApplications
     */
    default DeleteApplicationsResponse deleteApplications(DeleteApplicationsRequest deleteApplicationsRequest)
            throws AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException,
            ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException, SdkClientException,
            ApplicationDiscoveryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a list of applications and their associations with configuration items.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApplicationsRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteApplicationsRequest#builder()}
     * </p>
     *
     * @param deleteApplicationsRequest
     *        A {@link Consumer} that will call methods on {@link DeleteApplicationsRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteApplications operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.DeleteApplications
     */
    default DeleteApplicationsResponse deleteApplications(Consumer<DeleteApplicationsRequest.Builder> deleteApplicationsRequest)
            throws AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException,
            ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException, SdkClientException,
            ApplicationDiscoveryException {
        return deleteApplications(DeleteApplicationsRequest.builder().applyMutation(deleteApplicationsRequest).build());
    }

    /**
     * <p>
     * Deletes the association between configuration items and one or more tags. This API accepts a list of multiple
     * configuration items.
     * </p>
     *
     * @param deleteTagsRequest
     * @return Result of the DeleteTags operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws ResourceNotFoundException
     *         The specified configuration ID was not located. Verify the configuration ID and try again.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.DeleteTags
     */
    default DeleteTagsResponse deleteTags(DeleteTagsRequest deleteTagsRequest) throws AuthorizationErrorException,
            ResourceNotFoundException, InvalidParameterException, InvalidParameterValueException, ServerInternalErrorException,
            HomeRegionNotSetException, AwsServiceException, SdkClientException, ApplicationDiscoveryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the association between configuration items and one or more tags. This API accepts a list of multiple
     * configuration items.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTagsRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTagsRequest#builder()}
     * </p>
     *
     * @param deleteTagsRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTagsRequest.Builder} to create a request.
     * @return Result of the DeleteTags operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws ResourceNotFoundException
     *         The specified configuration ID was not located. Verify the configuration ID and try again.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.DeleteTags
     */
    default DeleteTagsResponse deleteTags(Consumer<DeleteTagsRequest.Builder> deleteTagsRequest)
            throws AuthorizationErrorException, ResourceNotFoundException, InvalidParameterException,
            InvalidParameterValueException, ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException,
            SdkClientException, ApplicationDiscoveryException {
        return deleteTags(DeleteTagsRequest.builder().applyMutation(deleteTagsRequest).build());
    }

    /**
     * <p>
     * Lists agents or collectors as specified by ID or other filters. All agents/collectors associated with your user
     * can be listed if you call <code>DescribeAgents</code> as is without passing any parameters.
     * </p>
     *
     * @param describeAgentsRequest
     * @return Result of the DescribeAgents operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.DescribeAgents
     */
    default DescribeAgentsResponse describeAgents(DescribeAgentsRequest describeAgentsRequest)
            throws AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException,
            ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException, SdkClientException,
            ApplicationDiscoveryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists agents or collectors as specified by ID or other filters. All agents/collectors associated with your user
     * can be listed if you call <code>DescribeAgents</code> as is without passing any parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAgentsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeAgentsRequest#builder()}
     * </p>
     *
     * @param describeAgentsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAgentsRequest.Builder} to create a request.
     * @return Result of the DescribeAgents operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.DescribeAgents
     */
    default DescribeAgentsResponse describeAgents(Consumer<DescribeAgentsRequest.Builder> describeAgentsRequest)
            throws AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException,
            ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException, SdkClientException,
            ApplicationDiscoveryException {
        return describeAgents(DescribeAgentsRequest.builder().applyMutation(describeAgentsRequest).build());
    }

    /**
     * <p>
     * Lists agents or collectors as specified by ID or other filters. All agents/collectors associated with your user
     * can be listed if you call <code>DescribeAgents</code> as is without passing any parameters.
     * </p>
     *
     * @return Result of the DescribeAgents operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.DescribeAgents
     * @see #describeAgents(DescribeAgentsRequest)
     */
    default DescribeAgentsResponse describeAgents() throws AuthorizationErrorException, InvalidParameterException,
            InvalidParameterValueException, ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException,
            SdkClientException, ApplicationDiscoveryException {
        return describeAgents(DescribeAgentsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves attributes for a list of configuration item IDs.
     * </p>
     * <note>
     * <p>
     * All of the supplied IDs must be for the same asset type from one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * server
     * </p>
     * </li>
     * <li>
     * <p>
     * application
     * </p>
     * </li>
     * <li>
     * <p>
     * process
     * </p>
     * </li>
     * <li>
     * <p>
     * connection
     * </p>
     * </li>
     * </ul>
     * <p>
     * Output fields are specific to the asset type specified. For example, the output for a <i>server</i> configuration
     * item includes a list of attributes about the server, such as host name, operating system, number of network
     * cards, etc.
     * </p>
     * <p>
     * For a complete list of outputs for each asset type, see <a href=
     * "https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#DescribeConfigurations"
     * >Using the DescribeConfigurations Action</a> in the <i>Amazon Web Services Application Discovery Service User
     * Guide</i>.
     * </p>
     * </note>
     *
     * @param describeConfigurationsRequest
     * @return Result of the DescribeConfigurations operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.DescribeConfigurations
     */
    default DescribeConfigurationsResponse describeConfigurations(DescribeConfigurationsRequest describeConfigurationsRequest)
            throws AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException,
            ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException, SdkClientException,
            ApplicationDiscoveryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves attributes for a list of configuration item IDs.
     * </p>
     * <note>
     * <p>
     * All of the supplied IDs must be for the same asset type from one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * server
     * </p>
     * </li>
     * <li>
     * <p>
     * application
     * </p>
     * </li>
     * <li>
     * <p>
     * process
     * </p>
     * </li>
     * <li>
     * <p>
     * connection
     * </p>
     * </li>
     * </ul>
     * <p>
     * Output fields are specific to the asset type specified. For example, the output for a <i>server</i> configuration
     * item includes a list of attributes about the server, such as host name, operating system, number of network
     * cards, etc.
     * </p>
     * <p>
     * For a complete list of outputs for each asset type, see <a href=
     * "https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#DescribeConfigurations"
     * >Using the DescribeConfigurations Action</a> in the <i>Amazon Web Services Application Discovery Service User
     * Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConfigurationsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeConfigurationsRequest#builder()}
     * </p>
     *
     * @param describeConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeConfigurationsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeConfigurations operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.DescribeConfigurations
     */
    default DescribeConfigurationsResponse describeConfigurations(
            Consumer<DescribeConfigurationsRequest.Builder> describeConfigurationsRequest) throws AuthorizationErrorException,
            InvalidParameterException, InvalidParameterValueException, ServerInternalErrorException, HomeRegionNotSetException,
            AwsServiceException, SdkClientException, ApplicationDiscoveryException {
        return describeConfigurations(DescribeConfigurationsRequest.builder().applyMutation(describeConfigurationsRequest)
                .build());
    }

    /**
     * <p>
     * Lists exports as specified by ID. All continuous exports associated with your user can be listed if you call
     * <code>DescribeContinuousExports</code> as is without passing any parameters.
     * </p>
     *
     * @param describeContinuousExportsRequest
     * @return Result of the DescribeContinuousExports operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws OperationNotPermittedException
     *         This operation is not permitted.
     * @throws ResourceNotFoundException
     *         The specified configuration ID was not located. Verify the configuration ID and try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.DescribeContinuousExports
     */
    default DescribeContinuousExportsResponse describeContinuousExports(
            DescribeContinuousExportsRequest describeContinuousExportsRequest) throws AuthorizationErrorException,
            InvalidParameterException, InvalidParameterValueException, ServerInternalErrorException,
            OperationNotPermittedException, ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException,
            SdkClientException, ApplicationDiscoveryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists exports as specified by ID. All continuous exports associated with your user can be listed if you call
     * <code>DescribeContinuousExports</code> as is without passing any parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeContinuousExportsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeContinuousExportsRequest#builder()}
     * </p>
     *
     * @param describeContinuousExportsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeContinuousExportsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeContinuousExports operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws OperationNotPermittedException
     *         This operation is not permitted.
     * @throws ResourceNotFoundException
     *         The specified configuration ID was not located. Verify the configuration ID and try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.DescribeContinuousExports
     */
    default DescribeContinuousExportsResponse describeContinuousExports(
            Consumer<DescribeContinuousExportsRequest.Builder> describeContinuousExportsRequest)
            throws AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException,
            ServerInternalErrorException, OperationNotPermittedException, ResourceNotFoundException, HomeRegionNotSetException,
            AwsServiceException, SdkClientException, ApplicationDiscoveryException {
        return describeContinuousExports(DescribeContinuousExportsRequest.builder()
                .applyMutation(describeContinuousExportsRequest).build());
    }

    /**
     * <p>
     * Lists exports as specified by ID. All continuous exports associated with your user can be listed if you call
     * <code>DescribeContinuousExports</code> as is without passing any parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeContinuousExports(software.amazon.awssdk.services.applicationdiscovery.model.DescribeContinuousExportsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationdiscovery.paginators.DescribeContinuousExportsIterable responses = client.describeContinuousExportsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.applicationdiscovery.paginators.DescribeContinuousExportsIterable responses = client
     *             .describeContinuousExportsPaginator(request);
     *     for (software.amazon.awssdk.services.applicationdiscovery.model.DescribeContinuousExportsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationdiscovery.paginators.DescribeContinuousExportsIterable responses = client.describeContinuousExportsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeContinuousExports(software.amazon.awssdk.services.applicationdiscovery.model.DescribeContinuousExportsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeContinuousExportsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws OperationNotPermittedException
     *         This operation is not permitted.
     * @throws ResourceNotFoundException
     *         The specified configuration ID was not located. Verify the configuration ID and try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.DescribeContinuousExports
     */
    default DescribeContinuousExportsIterable describeContinuousExportsPaginator(
            DescribeContinuousExportsRequest describeContinuousExportsRequest) throws AuthorizationErrorException,
            InvalidParameterException, InvalidParameterValueException, ServerInternalErrorException,
            OperationNotPermittedException, ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException,
            SdkClientException, ApplicationDiscoveryException {
        return new DescribeContinuousExportsIterable(this, describeContinuousExportsRequest);
    }

    /**
     * <p>
     * Lists exports as specified by ID. All continuous exports associated with your user can be listed if you call
     * <code>DescribeContinuousExports</code> as is without passing any parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeContinuousExports(software.amazon.awssdk.services.applicationdiscovery.model.DescribeContinuousExportsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationdiscovery.paginators.DescribeContinuousExportsIterable responses = client.describeContinuousExportsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.applicationdiscovery.paginators.DescribeContinuousExportsIterable responses = client
     *             .describeContinuousExportsPaginator(request);
     *     for (software.amazon.awssdk.services.applicationdiscovery.model.DescribeContinuousExportsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationdiscovery.paginators.DescribeContinuousExportsIterable responses = client.describeContinuousExportsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeContinuousExports(software.amazon.awssdk.services.applicationdiscovery.model.DescribeContinuousExportsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeContinuousExportsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeContinuousExportsRequest#builder()}
     * </p>
     *
     * @param describeContinuousExportsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeContinuousExportsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws OperationNotPermittedException
     *         This operation is not permitted.
     * @throws ResourceNotFoundException
     *         The specified configuration ID was not located. Verify the configuration ID and try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.DescribeContinuousExports
     */
    default DescribeContinuousExportsIterable describeContinuousExportsPaginator(
            Consumer<DescribeContinuousExportsRequest.Builder> describeContinuousExportsRequest)
            throws AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException,
            ServerInternalErrorException, OperationNotPermittedException, ResourceNotFoundException, HomeRegionNotSetException,
            AwsServiceException, SdkClientException, ApplicationDiscoveryException {
        return describeContinuousExportsPaginator(DescribeContinuousExportsRequest.builder()
                .applyMutation(describeContinuousExportsRequest).build());
    }

    /**
     * <p>
     * Retrieve status of one or more export tasks. You can retrieve the status of up to 100 export tasks.
     * </p>
     *
     * @param describeExportTasksRequest
     * @return Result of the DescribeExportTasks operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.DescribeExportTasks
     */
    default DescribeExportTasksResponse describeExportTasks(DescribeExportTasksRequest describeExportTasksRequest)
            throws AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException,
            ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException, SdkClientException,
            ApplicationDiscoveryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve status of one or more export tasks. You can retrieve the status of up to 100 export tasks.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeExportTasksRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeExportTasksRequest#builder()}
     * </p>
     *
     * @param describeExportTasksRequest
     *        A {@link Consumer} that will call methods on {@link DescribeExportTasksRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeExportTasks operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.DescribeExportTasks
     */
    default DescribeExportTasksResponse describeExportTasks(
            Consumer<DescribeExportTasksRequest.Builder> describeExportTasksRequest) throws AuthorizationErrorException,
            InvalidParameterException, InvalidParameterValueException, ServerInternalErrorException, HomeRegionNotSetException,
            AwsServiceException, SdkClientException, ApplicationDiscoveryException {
        return describeExportTasks(DescribeExportTasksRequest.builder().applyMutation(describeExportTasksRequest).build());
    }

    /**
     * <p>
     * Retrieve status of one or more export tasks. You can retrieve the status of up to 100 export tasks.
     * </p>
     *
     * @return Result of the DescribeExportTasks operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.DescribeExportTasks
     * @see #describeExportTasks(DescribeExportTasksRequest)
     */
    default DescribeExportTasksResponse describeExportTasks() throws AuthorizationErrorException, InvalidParameterException,
            InvalidParameterValueException, ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException,
            SdkClientException, ApplicationDiscoveryException {
        return describeExportTasks(DescribeExportTasksRequest.builder().build());
    }

    /**
     * <p>
     * Returns an array of import tasks for your account, including status information, times, IDs, the Amazon S3 Object
     * URL for the import file, and more.
     * </p>
     *
     * @param describeImportTasksRequest
     * @return Result of the DescribeImportTasks operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.DescribeImportTasks
     */
    default DescribeImportTasksResponse describeImportTasks(DescribeImportTasksRequest describeImportTasksRequest)
            throws AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException,
            ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException, SdkClientException,
            ApplicationDiscoveryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of import tasks for your account, including status information, times, IDs, the Amazon S3 Object
     * URL for the import file, and more.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeImportTasksRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeImportTasksRequest#builder()}
     * </p>
     *
     * @param describeImportTasksRequest
     *        A {@link Consumer} that will call methods on {@link DescribeImportTasksRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeImportTasks operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.DescribeImportTasks
     */
    default DescribeImportTasksResponse describeImportTasks(
            Consumer<DescribeImportTasksRequest.Builder> describeImportTasksRequest) throws AuthorizationErrorException,
            InvalidParameterException, InvalidParameterValueException, ServerInternalErrorException, HomeRegionNotSetException,
            AwsServiceException, SdkClientException, ApplicationDiscoveryException {
        return describeImportTasks(DescribeImportTasksRequest.builder().applyMutation(describeImportTasksRequest).build());
    }

    /**
     * <p>
     * Returns an array of import tasks for your account, including status information, times, IDs, the Amazon S3 Object
     * URL for the import file, and more.
     * </p>
     *
     * @return Result of the DescribeImportTasks operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.DescribeImportTasks
     * @see #describeImportTasks(DescribeImportTasksRequest)
     */
    default DescribeImportTasksResponse describeImportTasks() throws AuthorizationErrorException, InvalidParameterException,
            InvalidParameterValueException, ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException,
            SdkClientException, ApplicationDiscoveryException {
        return describeImportTasks(DescribeImportTasksRequest.builder().build());
    }

    /**
     * <p>
     * Returns an array of import tasks for your account, including status information, times, IDs, the Amazon S3 Object
     * URL for the import file, and more.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeImportTasks(software.amazon.awssdk.services.applicationdiscovery.model.DescribeImportTasksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationdiscovery.paginators.DescribeImportTasksIterable responses = client.describeImportTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.applicationdiscovery.paginators.DescribeImportTasksIterable responses = client
     *             .describeImportTasksPaginator(request);
     *     for (software.amazon.awssdk.services.applicationdiscovery.model.DescribeImportTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationdiscovery.paginators.DescribeImportTasksIterable responses = client.describeImportTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeImportTasks(software.amazon.awssdk.services.applicationdiscovery.model.DescribeImportTasksRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.DescribeImportTasks
     * @see #describeImportTasksPaginator(DescribeImportTasksRequest)
     */
    default DescribeImportTasksIterable describeImportTasksPaginator() throws AuthorizationErrorException,
            InvalidParameterException, InvalidParameterValueException, ServerInternalErrorException, HomeRegionNotSetException,
            AwsServiceException, SdkClientException, ApplicationDiscoveryException {
        return describeImportTasksPaginator(DescribeImportTasksRequest.builder().build());
    }

    /**
     * <p>
     * Returns an array of import tasks for your account, including status information, times, IDs, the Amazon S3 Object
     * URL for the import file, and more.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeImportTasks(software.amazon.awssdk.services.applicationdiscovery.model.DescribeImportTasksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationdiscovery.paginators.DescribeImportTasksIterable responses = client.describeImportTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.applicationdiscovery.paginators.DescribeImportTasksIterable responses = client
     *             .describeImportTasksPaginator(request);
     *     for (software.amazon.awssdk.services.applicationdiscovery.model.DescribeImportTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationdiscovery.paginators.DescribeImportTasksIterable responses = client.describeImportTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeImportTasks(software.amazon.awssdk.services.applicationdiscovery.model.DescribeImportTasksRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeImportTasksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.DescribeImportTasks
     */
    default DescribeImportTasksIterable describeImportTasksPaginator(DescribeImportTasksRequest describeImportTasksRequest)
            throws AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException,
            ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException, SdkClientException,
            ApplicationDiscoveryException {
        return new DescribeImportTasksIterable(this, describeImportTasksRequest);
    }

    /**
     * <p>
     * Returns an array of import tasks for your account, including status information, times, IDs, the Amazon S3 Object
     * URL for the import file, and more.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeImportTasks(software.amazon.awssdk.services.applicationdiscovery.model.DescribeImportTasksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationdiscovery.paginators.DescribeImportTasksIterable responses = client.describeImportTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.applicationdiscovery.paginators.DescribeImportTasksIterable responses = client
     *             .describeImportTasksPaginator(request);
     *     for (software.amazon.awssdk.services.applicationdiscovery.model.DescribeImportTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationdiscovery.paginators.DescribeImportTasksIterable responses = client.describeImportTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeImportTasks(software.amazon.awssdk.services.applicationdiscovery.model.DescribeImportTasksRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeImportTasksRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeImportTasksRequest#builder()}
     * </p>
     *
     * @param describeImportTasksRequest
     *        A {@link Consumer} that will call methods on {@link DescribeImportTasksRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.DescribeImportTasks
     */
    default DescribeImportTasksIterable describeImportTasksPaginator(
            Consumer<DescribeImportTasksRequest.Builder> describeImportTasksRequest) throws AuthorizationErrorException,
            InvalidParameterException, InvalidParameterValueException, ServerInternalErrorException, HomeRegionNotSetException,
            AwsServiceException, SdkClientException, ApplicationDiscoveryException {
        return describeImportTasksPaginator(DescribeImportTasksRequest.builder().applyMutation(describeImportTasksRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list of configuration items that have tags as specified by the key-value pairs, name and value,
     * passed to the optional parameter <code>filters</code>.
     * </p>
     * <p>
     * There are three valid tag filter names:
     * </p>
     * <ul>
     * <li>
     * <p>
     * tagKey
     * </p>
     * </li>
     * <li>
     * <p>
     * tagValue
     * </p>
     * </li>
     * <li>
     * <p>
     * configurationId
     * </p>
     * </li>
     * </ul>
     * <p>
     * Also, all configuration items associated with your user that have tags can be listed if you call
     * <code>DescribeTags</code> as is without passing any parameters.
     * </p>
     *
     * @param describeTagsRequest
     * @return Result of the DescribeTags operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws ResourceNotFoundException
     *         The specified configuration ID was not located. Verify the configuration ID and try again.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.DescribeTags
     */
    default DescribeTagsResponse describeTags(DescribeTagsRequest describeTagsRequest) throws AuthorizationErrorException,
            ResourceNotFoundException, InvalidParameterException, InvalidParameterValueException, ServerInternalErrorException,
            HomeRegionNotSetException, AwsServiceException, SdkClientException, ApplicationDiscoveryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of configuration items that have tags as specified by the key-value pairs, name and value,
     * passed to the optional parameter <code>filters</code>.
     * </p>
     * <p>
     * There are three valid tag filter names:
     * </p>
     * <ul>
     * <li>
     * <p>
     * tagKey
     * </p>
     * </li>
     * <li>
     * <p>
     * tagValue
     * </p>
     * </li>
     * <li>
     * <p>
     * configurationId
     * </p>
     * </li>
     * </ul>
     * <p>
     * Also, all configuration items associated with your user that have tags can be listed if you call
     * <code>DescribeTags</code> as is without passing any parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTagsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeTagsRequest#builder()}
     * </p>
     *
     * @param describeTagsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTagsRequest.Builder} to create a request.
     * @return Result of the DescribeTags operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws ResourceNotFoundException
     *         The specified configuration ID was not located. Verify the configuration ID and try again.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.DescribeTags
     */
    default DescribeTagsResponse describeTags(Consumer<DescribeTagsRequest.Builder> describeTagsRequest)
            throws AuthorizationErrorException, ResourceNotFoundException, InvalidParameterException,
            InvalidParameterValueException, ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException,
            SdkClientException, ApplicationDiscoveryException {
        return describeTags(DescribeTagsRequest.builder().applyMutation(describeTagsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of configuration items that have tags as specified by the key-value pairs, name and value,
     * passed to the optional parameter <code>filters</code>.
     * </p>
     * <p>
     * There are three valid tag filter names:
     * </p>
     * <ul>
     * <li>
     * <p>
     * tagKey
     * </p>
     * </li>
     * <li>
     * <p>
     * tagValue
     * </p>
     * </li>
     * <li>
     * <p>
     * configurationId
     * </p>
     * </li>
     * </ul>
     * <p>
     * Also, all configuration items associated with your user that have tags can be listed if you call
     * <code>DescribeTags</code> as is without passing any parameters.
     * </p>
     *
     * @return Result of the DescribeTags operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws ResourceNotFoundException
     *         The specified configuration ID was not located. Verify the configuration ID and try again.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.DescribeTags
     * @see #describeTags(DescribeTagsRequest)
     */
    default DescribeTagsResponse describeTags() throws AuthorizationErrorException, ResourceNotFoundException,
            InvalidParameterException, InvalidParameterValueException, ServerInternalErrorException, HomeRegionNotSetException,
            AwsServiceException, SdkClientException, ApplicationDiscoveryException {
        return describeTags(DescribeTagsRequest.builder().build());
    }

    /**
     * <p>
     * Disassociates one or more configuration items from an application.
     * </p>
     *
     * @param disassociateConfigurationItemsFromApplicationRequest
     * @return Result of the DisassociateConfigurationItemsFromApplication operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.DisassociateConfigurationItemsFromApplication
     */
    default DisassociateConfigurationItemsFromApplicationResponse disassociateConfigurationItemsFromApplication(
            DisassociateConfigurationItemsFromApplicationRequest disassociateConfigurationItemsFromApplicationRequest)
            throws AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException,
            ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException, SdkClientException,
            ApplicationDiscoveryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates one or more configuration items from an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateConfigurationItemsFromApplicationRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateConfigurationItemsFromApplicationRequest#builder()}
     * </p>
     *
     * @param disassociateConfigurationItemsFromApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DisassociateConfigurationItemsFromApplicationRequest.Builder} to create a request.
     * @return Result of the DisassociateConfigurationItemsFromApplication operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.DisassociateConfigurationItemsFromApplication
     */
    default DisassociateConfigurationItemsFromApplicationResponse disassociateConfigurationItemsFromApplication(
            Consumer<DisassociateConfigurationItemsFromApplicationRequest.Builder> disassociateConfigurationItemsFromApplicationRequest)
            throws AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException,
            ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException, SdkClientException,
            ApplicationDiscoveryException {
        return disassociateConfigurationItemsFromApplication(DisassociateConfigurationItemsFromApplicationRequest.builder()
                .applyMutation(disassociateConfigurationItemsFromApplicationRequest).build());
    }

    /**
     * <p>
     * Retrieves a short summary of discovered assets.
     * </p>
     * <p>
     * This API operation takes no request parameters and is called as is at the command prompt as shown in the example.
     * </p>
     *
     * @param getDiscoverySummaryRequest
     * @return Result of the GetDiscoverySummary operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.GetDiscoverySummary
     */
    default GetDiscoverySummaryResponse getDiscoverySummary(GetDiscoverySummaryRequest getDiscoverySummaryRequest)
            throws AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException,
            ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException, SdkClientException,
            ApplicationDiscoveryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a short summary of discovered assets.
     * </p>
     * <p>
     * This API operation takes no request parameters and is called as is at the command prompt as shown in the example.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDiscoverySummaryRequest.Builder} avoiding the
     * need to create one manually via {@link GetDiscoverySummaryRequest#builder()}
     * </p>
     *
     * @param getDiscoverySummaryRequest
     *        A {@link Consumer} that will call methods on {@link GetDiscoverySummaryRequest.Builder} to create a
     *        request.
     * @return Result of the GetDiscoverySummary operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.GetDiscoverySummary
     */
    default GetDiscoverySummaryResponse getDiscoverySummary(
            Consumer<GetDiscoverySummaryRequest.Builder> getDiscoverySummaryRequest) throws AuthorizationErrorException,
            InvalidParameterException, InvalidParameterValueException, ServerInternalErrorException, HomeRegionNotSetException,
            AwsServiceException, SdkClientException, ApplicationDiscoveryException {
        return getDiscoverySummary(GetDiscoverySummaryRequest.builder().applyMutation(getDiscoverySummaryRequest).build());
    }

    /**
     * <p>
     * Retrieves a short summary of discovered assets.
     * </p>
     * <p>
     * This API operation takes no request parameters and is called as is at the command prompt as shown in the example.
     * </p>
     *
     * @return Result of the GetDiscoverySummary operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.GetDiscoverySummary
     * @see #getDiscoverySummary(GetDiscoverySummaryRequest)
     */
    default GetDiscoverySummaryResponse getDiscoverySummary() throws AuthorizationErrorException, InvalidParameterException,
            InvalidParameterValueException, ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException,
            SdkClientException, ApplicationDiscoveryException {
        return getDiscoverySummary(GetDiscoverySummaryRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves a list of configuration items as specified by the value passed to the required parameter
     * <code>configurationType</code>. Optional filtering may be applied to refine search results.
     * </p>
     *
     * @param listConfigurationsRequest
     * @return Result of the ListConfigurations operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws ResourceNotFoundException
     *         The specified configuration ID was not located. Verify the configuration ID and try again.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.ListConfigurations
     */
    default ListConfigurationsResponse listConfigurations(ListConfigurationsRequest listConfigurationsRequest)
            throws AuthorizationErrorException, ResourceNotFoundException, InvalidParameterException,
            InvalidParameterValueException, ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException,
            SdkClientException, ApplicationDiscoveryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of configuration items as specified by the value passed to the required parameter
     * <code>configurationType</code>. Optional filtering may be applied to refine search results.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfigurationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListConfigurationsRequest#builder()}
     * </p>
     *
     * @param listConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link ListConfigurationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListConfigurations operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws ResourceNotFoundException
     *         The specified configuration ID was not located. Verify the configuration ID and try again.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.ListConfigurations
     */
    default ListConfigurationsResponse listConfigurations(Consumer<ListConfigurationsRequest.Builder> listConfigurationsRequest)
            throws AuthorizationErrorException, ResourceNotFoundException, InvalidParameterException,
            InvalidParameterValueException, ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException,
            SdkClientException, ApplicationDiscoveryException {
        return listConfigurations(ListConfigurationsRequest.builder().applyMutation(listConfigurationsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of servers that are one network hop away from a specified server.
     * </p>
     *
     * @param listServerNeighborsRequest
     * @return Result of the ListServerNeighbors operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.ListServerNeighbors
     */
    default ListServerNeighborsResponse listServerNeighbors(ListServerNeighborsRequest listServerNeighborsRequest)
            throws AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException,
            ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException, SdkClientException,
            ApplicationDiscoveryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of servers that are one network hop away from a specified server.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServerNeighborsRequest.Builder} avoiding the
     * need to create one manually via {@link ListServerNeighborsRequest#builder()}
     * </p>
     *
     * @param listServerNeighborsRequest
     *        A {@link Consumer} that will call methods on {@link ListServerNeighborsRequest.Builder} to create a
     *        request.
     * @return Result of the ListServerNeighbors operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.ListServerNeighbors
     */
    default ListServerNeighborsResponse listServerNeighbors(
            Consumer<ListServerNeighborsRequest.Builder> listServerNeighborsRequest) throws AuthorizationErrorException,
            InvalidParameterException, InvalidParameterValueException, ServerInternalErrorException, HomeRegionNotSetException,
            AwsServiceException, SdkClientException, ApplicationDiscoveryException {
        return listServerNeighbors(ListServerNeighborsRequest.builder().applyMutation(listServerNeighborsRequest).build());
    }

    /**
     * <p>
     * Start the continuous flow of agent's discovered data into Amazon Athena.
     * </p>
     *
     * @param startContinuousExportRequest
     * @return Result of the StartContinuousExport operation returned by the service.
     * @throws ConflictErrorException
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws OperationNotPermittedException
     *         This operation is not permitted.
     * @throws ResourceInUseException
     *         This issue occurs when the same <code>clientRequestToken</code> is used with the
     *         <code>StartImportTask</code> action, but with different parameters. For example, you use the same request
     *         token but have two different import URLs, you can encounter this issue. If the import tasks are meant to
     *         be different, use a different <code>clientRequestToken</code>, and try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.StartContinuousExport
     */
    default StartContinuousExportResponse startContinuousExport(StartContinuousExportRequest startContinuousExportRequest)
            throws ConflictErrorException, AuthorizationErrorException, InvalidParameterException,
            InvalidParameterValueException, ServerInternalErrorException, OperationNotPermittedException, ResourceInUseException,
            HomeRegionNotSetException, AwsServiceException, SdkClientException, ApplicationDiscoveryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Start the continuous flow of agent's discovered data into Amazon Athena.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartContinuousExportRequest.Builder} avoiding the
     * need to create one manually via {@link StartContinuousExportRequest#builder()}
     * </p>
     *
     * @param startContinuousExportRequest
     *        A {@link Consumer} that will call methods on {@link StartContinuousExportRequest.Builder} to create a
     *        request.
     * @return Result of the StartContinuousExport operation returned by the service.
     * @throws ConflictErrorException
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws OperationNotPermittedException
     *         This operation is not permitted.
     * @throws ResourceInUseException
     *         This issue occurs when the same <code>clientRequestToken</code> is used with the
     *         <code>StartImportTask</code> action, but with different parameters. For example, you use the same request
     *         token but have two different import URLs, you can encounter this issue. If the import tasks are meant to
     *         be different, use a different <code>clientRequestToken</code>, and try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.StartContinuousExport
     */
    default StartContinuousExportResponse startContinuousExport(
            Consumer<StartContinuousExportRequest.Builder> startContinuousExportRequest) throws ConflictErrorException,
            AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException, ServerInternalErrorException,
            OperationNotPermittedException, ResourceInUseException, HomeRegionNotSetException, AwsServiceException,
            SdkClientException, ApplicationDiscoveryException {
        return startContinuousExport(StartContinuousExportRequest.builder().applyMutation(startContinuousExportRequest).build());
    }

    /**
     * <p>
     * Instructs the specified agents to start collecting data.
     * </p>
     *
     * @param startDataCollectionByAgentIdsRequest
     * @return Result of the StartDataCollectionByAgentIds operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.StartDataCollectionByAgentIds
     */
    default StartDataCollectionByAgentIdsResponse startDataCollectionByAgentIds(
            StartDataCollectionByAgentIdsRequest startDataCollectionByAgentIdsRequest) throws AuthorizationErrorException,
            InvalidParameterException, InvalidParameterValueException, ServerInternalErrorException, HomeRegionNotSetException,
            AwsServiceException, SdkClientException, ApplicationDiscoveryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Instructs the specified agents to start collecting data.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartDataCollectionByAgentIdsRequest.Builder}
     * avoiding the need to create one manually via {@link StartDataCollectionByAgentIdsRequest#builder()}
     * </p>
     *
     * @param startDataCollectionByAgentIdsRequest
     *        A {@link Consumer} that will call methods on {@link StartDataCollectionByAgentIdsRequest.Builder} to
     *        create a request.
     * @return Result of the StartDataCollectionByAgentIds operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.StartDataCollectionByAgentIds
     */
    default StartDataCollectionByAgentIdsResponse startDataCollectionByAgentIds(
            Consumer<StartDataCollectionByAgentIdsRequest.Builder> startDataCollectionByAgentIdsRequest)
            throws AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException,
            ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException, SdkClientException,
            ApplicationDiscoveryException {
        return startDataCollectionByAgentIds(StartDataCollectionByAgentIdsRequest.builder()
                .applyMutation(startDataCollectionByAgentIdsRequest).build());
    }

    /**
     * <p>
     * Begins the export of a discovered data report to an Amazon S3 bucket managed by Amazon Web Services.
     * </p>
     * <note>
     * <p>
     * Exports might provide an estimate of fees and savings based on certain information that you provide. Fee
     * estimates do not include any taxes that might apply. Your actual fees and savings depend on a variety of factors,
     * including your actual usage of Amazon Web Services services, which might vary from the estimates provided in this
     * report.
     * </p>
     * </note>
     * <p>
     * If you do not specify <code>preferences</code> or <code>agentIds</code> in the filter, a summary of all servers,
     * applications, tags, and performance is generated. This data is an aggregation of all server data collected
     * through on-premises tooling, file import, application grouping and applying tags.
     * </p>
     * <p>
     * If you specify <code>agentIds</code> in a filter, the task exports up to 72 hours of detailed data collected by
     * the identified Application Discovery Agent, including network, process, and performance details. A time range for
     * exported agent data may be set by using <code>startTime</code> and <code>endTime</code>. Export of detailed agent
     * data is limited to five concurrently running exports. Export of detailed agent data is limited to two exports per
     * day.
     * </p>
     * <p>
     * If you enable <code>ec2RecommendationsPreferences</code> in <code>preferences</code> , an Amazon EC2 instance
     * matching the characteristics of each server in Application Discovery Service is generated. Changing the
     * attributes of the <code>ec2RecommendationsPreferences</code> changes the criteria of the recommendation.
     * </p>
     *
     * @param startExportTaskRequest
     * @return Result of the StartExportTask operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws OperationNotPermittedException
     *         This operation is not permitted.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.StartExportTask
     */
    default StartExportTaskResponse startExportTask(StartExportTaskRequest startExportTaskRequest)
            throws AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException,
            ServerInternalErrorException, OperationNotPermittedException, HomeRegionNotSetException, AwsServiceException,
            SdkClientException, ApplicationDiscoveryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Begins the export of a discovered data report to an Amazon S3 bucket managed by Amazon Web Services.
     * </p>
     * <note>
     * <p>
     * Exports might provide an estimate of fees and savings based on certain information that you provide. Fee
     * estimates do not include any taxes that might apply. Your actual fees and savings depend on a variety of factors,
     * including your actual usage of Amazon Web Services services, which might vary from the estimates provided in this
     * report.
     * </p>
     * </note>
     * <p>
     * If you do not specify <code>preferences</code> or <code>agentIds</code> in the filter, a summary of all servers,
     * applications, tags, and performance is generated. This data is an aggregation of all server data collected
     * through on-premises tooling, file import, application grouping and applying tags.
     * </p>
     * <p>
     * If you specify <code>agentIds</code> in a filter, the task exports up to 72 hours of detailed data collected by
     * the identified Application Discovery Agent, including network, process, and performance details. A time range for
     * exported agent data may be set by using <code>startTime</code> and <code>endTime</code>. Export of detailed agent
     * data is limited to five concurrently running exports. Export of detailed agent data is limited to two exports per
     * day.
     * </p>
     * <p>
     * If you enable <code>ec2RecommendationsPreferences</code> in <code>preferences</code> , an Amazon EC2 instance
     * matching the characteristics of each server in Application Discovery Service is generated. Changing the
     * attributes of the <code>ec2RecommendationsPreferences</code> changes the criteria of the recommendation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartExportTaskRequest.Builder} avoiding the need
     * to create one manually via {@link StartExportTaskRequest#builder()}
     * </p>
     *
     * @param startExportTaskRequest
     *        A {@link Consumer} that will call methods on {@link StartExportTaskRequest.Builder} to create a request.
     * @return Result of the StartExportTask operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws OperationNotPermittedException
     *         This operation is not permitted.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.StartExportTask
     */
    default StartExportTaskResponse startExportTask(Consumer<StartExportTaskRequest.Builder> startExportTaskRequest)
            throws AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException,
            ServerInternalErrorException, OperationNotPermittedException, HomeRegionNotSetException, AwsServiceException,
            SdkClientException, ApplicationDiscoveryException {
        return startExportTask(StartExportTaskRequest.builder().applyMutation(startExportTaskRequest).build());
    }

    /**
     * <p>
     * Begins the export of a discovered data report to an Amazon S3 bucket managed by Amazon Web Services.
     * </p>
     * <note>
     * <p>
     * Exports might provide an estimate of fees and savings based on certain information that you provide. Fee
     * estimates do not include any taxes that might apply. Your actual fees and savings depend on a variety of factors,
     * including your actual usage of Amazon Web Services services, which might vary from the estimates provided in this
     * report.
     * </p>
     * </note>
     * <p>
     * If you do not specify <code>preferences</code> or <code>agentIds</code> in the filter, a summary of all servers,
     * applications, tags, and performance is generated. This data is an aggregation of all server data collected
     * through on-premises tooling, file import, application grouping and applying tags.
     * </p>
     * <p>
     * If you specify <code>agentIds</code> in a filter, the task exports up to 72 hours of detailed data collected by
     * the identified Application Discovery Agent, including network, process, and performance details. A time range for
     * exported agent data may be set by using <code>startTime</code> and <code>endTime</code>. Export of detailed agent
     * data is limited to five concurrently running exports. Export of detailed agent data is limited to two exports per
     * day.
     * </p>
     * <p>
     * If you enable <code>ec2RecommendationsPreferences</code> in <code>preferences</code> , an Amazon EC2 instance
     * matching the characteristics of each server in Application Discovery Service is generated. Changing the
     * attributes of the <code>ec2RecommendationsPreferences</code> changes the criteria of the recommendation.
     * </p>
     *
     * @return Result of the StartExportTask operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws OperationNotPermittedException
     *         This operation is not permitted.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.StartExportTask
     * @see #startExportTask(StartExportTaskRequest)
     */
    default StartExportTaskResponse startExportTask() throws AuthorizationErrorException, InvalidParameterException,
            InvalidParameterValueException, ServerInternalErrorException, OperationNotPermittedException,
            HomeRegionNotSetException, AwsServiceException, SdkClientException, ApplicationDiscoveryException {
        return startExportTask(StartExportTaskRequest.builder().build());
    }

    /**
     * <p>
     * Starts an import task, which allows you to import details of your on-premises environment directly into Amazon
     * Web Services Migration Hub without having to use the Amazon Web Services Application Discovery Service
     * (Application Discovery Service) tools such as the Amazon Web Services Application Discovery Service Agentless
     * Collector or Application Discovery Agent. This gives you the option to perform migration assessment and planning
     * directly from your imported data, including the ability to group your devices as applications and track their
     * migration status.
     * </p>
     * <p>
     * To start an import request, do this:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Download the specially formatted comma separated value (CSV) import template, which you can find here: <a
     * href="https://s3.us-west-2.amazonaws.com/templates-7cffcf56-bd96-4b1c-b45b-a5b42f282e46/import_template.csv"
     * >https://s3.us-west-2.amazonaws.com/templates-7cffcf56-bd96-4b1c-b45b-a5b42f282e46/import_template.csv</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Fill out the template with your server and application data.
     * </p>
     * </li>
     * <li>
     * <p>
     * Upload your import file to an Amazon S3 bucket, and make a note of it's Object URL. Your import file must be in
     * the CSV format.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the console or the <code>StartImportTask</code> command with the Amazon Web Services CLI or one of the Amazon
     * Web Services SDKs to import the records from your file.
     * </p>
     * </li>
     * </ol>
     * <p>
     * For more information, including step-by-step procedures, see <a
     * href="https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-import.html">Migration Hub
     * Import</a> in the <i>Amazon Web Services Application Discovery Service User Guide</i>.
     * </p>
     * <note>
     * <p>
     * There are limits to the number of import tasks you can create (and delete) in an Amazon Web Services account. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/application-discovery/latest/userguide/ads_service_limits.html">Amazon Web
     * Services Application Discovery Service Limits</a> in the <i>Amazon Web Services Application Discovery Service
     * User Guide</i>.
     * </p>
     * </note>
     *
     * @param startImportTaskRequest
     * @return Result of the StartImportTask operation returned by the service.
     * @throws ResourceInUseException
     *         This issue occurs when the same <code>clientRequestToken</code> is used with the
     *         <code>StartImportTask</code> action, but with different parameters. For example, you use the same request
     *         token but have two different import URLs, you can encounter this issue. If the import tasks are meant to
     *         be different, use a different <code>clientRequestToken</code>, and try again.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.StartImportTask
     */
    default StartImportTaskResponse startImportTask(StartImportTaskRequest startImportTaskRequest) throws ResourceInUseException,
            AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException, ServerInternalErrorException,
            HomeRegionNotSetException, AwsServiceException, SdkClientException, ApplicationDiscoveryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an import task, which allows you to import details of your on-premises environment directly into Amazon
     * Web Services Migration Hub without having to use the Amazon Web Services Application Discovery Service
     * (Application Discovery Service) tools such as the Amazon Web Services Application Discovery Service Agentless
     * Collector or Application Discovery Agent. This gives you the option to perform migration assessment and planning
     * directly from your imported data, including the ability to group your devices as applications and track their
     * migration status.
     * </p>
     * <p>
     * To start an import request, do this:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Download the specially formatted comma separated value (CSV) import template, which you can find here: <a
     * href="https://s3.us-west-2.amazonaws.com/templates-7cffcf56-bd96-4b1c-b45b-a5b42f282e46/import_template.csv"
     * >https://s3.us-west-2.amazonaws.com/templates-7cffcf56-bd96-4b1c-b45b-a5b42f282e46/import_template.csv</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Fill out the template with your server and application data.
     * </p>
     * </li>
     * <li>
     * <p>
     * Upload your import file to an Amazon S3 bucket, and make a note of it's Object URL. Your import file must be in
     * the CSV format.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the console or the <code>StartImportTask</code> command with the Amazon Web Services CLI or one of the Amazon
     * Web Services SDKs to import the records from your file.
     * </p>
     * </li>
     * </ol>
     * <p>
     * For more information, including step-by-step procedures, see <a
     * href="https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-import.html">Migration Hub
     * Import</a> in the <i>Amazon Web Services Application Discovery Service User Guide</i>.
     * </p>
     * <note>
     * <p>
     * There are limits to the number of import tasks you can create (and delete) in an Amazon Web Services account. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/application-discovery/latest/userguide/ads_service_limits.html">Amazon Web
     * Services Application Discovery Service Limits</a> in the <i>Amazon Web Services Application Discovery Service
     * User Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartImportTaskRequest.Builder} avoiding the need
     * to create one manually via {@link StartImportTaskRequest#builder()}
     * </p>
     *
     * @param startImportTaskRequest
     *        A {@link Consumer} that will call methods on {@link StartImportTaskRequest.Builder} to create a request.
     * @return Result of the StartImportTask operation returned by the service.
     * @throws ResourceInUseException
     *         This issue occurs when the same <code>clientRequestToken</code> is used with the
     *         <code>StartImportTask</code> action, but with different parameters. For example, you use the same request
     *         token but have two different import URLs, you can encounter this issue. If the import tasks are meant to
     *         be different, use a different <code>clientRequestToken</code>, and try again.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.StartImportTask
     */
    default StartImportTaskResponse startImportTask(Consumer<StartImportTaskRequest.Builder> startImportTaskRequest)
            throws ResourceInUseException, AuthorizationErrorException, InvalidParameterException,
            InvalidParameterValueException, ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException,
            SdkClientException, ApplicationDiscoveryException {
        return startImportTask(StartImportTaskRequest.builder().applyMutation(startImportTaskRequest).build());
    }

    /**
     * <p>
     * Stop the continuous flow of agent's discovered data into Amazon Athena.
     * </p>
     *
     * @param stopContinuousExportRequest
     * @return Result of the StopContinuousExport operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws OperationNotPermittedException
     *         This operation is not permitted.
     * @throws ResourceNotFoundException
     *         The specified configuration ID was not located. Verify the configuration ID and try again.
     * @throws ResourceInUseException
     *         This issue occurs when the same <code>clientRequestToken</code> is used with the
     *         <code>StartImportTask</code> action, but with different parameters. For example, you use the same request
     *         token but have two different import URLs, you can encounter this issue. If the import tasks are meant to
     *         be different, use a different <code>clientRequestToken</code>, and try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.StopContinuousExport
     */
    default StopContinuousExportResponse stopContinuousExport(StopContinuousExportRequest stopContinuousExportRequest)
            throws AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException,
            ServerInternalErrorException, OperationNotPermittedException, ResourceNotFoundException, ResourceInUseException,
            HomeRegionNotSetException, AwsServiceException, SdkClientException, ApplicationDiscoveryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stop the continuous flow of agent's discovered data into Amazon Athena.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopContinuousExportRequest.Builder} avoiding the
     * need to create one manually via {@link StopContinuousExportRequest#builder()}
     * </p>
     *
     * @param stopContinuousExportRequest
     *        A {@link Consumer} that will call methods on {@link StopContinuousExportRequest.Builder} to create a
     *        request.
     * @return Result of the StopContinuousExport operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws OperationNotPermittedException
     *         This operation is not permitted.
     * @throws ResourceNotFoundException
     *         The specified configuration ID was not located. Verify the configuration ID and try again.
     * @throws ResourceInUseException
     *         This issue occurs when the same <code>clientRequestToken</code> is used with the
     *         <code>StartImportTask</code> action, but with different parameters. For example, you use the same request
     *         token but have two different import URLs, you can encounter this issue. If the import tasks are meant to
     *         be different, use a different <code>clientRequestToken</code>, and try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.StopContinuousExport
     */
    default StopContinuousExportResponse stopContinuousExport(
            Consumer<StopContinuousExportRequest.Builder> stopContinuousExportRequest) throws AuthorizationErrorException,
            InvalidParameterException, InvalidParameterValueException, ServerInternalErrorException,
            OperationNotPermittedException, ResourceNotFoundException, ResourceInUseException, HomeRegionNotSetException,
            AwsServiceException, SdkClientException, ApplicationDiscoveryException {
        return stopContinuousExport(StopContinuousExportRequest.builder().applyMutation(stopContinuousExportRequest).build());
    }

    /**
     * <p>
     * Instructs the specified agents to stop collecting data.
     * </p>
     *
     * @param stopDataCollectionByAgentIdsRequest
     * @return Result of the StopDataCollectionByAgentIds operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.StopDataCollectionByAgentIds
     */
    default StopDataCollectionByAgentIdsResponse stopDataCollectionByAgentIds(
            StopDataCollectionByAgentIdsRequest stopDataCollectionByAgentIdsRequest) throws AuthorizationErrorException,
            InvalidParameterException, InvalidParameterValueException, ServerInternalErrorException, HomeRegionNotSetException,
            AwsServiceException, SdkClientException, ApplicationDiscoveryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Instructs the specified agents to stop collecting data.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopDataCollectionByAgentIdsRequest.Builder}
     * avoiding the need to create one manually via {@link StopDataCollectionByAgentIdsRequest#builder()}
     * </p>
     *
     * @param stopDataCollectionByAgentIdsRequest
     *        A {@link Consumer} that will call methods on {@link StopDataCollectionByAgentIdsRequest.Builder} to create
     *        a request.
     * @return Result of the StopDataCollectionByAgentIds operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.StopDataCollectionByAgentIds
     */
    default StopDataCollectionByAgentIdsResponse stopDataCollectionByAgentIds(
            Consumer<StopDataCollectionByAgentIdsRequest.Builder> stopDataCollectionByAgentIdsRequest)
            throws AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException,
            ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException, SdkClientException,
            ApplicationDiscoveryException {
        return stopDataCollectionByAgentIds(StopDataCollectionByAgentIdsRequest.builder()
                .applyMutation(stopDataCollectionByAgentIdsRequest).build());
    }

    /**
     * <p>
     * Updates metadata about an application.
     * </p>
     *
     * @param updateApplicationRequest
     * @return Result of the UpdateApplication operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.UpdateApplication
     */
    default UpdateApplicationResponse updateApplication(UpdateApplicationRequest updateApplicationRequest)
            throws AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException,
            ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException, SdkClientException,
            ApplicationDiscoveryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates metadata about an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateApplicationRequest#builder()}
     * </p>
     *
     * @param updateApplicationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateApplicationRequest.Builder} to create a request.
     * @return Result of the UpdateApplication operation returned by the service.
     * @throws AuthorizationErrorException
     *         The user does not have permission to perform the action. Check the IAM policy associated with this user.
     * @throws InvalidParameterException
     *         One or more parameters are not valid. Verify the parameters and try again.
     * @throws InvalidParameterValueException
     *         The value of one or more parameters are either invalid or out of range. Verify the parameter values and
     *         try again.
     * @throws ServerInternalErrorException
     *         The server experienced an internal error. Try again.
     * @throws HomeRegionNotSetException
     *         The home Region is not set. Set the home Region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ApplicationDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ApplicationDiscoveryClient.UpdateApplication
     */
    default UpdateApplicationResponse updateApplication(Consumer<UpdateApplicationRequest.Builder> updateApplicationRequest)
            throws AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException,
            ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException, SdkClientException,
            ApplicationDiscoveryException {
        return updateApplication(UpdateApplicationRequest.builder().applyMutation(updateApplicationRequest).build());
    }

    /**
     * Create a {@link ApplicationDiscoveryClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ApplicationDiscoveryClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ApplicationDiscoveryClient}.
     */
    static ApplicationDiscoveryClientBuilder builder() {
        return new DefaultApplicationDiscoveryClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default ApplicationDiscoveryServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
