/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationdiscovery.model.ApplicationDiscoveryRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.ExportDataFormat;
import software.amazon.awssdk.services.applicationdiscovery.model.ExportDataFormatsCopier;
import software.amazon.awssdk.services.applicationdiscovery.model.ExportFilter;
import software.amazon.awssdk.services.applicationdiscovery.model.ExportFiltersCopier;
import software.amazon.awssdk.services.applicationdiscovery.model.ExportPreferences;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartExportTaskRequest
extends ApplicationDiscoveryRequest
implements ToCopyableBuilder<Builder, StartExportTaskRequest> {
    private static final SdkField<List<String>> EXPORT_DATA_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("exportDataFormat").getter(StartExportTaskRequest.getter(StartExportTaskRequest::exportDataFormatAsStrings)).setter(StartExportTaskRequest.setter(Builder::exportDataFormatWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportDataFormat").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ExportFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("filters").getter(StartExportTaskRequest.getter(StartExportTaskRequest::filters)).setter(StartExportTaskRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExportFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(StartExportTaskRequest.getter(StartExportTaskRequest::startTime)).setter(StartExportTaskRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(StartExportTaskRequest.getter(StartExportTaskRequest::endTime)).setter(StartExportTaskRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<ExportPreferences> PREFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("preferences").getter(StartExportTaskRequest.getter(StartExportTaskRequest::preferences)).setter(StartExportTaskRequest.setter(Builder::preferences)).constructor(ExportPreferences::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preferences").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_DATA_FORMAT_FIELD, FILTERS_FIELD, START_TIME_FIELD, END_TIME_FIELD, PREFERENCES_FIELD));
    private final List<String> exportDataFormat;
    private final List<ExportFilter> filters;
    private final Instant startTime;
    private final Instant endTime;
    private final ExportPreferences preferences;

    private StartExportTaskRequest(BuilderImpl builder) {
        super(builder);
        this.exportDataFormat = builder.exportDataFormat;
        this.filters = builder.filters;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.preferences = builder.preferences;
    }

    public final List<ExportDataFormat> exportDataFormat() {
        return ExportDataFormatsCopier.copyStringToEnum(this.exportDataFormat);
    }

    public final boolean hasExportDataFormat() {
        return this.exportDataFormat != null && !(this.exportDataFormat instanceof SdkAutoConstructList);
    }

    public final List<String> exportDataFormatAsStrings() {
        return this.exportDataFormat;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<ExportFilter> filters() {
        return this.filters;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final ExportPreferences preferences() {
        return this.preferences;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExportDataFormat() ? this.exportDataFormatAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferences());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartExportTaskRequest)) {
            return false;
        }
        StartExportTaskRequest other = (StartExportTaskRequest)((Object)obj);
        return this.hasExportDataFormat() == other.hasExportDataFormat() && Objects.equals(this.exportDataFormatAsStrings(), other.exportDataFormatAsStrings()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.preferences(), other.preferences());
    }

    public final String toString() {
        return ToString.builder((String)"StartExportTaskRequest").add("ExportDataFormat", this.hasExportDataFormat() ? this.exportDataFormatAsStrings() : null).add("Filters", this.hasFilters() ? this.filters() : null).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Preferences", (Object)this.preferences()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "exportDataFormat": {
                return Optional.ofNullable(clazz.cast(this.exportDataFormatAsStrings()));
            }
            case "filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "preferences": {
                return Optional.ofNullable(clazz.cast(this.preferences()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartExportTaskRequest, T> g) {
        return obj -> g.apply((StartExportTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationDiscoveryRequest.BuilderImpl
    implements Builder {
        private List<String> exportDataFormat = DefaultSdkAutoConstructList.getInstance();
        private List<ExportFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private Instant startTime;
        private Instant endTime;
        private ExportPreferences preferences;

        private BuilderImpl() {
        }

        private BuilderImpl(StartExportTaskRequest model) {
            super(model);
            this.exportDataFormatWithStrings(model.exportDataFormat);
            this.filters(model.filters);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.preferences(model.preferences);
        }

        public final Collection<String> getExportDataFormat() {
            if (this.exportDataFormat instanceof SdkAutoConstructList) {
                return null;
            }
            return this.exportDataFormat;
        }

        public final void setExportDataFormat(Collection<String> exportDataFormat) {
            this.exportDataFormat = ExportDataFormatsCopier.copy(exportDataFormat);
        }

        @Override
        public final Builder exportDataFormatWithStrings(Collection<String> exportDataFormat) {
            this.exportDataFormat = ExportDataFormatsCopier.copy(exportDataFormat);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportDataFormatWithStrings(String ... exportDataFormat) {
            this.exportDataFormatWithStrings(Arrays.asList(exportDataFormat));
            return this;
        }

        @Override
        public final Builder exportDataFormat(Collection<ExportDataFormat> exportDataFormat) {
            this.exportDataFormat = ExportDataFormatsCopier.copyEnumToString(exportDataFormat);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportDataFormat(ExportDataFormat ... exportDataFormat) {
            this.exportDataFormat(Arrays.asList(exportDataFormat));
            return this;
        }

        public final List<ExportFilter.Builder> getFilters() {
            List<ExportFilter.Builder> result = ExportFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<ExportFilter.BuilderImpl> filters) {
            this.filters = ExportFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<ExportFilter> filters) {
            this.filters = ExportFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(ExportFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<ExportFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (ExportFilter)((ExportFilter.Builder)ExportFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final ExportPreferences.Builder getPreferences() {
            return this.preferences != null ? this.preferences.toBuilder() : null;
        }

        public final void setPreferences(ExportPreferences.BuilderImpl preferences) {
            this.preferences = preferences != null ? preferences.build() : null;
        }

        @Override
        public final Builder preferences(ExportPreferences preferences) {
            this.preferences = preferences;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartExportTaskRequest build() {
            return new StartExportTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApplicationDiscoveryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartExportTaskRequest> {
        public Builder exportDataFormatWithStrings(Collection<String> var1);

        public Builder exportDataFormatWithStrings(String ... var1);

        public Builder exportDataFormat(Collection<ExportDataFormat> var1);

        public Builder exportDataFormat(ExportDataFormat ... var1);

        public Builder filters(Collection<ExportFilter> var1);

        public Builder filters(ExportFilter ... var1);

        public Builder filters(Consumer<ExportFilter.Builder> ... var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder preferences(ExportPreferences var1);

        default public Builder preferences(Consumer<ExportPreferences.Builder> preferences) {
            return this.preferences((ExportPreferences)((ExportPreferences.Builder)ExportPreferences.builder().applyMutation(preferences)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

