/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AgentNetworkInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AgentNetworkInfo> {
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ipAddress").getter(AgentNetworkInfo.getter(AgentNetworkInfo::ipAddress)).setter(AgentNetworkInfo.setter(Builder::ipAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddress").build()}).build();
    private static final SdkField<String> MAC_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("macAddress").getter(AgentNetworkInfo.getter(AgentNetworkInfo::macAddress)).setter(AgentNetworkInfo.setter(Builder::macAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("macAddress").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_ADDRESS_FIELD, MAC_ADDRESS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ipAddress;
    private final String macAddress;

    private AgentNetworkInfo(BuilderImpl builder) {
        this.ipAddress = builder.ipAddress;
        this.macAddress = builder.macAddress;
    }

    public final String ipAddress() {
        return this.ipAddress;
    }

    public final String macAddress() {
        return this.macAddress;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.macAddress());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentNetworkInfo)) {
            return false;
        }
        AgentNetworkInfo other = (AgentNetworkInfo)obj;
        return Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.macAddress(), other.macAddress());
    }

    public final String toString() {
        return ToString.builder((String)"AgentNetworkInfo").add("IpAddress", (Object)this.ipAddress()).add("MacAddress", (Object)this.macAddress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ipAddress": {
                return Optional.ofNullable(clazz.cast(this.ipAddress()));
            }
            case "macAddress": {
                return Optional.ofNullable(clazz.cast(this.macAddress()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AgentNetworkInfo, T> g) {
        return obj -> g.apply((AgentNetworkInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ipAddress;
        private String macAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentNetworkInfo model) {
            this.ipAddress(model.ipAddress);
            this.macAddress(model.macAddress);
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final String getMacAddress() {
            return this.macAddress;
        }

        public final void setMacAddress(String macAddress) {
            this.macAddress = macAddress;
        }

        @Override
        public final Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public AgentNetworkInfo build() {
            return new AgentNetworkInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AgentNetworkInfo> {
        public Builder ipAddress(String var1);

        public Builder macAddress(String var1);
    }
}

