/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.applicationdiscovery.model.ApplicationDiscoveryResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.CustomerAgentInfo;
import software.amazon.awssdk.services.applicationdiscovery.model.CustomerConnectorInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDiscoverySummaryResponse
extends ApplicationDiscoveryResponse
implements ToCopyableBuilder<Builder, GetDiscoverySummaryResponse> {
    private static final SdkField<Long> SERVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("servers").getter(GetDiscoverySummaryResponse.getter(GetDiscoverySummaryResponse::servers)).setter(GetDiscoverySummaryResponse.setter(Builder::servers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("servers").build()}).build();
    private static final SdkField<Long> APPLICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("applications").getter(GetDiscoverySummaryResponse.getter(GetDiscoverySummaryResponse::applications)).setter(GetDiscoverySummaryResponse.setter(Builder::applications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applications").build()}).build();
    private static final SdkField<Long> SERVERS_MAPPED_TO_APPLICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("serversMappedToApplications").getter(GetDiscoverySummaryResponse.getter(GetDiscoverySummaryResponse::serversMappedToApplications)).setter(GetDiscoverySummaryResponse.setter(Builder::serversMappedToApplications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serversMappedToApplications").build()}).build();
    private static final SdkField<Long> SERVERS_MAPPEDTO_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("serversMappedtoTags").getter(GetDiscoverySummaryResponse.getter(GetDiscoverySummaryResponse::serversMappedtoTags)).setter(GetDiscoverySummaryResponse.setter(Builder::serversMappedtoTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serversMappedtoTags").build()}).build();
    private static final SdkField<CustomerAgentInfo> AGENT_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("agentSummary").getter(GetDiscoverySummaryResponse.getter(GetDiscoverySummaryResponse::agentSummary)).setter(GetDiscoverySummaryResponse.setter(Builder::agentSummary)).constructor(CustomerAgentInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentSummary").build()}).build();
    private static final SdkField<CustomerConnectorInfo> CONNECTOR_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("connectorSummary").getter(GetDiscoverySummaryResponse.getter(GetDiscoverySummaryResponse::connectorSummary)).setter(GetDiscoverySummaryResponse.setter(Builder::connectorSummary)).constructor(CustomerConnectorInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorSummary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVERS_FIELD, APPLICATIONS_FIELD, SERVERS_MAPPED_TO_APPLICATIONS_FIELD, SERVERS_MAPPEDTO_TAGS_FIELD, AGENT_SUMMARY_FIELD, CONNECTOR_SUMMARY_FIELD));
    private final Long servers;
    private final Long applications;
    private final Long serversMappedToApplications;
    private final Long serversMappedtoTags;
    private final CustomerAgentInfo agentSummary;
    private final CustomerConnectorInfo connectorSummary;

    private GetDiscoverySummaryResponse(BuilderImpl builder) {
        super(builder);
        this.servers = builder.servers;
        this.applications = builder.applications;
        this.serversMappedToApplications = builder.serversMappedToApplications;
        this.serversMappedtoTags = builder.serversMappedtoTags;
        this.agentSummary = builder.agentSummary;
        this.connectorSummary = builder.connectorSummary;
    }

    public final Long servers() {
        return this.servers;
    }

    public final Long applications() {
        return this.applications;
    }

    public final Long serversMappedToApplications() {
        return this.serversMappedToApplications;
    }

    public final Long serversMappedtoTags() {
        return this.serversMappedtoTags;
    }

    public final CustomerAgentInfo agentSummary() {
        return this.agentSummary;
    }

    public final CustomerConnectorInfo connectorSummary() {
        return this.connectorSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.servers());
        hashCode = 31 * hashCode + Objects.hashCode(this.applications());
        hashCode = 31 * hashCode + Objects.hashCode(this.serversMappedToApplications());
        hashCode = 31 * hashCode + Objects.hashCode(this.serversMappedtoTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorSummary());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDiscoverySummaryResponse)) {
            return false;
        }
        GetDiscoverySummaryResponse other = (GetDiscoverySummaryResponse)((Object)obj);
        return Objects.equals(this.servers(), other.servers()) && Objects.equals(this.applications(), other.applications()) && Objects.equals(this.serversMappedToApplications(), other.serversMappedToApplications()) && Objects.equals(this.serversMappedtoTags(), other.serversMappedtoTags()) && Objects.equals(this.agentSummary(), other.agentSummary()) && Objects.equals(this.connectorSummary(), other.connectorSummary());
    }

    public final String toString() {
        return ToString.builder((String)"GetDiscoverySummaryResponse").add("Servers", (Object)this.servers()).add("Applications", (Object)this.applications()).add("ServersMappedToApplications", (Object)this.serversMappedToApplications()).add("ServersMappedtoTags", (Object)this.serversMappedtoTags()).add("AgentSummary", (Object)this.agentSummary()).add("ConnectorSummary", (Object)this.connectorSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "servers": {
                return Optional.ofNullable(clazz.cast(this.servers()));
            }
            case "applications": {
                return Optional.ofNullable(clazz.cast(this.applications()));
            }
            case "serversMappedToApplications": {
                return Optional.ofNullable(clazz.cast(this.serversMappedToApplications()));
            }
            case "serversMappedtoTags": {
                return Optional.ofNullable(clazz.cast(this.serversMappedtoTags()));
            }
            case "agentSummary": {
                return Optional.ofNullable(clazz.cast(this.agentSummary()));
            }
            case "connectorSummary": {
                return Optional.ofNullable(clazz.cast(this.connectorSummary()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDiscoverySummaryResponse, T> g) {
        return obj -> g.apply((GetDiscoverySummaryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationDiscoveryResponse.BuilderImpl
    implements Builder {
        private Long servers;
        private Long applications;
        private Long serversMappedToApplications;
        private Long serversMappedtoTags;
        private CustomerAgentInfo agentSummary;
        private CustomerConnectorInfo connectorSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDiscoverySummaryResponse model) {
            super(model);
            this.servers(model.servers);
            this.applications(model.applications);
            this.serversMappedToApplications(model.serversMappedToApplications);
            this.serversMappedtoTags(model.serversMappedtoTags);
            this.agentSummary(model.agentSummary);
            this.connectorSummary(model.connectorSummary);
        }

        public final Long getServers() {
            return this.servers;
        }

        public final void setServers(Long servers) {
            this.servers = servers;
        }

        @Override
        public final Builder servers(Long servers) {
            this.servers = servers;
            return this;
        }

        public final Long getApplications() {
            return this.applications;
        }

        public final void setApplications(Long applications) {
            this.applications = applications;
        }

        @Override
        public final Builder applications(Long applications) {
            this.applications = applications;
            return this;
        }

        public final Long getServersMappedToApplications() {
            return this.serversMappedToApplications;
        }

        public final void setServersMappedToApplications(Long serversMappedToApplications) {
            this.serversMappedToApplications = serversMappedToApplications;
        }

        @Override
        public final Builder serversMappedToApplications(Long serversMappedToApplications) {
            this.serversMappedToApplications = serversMappedToApplications;
            return this;
        }

        public final Long getServersMappedtoTags() {
            return this.serversMappedtoTags;
        }

        public final void setServersMappedtoTags(Long serversMappedtoTags) {
            this.serversMappedtoTags = serversMappedtoTags;
        }

        @Override
        public final Builder serversMappedtoTags(Long serversMappedtoTags) {
            this.serversMappedtoTags = serversMappedtoTags;
            return this;
        }

        public final CustomerAgentInfo.Builder getAgentSummary() {
            return this.agentSummary != null ? this.agentSummary.toBuilder() : null;
        }

        public final void setAgentSummary(CustomerAgentInfo.BuilderImpl agentSummary) {
            this.agentSummary = agentSummary != null ? agentSummary.build() : null;
        }

        @Override
        public final Builder agentSummary(CustomerAgentInfo agentSummary) {
            this.agentSummary = agentSummary;
            return this;
        }

        public final CustomerConnectorInfo.Builder getConnectorSummary() {
            return this.connectorSummary != null ? this.connectorSummary.toBuilder() : null;
        }

        public final void setConnectorSummary(CustomerConnectorInfo.BuilderImpl connectorSummary) {
            this.connectorSummary = connectorSummary != null ? connectorSummary.build() : null;
        }

        @Override
        public final Builder connectorSummary(CustomerConnectorInfo connectorSummary) {
            this.connectorSummary = connectorSummary;
            return this;
        }

        @Override
        public GetDiscoverySummaryResponse build() {
            return new GetDiscoverySummaryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApplicationDiscoveryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDiscoverySummaryResponse> {
        public Builder servers(Long var1);

        public Builder applications(Long var1);

        public Builder serversMappedToApplications(Long var1);

        public Builder serversMappedtoTags(Long var1);

        public Builder agentSummary(CustomerAgentInfo var1);

        default public Builder agentSummary(Consumer<CustomerAgentInfo.Builder> agentSummary) {
            return this.agentSummary((CustomerAgentInfo)((CustomerAgentInfo.Builder)CustomerAgentInfo.builder().applyMutation(agentSummary)).build());
        }

        public Builder connectorSummary(CustomerConnectorInfo var1);

        default public Builder connectorSummary(Consumer<CustomerConnectorInfo.Builder> connectorSummary) {
            return this.connectorSummary((CustomerConnectorInfo)((CustomerConnectorInfo.Builder)CustomerConnectorInfo.builder().applyMutation(connectorSummary)).build());
        }
    }
}

