/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.applicationdiscovery.model.ExportStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExportInfo> {
    private static final SdkField<String> EXPORT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("exportId").getter(ExportInfo.getter(ExportInfo::exportId)).setter(ExportInfo.setter(Builder::exportId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportId").build()}).build();
    private static final SdkField<String> EXPORT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("exportStatus").getter(ExportInfo.getter(ExportInfo::exportStatusAsString)).setter(ExportInfo.setter(Builder::exportStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportStatus").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(ExportInfo.getter(ExportInfo::statusMessage)).setter(ExportInfo.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final SdkField<String> CONFIGURATIONS_DOWNLOAD_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configurationsDownloadUrl").getter(ExportInfo.getter(ExportInfo::configurationsDownloadUrl)).setter(ExportInfo.setter(Builder::configurationsDownloadUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationsDownloadUrl").build()}).build();
    private static final SdkField<Instant> EXPORT_REQUEST_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("exportRequestTime").getter(ExportInfo.getter(ExportInfo::exportRequestTime)).setter(ExportInfo.setter(Builder::exportRequestTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportRequestTime").build()}).build();
    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isTruncated").getter(ExportInfo.getter(ExportInfo::isTruncated)).setter(ExportInfo.setter(Builder::isTruncated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isTruncated").build()}).build();
    private static final SdkField<Instant> REQUESTED_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("requestedStartTime").getter(ExportInfo.getter(ExportInfo::requestedStartTime)).setter(ExportInfo.setter(Builder::requestedStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestedStartTime").build()}).build();
    private static final SdkField<Instant> REQUESTED_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("requestedEndTime").getter(ExportInfo.getter(ExportInfo::requestedEndTime)).setter(ExportInfo.setter(Builder::requestedEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestedEndTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_ID_FIELD, EXPORT_STATUS_FIELD, STATUS_MESSAGE_FIELD, CONFIGURATIONS_DOWNLOAD_URL_FIELD, EXPORT_REQUEST_TIME_FIELD, IS_TRUNCATED_FIELD, REQUESTED_START_TIME_FIELD, REQUESTED_END_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String exportId;
    private final String exportStatus;
    private final String statusMessage;
    private final String configurationsDownloadUrl;
    private final Instant exportRequestTime;
    private final Boolean isTruncated;
    private final Instant requestedStartTime;
    private final Instant requestedEndTime;

    private ExportInfo(BuilderImpl builder) {
        this.exportId = builder.exportId;
        this.exportStatus = builder.exportStatus;
        this.statusMessage = builder.statusMessage;
        this.configurationsDownloadUrl = builder.configurationsDownloadUrl;
        this.exportRequestTime = builder.exportRequestTime;
        this.isTruncated = builder.isTruncated;
        this.requestedStartTime = builder.requestedStartTime;
        this.requestedEndTime = builder.requestedEndTime;
    }

    public final String exportId() {
        return this.exportId;
    }

    public final ExportStatus exportStatus() {
        return ExportStatus.fromValue(this.exportStatus);
    }

    public final String exportStatusAsString() {
        return this.exportStatus;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final String configurationsDownloadUrl() {
        return this.configurationsDownloadUrl;
    }

    public final Instant exportRequestTime() {
        return this.exportRequestTime;
    }

    public final Boolean isTruncated() {
        return this.isTruncated;
    }

    public final Instant requestedStartTime() {
        return this.requestedStartTime;
    }

    public final Instant requestedEndTime() {
        return this.requestedEndTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.exportId());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationsDownloadUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportRequestTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestedStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestedEndTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportInfo)) {
            return false;
        }
        ExportInfo other = (ExportInfo)obj;
        return Objects.equals(this.exportId(), other.exportId()) && Objects.equals(this.exportStatusAsString(), other.exportStatusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.configurationsDownloadUrl(), other.configurationsDownloadUrl()) && Objects.equals(this.exportRequestTime(), other.exportRequestTime()) && Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.requestedStartTime(), other.requestedStartTime()) && Objects.equals(this.requestedEndTime(), other.requestedEndTime());
    }

    public final String toString() {
        return ToString.builder((String)"ExportInfo").add("ExportId", (Object)this.exportId()).add("ExportStatus", (Object)this.exportStatusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("ConfigurationsDownloadUrl", (Object)this.configurationsDownloadUrl()).add("ExportRequestTime", (Object)this.exportRequestTime()).add("IsTruncated", (Object)this.isTruncated()).add("RequestedStartTime", (Object)this.requestedStartTime()).add("RequestedEndTime", (Object)this.requestedEndTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "exportId": {
                return Optional.ofNullable(clazz.cast(this.exportId()));
            }
            case "exportStatus": {
                return Optional.ofNullable(clazz.cast(this.exportStatusAsString()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "configurationsDownloadUrl": {
                return Optional.ofNullable(clazz.cast(this.configurationsDownloadUrl()));
            }
            case "exportRequestTime": {
                return Optional.ofNullable(clazz.cast(this.exportRequestTime()));
            }
            case "isTruncated": {
                return Optional.ofNullable(clazz.cast(this.isTruncated()));
            }
            case "requestedStartTime": {
                return Optional.ofNullable(clazz.cast(this.requestedStartTime()));
            }
            case "requestedEndTime": {
                return Optional.ofNullable(clazz.cast(this.requestedEndTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportInfo, T> g) {
        return obj -> g.apply((ExportInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String exportId;
        private String exportStatus;
        private String statusMessage;
        private String configurationsDownloadUrl;
        private Instant exportRequestTime;
        private Boolean isTruncated;
        private Instant requestedStartTime;
        private Instant requestedEndTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportInfo model) {
            this.exportId(model.exportId);
            this.exportStatus(model.exportStatus);
            this.statusMessage(model.statusMessage);
            this.configurationsDownloadUrl(model.configurationsDownloadUrl);
            this.exportRequestTime(model.exportRequestTime);
            this.isTruncated(model.isTruncated);
            this.requestedStartTime(model.requestedStartTime);
            this.requestedEndTime(model.requestedEndTime);
        }

        public final String getExportId() {
            return this.exportId;
        }

        public final void setExportId(String exportId) {
            this.exportId = exportId;
        }

        @Override
        @Transient
        public final Builder exportId(String exportId) {
            this.exportId = exportId;
            return this;
        }

        public final String getExportStatus() {
            return this.exportStatus;
        }

        public final void setExportStatus(String exportStatus) {
            this.exportStatus = exportStatus;
        }

        @Override
        @Transient
        public final Builder exportStatus(String exportStatus) {
            this.exportStatus = exportStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder exportStatus(ExportStatus exportStatus) {
            this.exportStatus(exportStatus == null ? null : exportStatus.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        @Transient
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getConfigurationsDownloadUrl() {
            return this.configurationsDownloadUrl;
        }

        public final void setConfigurationsDownloadUrl(String configurationsDownloadUrl) {
            this.configurationsDownloadUrl = configurationsDownloadUrl;
        }

        @Override
        @Transient
        public final Builder configurationsDownloadUrl(String configurationsDownloadUrl) {
            this.configurationsDownloadUrl = configurationsDownloadUrl;
            return this;
        }

        public final Instant getExportRequestTime() {
            return this.exportRequestTime;
        }

        public final void setExportRequestTime(Instant exportRequestTime) {
            this.exportRequestTime = exportRequestTime;
        }

        @Override
        @Transient
        public final Builder exportRequestTime(Instant exportRequestTime) {
            this.exportRequestTime = exportRequestTime;
            return this;
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        @Override
        @Transient
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final Instant getRequestedStartTime() {
            return this.requestedStartTime;
        }

        public final void setRequestedStartTime(Instant requestedStartTime) {
            this.requestedStartTime = requestedStartTime;
        }

        @Override
        @Transient
        public final Builder requestedStartTime(Instant requestedStartTime) {
            this.requestedStartTime = requestedStartTime;
            return this;
        }

        public final Instant getRequestedEndTime() {
            return this.requestedEndTime;
        }

        public final void setRequestedEndTime(Instant requestedEndTime) {
            this.requestedEndTime = requestedEndTime;
        }

        @Override
        @Transient
        public final Builder requestedEndTime(Instant requestedEndTime) {
            this.requestedEndTime = requestedEndTime;
            return this;
        }

        public ExportInfo build() {
            return new ExportInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExportInfo> {
        public Builder exportId(String var1);

        public Builder exportStatus(String var1);

        public Builder exportStatus(ExportStatus var1);

        public Builder statusMessage(String var1);

        public Builder configurationsDownloadUrl(String var1);

        public Builder exportRequestTime(Instant var1);

        public Builder isTruncated(Boolean var1);

        public Builder requestedStartTime(Instant var1);

        public Builder requestedEndTime(Instant var1);
    }
}

