/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationdiscovery.model.ApplicationDiscoveryRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.ToDeleteIdentifierListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteImportDataRequest
extends ApplicationDiscoveryRequest
implements ToCopyableBuilder<Builder, BatchDeleteImportDataRequest> {
    private static final SdkField<List<String>> IMPORT_TASK_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BatchDeleteImportDataRequest.getter(BatchDeleteImportDataRequest::importTaskIds)).setter(BatchDeleteImportDataRequest.setter(Builder::importTaskIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importTaskIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_TASK_IDS_FIELD));
    private final List<String> importTaskIds;

    private BatchDeleteImportDataRequest(BuilderImpl builder) {
        super(builder);
        this.importTaskIds = builder.importTaskIds;
    }

    public boolean hasImportTaskIds() {
        return this.importTaskIds != null && !(this.importTaskIds instanceof SdkAutoConstructList);
    }

    public List<String> importTaskIds() {
        return this.importTaskIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.importTaskIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteImportDataRequest)) {
            return false;
        }
        BatchDeleteImportDataRequest other = (BatchDeleteImportDataRequest)((Object)obj);
        return Objects.equals(this.importTaskIds(), other.importTaskIds());
    }

    public String toString() {
        return ToString.builder((String)"BatchDeleteImportDataRequest").add("ImportTaskIds", this.importTaskIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "importTaskIds": {
                return Optional.ofNullable(clazz.cast(this.importTaskIds()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteImportDataRequest, T> g) {
        return obj -> g.apply((BatchDeleteImportDataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationDiscoveryRequest.BuilderImpl
    implements Builder {
        private List<String> importTaskIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteImportDataRequest model) {
            super(model);
            this.importTaskIds(model.importTaskIds);
        }

        public final Collection<String> getImportTaskIds() {
            return this.importTaskIds;
        }

        @Override
        public final Builder importTaskIds(Collection<String> importTaskIds) {
            this.importTaskIds = ToDeleteIdentifierListCopier.copy(importTaskIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importTaskIds(String ... importTaskIds) {
            this.importTaskIds(Arrays.asList(importTaskIds));
            return this;
        }

        public final void setImportTaskIds(Collection<String> importTaskIds) {
            this.importTaskIds = ToDeleteIdentifierListCopier.copy(importTaskIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDeleteImportDataRequest build() {
            return new BatchDeleteImportDataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApplicationDiscoveryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDeleteImportDataRequest> {
        public Builder importTaskIds(Collection<String> var1);

        public Builder importTaskIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

