/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.applicationdiscovery.model.ContinuousExportStatus;
import software.amazon.awssdk.services.applicationdiscovery.model.DataSource;
import software.amazon.awssdk.services.applicationdiscovery.model.SchemaStorageConfigCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContinuousExportDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContinuousExportDescription> {
    private static final SdkField<String> EXPORT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContinuousExportDescription.getter(ContinuousExportDescription::exportId)).setter(ContinuousExportDescription.setter(Builder::exportId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContinuousExportDescription.getter(ContinuousExportDescription::statusAsString)).setter(ContinuousExportDescription.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContinuousExportDescription.getter(ContinuousExportDescription::statusDetail)).setter(ContinuousExportDescription.setter(Builder::statusDetail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusDetail").build()}).build();
    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContinuousExportDescription.getter(ContinuousExportDescription::s3Bucket)).setter(ContinuousExportDescription.setter(Builder::s3Bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Bucket").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ContinuousExportDescription.getter(ContinuousExportDescription::startTime)).setter(ContinuousExportDescription.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Instant> STOP_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ContinuousExportDescription.getter(ContinuousExportDescription::stopTime)).setter(ContinuousExportDescription.setter(Builder::stopTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopTime").build()}).build();
    private static final SdkField<String> DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContinuousExportDescription.getter(ContinuousExportDescription::dataSourceAsString)).setter(ContinuousExportDescription.setter(Builder::dataSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSource").build()}).build();
    private static final SdkField<Map<String, String>> SCHEMA_STORAGE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(ContinuousExportDescription.getter(ContinuousExportDescription::schemaStorageConfig)).setter(ContinuousExportDescription.setter(Builder::schemaStorageConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaStorageConfig").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_ID_FIELD, STATUS_FIELD, STATUS_DETAIL_FIELD, S3_BUCKET_FIELD, START_TIME_FIELD, STOP_TIME_FIELD, DATA_SOURCE_FIELD, SCHEMA_STORAGE_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String exportId;
    private final String status;
    private final String statusDetail;
    private final String s3Bucket;
    private final Instant startTime;
    private final Instant stopTime;
    private final String dataSource;
    private final Map<String, String> schemaStorageConfig;

    private ContinuousExportDescription(BuilderImpl builder) {
        this.exportId = builder.exportId;
        this.status = builder.status;
        this.statusDetail = builder.statusDetail;
        this.s3Bucket = builder.s3Bucket;
        this.startTime = builder.startTime;
        this.stopTime = builder.stopTime;
        this.dataSource = builder.dataSource;
        this.schemaStorageConfig = builder.schemaStorageConfig;
    }

    public String exportId() {
        return this.exportId;
    }

    public ContinuousExportStatus status() {
        return ContinuousExportStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String statusDetail() {
        return this.statusDetail;
    }

    public String s3Bucket() {
        return this.s3Bucket;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant stopTime() {
        return this.stopTime;
    }

    public DataSource dataSource() {
        return DataSource.fromValue(this.dataSource);
    }

    public String dataSourceAsString() {
        return this.dataSource;
    }

    public boolean hasSchemaStorageConfig() {
        return this.schemaStorageConfig != null && !(this.schemaStorageConfig instanceof SdkAutoConstructMap);
    }

    public Map<String, String> schemaStorageConfig() {
        return this.schemaStorageConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.exportId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.stopTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaStorageConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContinuousExportDescription)) {
            return false;
        }
        ContinuousExportDescription other = (ContinuousExportDescription)obj;
        return Objects.equals(this.exportId(), other.exportId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusDetail(), other.statusDetail()) && Objects.equals(this.s3Bucket(), other.s3Bucket()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.stopTime(), other.stopTime()) && Objects.equals(this.dataSourceAsString(), other.dataSourceAsString()) && Objects.equals(this.schemaStorageConfig(), other.schemaStorageConfig());
    }

    public String toString() {
        return ToString.builder((String)"ContinuousExportDescription").add("ExportId", (Object)this.exportId()).add("Status", (Object)this.statusAsString()).add("StatusDetail", (Object)this.statusDetail()).add("S3Bucket", (Object)this.s3Bucket()).add("StartTime", (Object)this.startTime()).add("StopTime", (Object)this.stopTime()).add("DataSource", (Object)this.dataSourceAsString()).add("SchemaStorageConfig", this.schemaStorageConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "exportId": {
                return Optional.ofNullable(clazz.cast(this.exportId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusDetail": {
                return Optional.ofNullable(clazz.cast(this.statusDetail()));
            }
            case "s3Bucket": {
                return Optional.ofNullable(clazz.cast(this.s3Bucket()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "stopTime": {
                return Optional.ofNullable(clazz.cast(this.stopTime()));
            }
            case "dataSource": {
                return Optional.ofNullable(clazz.cast(this.dataSourceAsString()));
            }
            case "schemaStorageConfig": {
                return Optional.ofNullable(clazz.cast(this.schemaStorageConfig()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContinuousExportDescription, T> g) {
        return obj -> g.apply((ContinuousExportDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String exportId;
        private String status;
        private String statusDetail;
        private String s3Bucket;
        private Instant startTime;
        private Instant stopTime;
        private String dataSource;
        private Map<String, String> schemaStorageConfig = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ContinuousExportDescription model) {
            this.exportId(model.exportId);
            this.status(model.status);
            this.statusDetail(model.statusDetail);
            this.s3Bucket(model.s3Bucket);
            this.startTime(model.startTime);
            this.stopTime(model.stopTime);
            this.dataSource(model.dataSource);
            this.schemaStorageConfig(model.schemaStorageConfig);
        }

        public final String getExportId() {
            return this.exportId;
        }

        @Override
        public final Builder exportId(String exportId) {
            this.exportId = exportId;
            return this;
        }

        public final void setExportId(String exportId) {
            this.exportId = exportId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ContinuousExportStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusDetail() {
            return this.statusDetail;
        }

        @Override
        public final Builder statusDetail(String statusDetail) {
            this.statusDetail = statusDetail;
            return this;
        }

        public final void setStatusDetail(String statusDetail) {
            this.statusDetail = statusDetail;
        }

        public final String getS3Bucket() {
            return this.s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getStopTime() {
            return this.stopTime;
        }

        @Override
        public final Builder stopTime(Instant stopTime) {
            this.stopTime = stopTime;
            return this;
        }

        public final void setStopTime(Instant stopTime) {
            this.stopTime = stopTime;
        }

        public final String getDataSource() {
            return this.dataSource;
        }

        @Override
        public final Builder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        @Override
        public final Builder dataSource(DataSource dataSource) {
            this.dataSource(dataSource == null ? null : dataSource.toString());
            return this;
        }

        public final void setDataSource(String dataSource) {
            this.dataSource = dataSource;
        }

        public final Map<String, String> getSchemaStorageConfig() {
            return this.schemaStorageConfig;
        }

        @Override
        public final Builder schemaStorageConfig(Map<String, String> schemaStorageConfig) {
            this.schemaStorageConfig = SchemaStorageConfigCopier.copy(schemaStorageConfig);
            return this;
        }

        public final void setSchemaStorageConfig(Map<String, String> schemaStorageConfig) {
            this.schemaStorageConfig = SchemaStorageConfigCopier.copy(schemaStorageConfig);
        }

        public ContinuousExportDescription build() {
            return new ContinuousExportDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContinuousExportDescription> {
        public Builder exportId(String var1);

        public Builder status(String var1);

        public Builder status(ContinuousExportStatus var1);

        public Builder statusDetail(String var1);

        public Builder s3Bucket(String var1);

        public Builder startTime(Instant var1);

        public Builder stopTime(Instant var1);

        public Builder dataSource(String var1);

        public Builder dataSource(DataSource var1);

        public Builder schemaStorageConfig(Map<String, String> var1);
    }
}

