/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.applicationdiscovery.model.Filter;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class FilterMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<List> VALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("values").isBinary(false).build();
    private static final MarshallingInfo<String> CONDITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("condition").isBinary(false).build();
    private static final FilterMarshaller INSTANCE = new FilterMarshaller();

    private FilterMarshaller() {
    }

    public static FilterMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Filter filter, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)filter, (String)"filter");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)filter.name(), NAME_BINDING);
            protocolMarshaller.marshall(filter.values(), VALUES_BINDING);
            protocolMarshaller.marshall((Object)filter.condition(), CONDITION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

