/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.applicationdiscovery.model.ExportInfo;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ExportInfoMarshaller {
    private static final MarshallingInfo<String> EXPORTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("exportId").isBinary(false).build();
    private static final MarshallingInfo<String> EXPORTSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("exportStatus").isBinary(false).build();
    private static final MarshallingInfo<String> STATUSMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("statusMessage").isBinary(false).build();
    private static final MarshallingInfo<String> CONFIGURATIONSDOWNLOADURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("configurationsDownloadUrl").isBinary(false).build();
    private static final MarshallingInfo<Instant> EXPORTREQUESTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("exportRequestTime").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ISTRUNCATED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("isTruncated").isBinary(false).build();
    private static final MarshallingInfo<Instant> REQUESTEDSTARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("requestedStartTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> REQUESTEDENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("requestedEndTime").isBinary(false).build();
    private static final ExportInfoMarshaller INSTANCE = new ExportInfoMarshaller();

    private ExportInfoMarshaller() {
    }

    public static ExportInfoMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ExportInfo exportInfo, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)exportInfo, (String)"exportInfo");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)exportInfo.exportId(), EXPORTID_BINDING);
            protocolMarshaller.marshall((Object)exportInfo.exportStatusAsString(), EXPORTSTATUS_BINDING);
            protocolMarshaller.marshall((Object)exportInfo.statusMessage(), STATUSMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)exportInfo.configurationsDownloadUrl(), CONFIGURATIONSDOWNLOADURL_BINDING);
            protocolMarshaller.marshall((Object)exportInfo.exportRequestTime(), EXPORTREQUESTTIME_BINDING);
            protocolMarshaller.marshall((Object)exportInfo.isTruncated(), ISTRUNCATED_BINDING);
            protocolMarshaller.marshall((Object)exportInfo.requestedStartTime(), REQUESTEDSTARTTIME_BINDING);
            protocolMarshaller.marshall((Object)exportInfo.requestedEndTime(), REQUESTEDENDTIME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

