/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.applicationdiscovery.model.ApplicationDiscoveryRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.ExportDataFormat;
import software.amazon.awssdk.services.applicationdiscovery.model.ExportDataFormatsCopier;
import software.amazon.awssdk.services.applicationdiscovery.model.ExportFilter;
import software.amazon.awssdk.services.applicationdiscovery.model.ExportFiltersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartExportTaskRequest
extends ApplicationDiscoveryRequest
implements ToCopyableBuilder<Builder, StartExportTaskRequest> {
    private final List<String> exportDataFormat;
    private final List<ExportFilter> filters;
    private final Instant startTime;
    private final Instant endTime;

    private StartExportTaskRequest(BuilderImpl builder) {
        super(builder);
        this.exportDataFormat = builder.exportDataFormat;
        this.filters = builder.filters;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    public List<ExportDataFormat> exportDataFormat() {
        return TypeConverter.convert(this.exportDataFormat, ExportDataFormat::fromValue);
    }

    public List<String> exportDataFormatAsStrings() {
        return this.exportDataFormat;
    }

    public List<ExportFilter> filters() {
        return this.filters;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.exportDataFormatAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartExportTaskRequest)) {
            return false;
        }
        StartExportTaskRequest other = (StartExportTaskRequest)((Object)obj);
        return Objects.equals(this.exportDataFormatAsStrings(), other.exportDataFormatAsStrings()) && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime());
    }

    public String toString() {
        return ToString.builder((String)"StartExportTaskRequest").add("ExportDataFormat", this.exportDataFormatAsStrings()).add("Filters", this.filters()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "exportDataFormat": {
                return Optional.ofNullable(clazz.cast(this.exportDataFormatAsStrings()));
            }
            case "filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ApplicationDiscoveryRequest.BuilderImpl
    implements Builder {
        private List<String> exportDataFormat = DefaultSdkAutoConstructList.getInstance();
        private List<ExportFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private Instant startTime;
        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(StartExportTaskRequest model) {
            super(model);
            this.exportDataFormatWithStrings(model.exportDataFormat);
            this.filters(model.filters);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
        }

        public final Collection<String> getExportDataFormat() {
            return this.exportDataFormat;
        }

        @Override
        public final Builder exportDataFormatWithStrings(Collection<String> exportDataFormat) {
            this.exportDataFormat = ExportDataFormatsCopier.copy(exportDataFormat);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportDataFormatWithStrings(String ... exportDataFormat) {
            this.exportDataFormatWithStrings(Arrays.asList(exportDataFormat));
            return this;
        }

        @Override
        public final Builder exportDataFormat(Collection<ExportDataFormat> exportDataFormat) {
            this.exportDataFormat = ExportDataFormatsCopier.copyEnumToString(exportDataFormat);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportDataFormat(ExportDataFormat ... exportDataFormat) {
            this.exportDataFormat(Arrays.asList(exportDataFormat));
            return this;
        }

        public final void setExportDataFormat(Collection<String> exportDataFormat) {
            this.exportDataFormat = ExportDataFormatsCopier.copy(exportDataFormat);
        }

        public final Collection<ExportFilter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(ExportFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<ExportFilter> filters) {
            this.filters = ExportFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(ExportFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<ExportFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (ExportFilter)((ExportFilter.Builder)ExportFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<ExportFilter.BuilderImpl> filters) {
            this.filters = ExportFiltersCopier.copyFromBuilder(filters);
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartExportTaskRequest build() {
            return new StartExportTaskRequest(this);
        }
    }

    public static interface Builder
    extends ApplicationDiscoveryRequest.Builder,
    CopyableBuilder<Builder, StartExportTaskRequest> {
        public Builder exportDataFormatWithStrings(Collection<String> var1);

        public Builder exportDataFormatWithStrings(String ... var1);

        public Builder exportDataFormat(Collection<ExportDataFormat> var1);

        public Builder exportDataFormat(ExportDataFormat ... var1);

        public Builder filters(Collection<ExportFilter> var1);

        public Builder filters(ExportFilter ... var1);

        public Builder filters(Consumer<ExportFilter.Builder> ... var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

