/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.applicationdiscovery.model.OrderString;
import software.amazon.awssdk.services.applicationdiscovery.transform.OrderByElementMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OrderByElement
implements StructuredPojo,
ToCopyableBuilder<Builder, OrderByElement> {
    private final String fieldName;
    private final String sortOrder;

    private OrderByElement(BuilderImpl builder) {
        this.fieldName = builder.fieldName;
        this.sortOrder = builder.sortOrder;
    }

    public String fieldName() {
        return this.fieldName;
    }

    public OrderString sortOrder() {
        return OrderString.fromValue(this.sortOrder);
    }

    public String sortOrderAsString() {
        return this.sortOrder;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrderByElement)) {
            return false;
        }
        OrderByElement other = (OrderByElement)obj;
        return Objects.equals(this.fieldName(), other.fieldName()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString());
    }

    public String toString() {
        return ToString.builder((String)"OrderByElement").add("FieldName", (Object)this.fieldName()).add("SortOrder", (Object)this.sortOrderAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fieldName": {
                return Optional.ofNullable(clazz.cast(this.fieldName()));
            }
            case "sortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OrderByElementMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String fieldName;
        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(OrderByElement model) {
            this.fieldName(model.fieldName);
            this.sortOrder(model.sortOrder);
        }

        public final String getFieldName() {
            return this.fieldName;
        }

        @Override
        public final Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public final void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(OrderString sortOrder) {
            this.sortOrder(sortOrder.toString());
            return this;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        public OrderByElement build() {
            return new OrderByElement(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, OrderByElement> {
        public Builder fieldName(String var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(OrderString var1);
    }
}

