/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.applicationdiscovery.transform.CustomerAgentInfoMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomerAgentInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, CustomerAgentInfo> {
    private final Integer activeAgents;
    private final Integer healthyAgents;
    private final Integer blackListedAgents;
    private final Integer shutdownAgents;
    private final Integer unhealthyAgents;
    private final Integer totalAgents;
    private final Integer unknownAgents;

    private CustomerAgentInfo(BuilderImpl builder) {
        this.activeAgents = builder.activeAgents;
        this.healthyAgents = builder.healthyAgents;
        this.blackListedAgents = builder.blackListedAgents;
        this.shutdownAgents = builder.shutdownAgents;
        this.unhealthyAgents = builder.unhealthyAgents;
        this.totalAgents = builder.totalAgents;
        this.unknownAgents = builder.unknownAgents;
    }

    public Integer activeAgents() {
        return this.activeAgents;
    }

    public Integer healthyAgents() {
        return this.healthyAgents;
    }

    public Integer blackListedAgents() {
        return this.blackListedAgents;
    }

    public Integer shutdownAgents() {
        return this.shutdownAgents;
    }

    public Integer unhealthyAgents() {
        return this.unhealthyAgents;
    }

    public Integer totalAgents() {
        return this.totalAgents;
    }

    public Integer unknownAgents() {
        return this.unknownAgents;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activeAgents());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthyAgents());
        hashCode = 31 * hashCode + Objects.hashCode(this.blackListedAgents());
        hashCode = 31 * hashCode + Objects.hashCode(this.shutdownAgents());
        hashCode = 31 * hashCode + Objects.hashCode(this.unhealthyAgents());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalAgents());
        hashCode = 31 * hashCode + Objects.hashCode(this.unknownAgents());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomerAgentInfo)) {
            return false;
        }
        CustomerAgentInfo other = (CustomerAgentInfo)obj;
        return Objects.equals(this.activeAgents(), other.activeAgents()) && Objects.equals(this.healthyAgents(), other.healthyAgents()) && Objects.equals(this.blackListedAgents(), other.blackListedAgents()) && Objects.equals(this.shutdownAgents(), other.shutdownAgents()) && Objects.equals(this.unhealthyAgents(), other.unhealthyAgents()) && Objects.equals(this.totalAgents(), other.totalAgents()) && Objects.equals(this.unknownAgents(), other.unknownAgents());
    }

    public String toString() {
        return ToString.builder((String)"CustomerAgentInfo").add("ActiveAgents", (Object)this.activeAgents()).add("HealthyAgents", (Object)this.healthyAgents()).add("BlackListedAgents", (Object)this.blackListedAgents()).add("ShutdownAgents", (Object)this.shutdownAgents()).add("UnhealthyAgents", (Object)this.unhealthyAgents()).add("TotalAgents", (Object)this.totalAgents()).add("UnknownAgents", (Object)this.unknownAgents()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "activeAgents": {
                return Optional.ofNullable(clazz.cast(this.activeAgents()));
            }
            case "healthyAgents": {
                return Optional.ofNullable(clazz.cast(this.healthyAgents()));
            }
            case "blackListedAgents": {
                return Optional.ofNullable(clazz.cast(this.blackListedAgents()));
            }
            case "shutdownAgents": {
                return Optional.ofNullable(clazz.cast(this.shutdownAgents()));
            }
            case "unhealthyAgents": {
                return Optional.ofNullable(clazz.cast(this.unhealthyAgents()));
            }
            case "totalAgents": {
                return Optional.ofNullable(clazz.cast(this.totalAgents()));
            }
            case "unknownAgents": {
                return Optional.ofNullable(clazz.cast(this.unknownAgents()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CustomerAgentInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer activeAgents;
        private Integer healthyAgents;
        private Integer blackListedAgents;
        private Integer shutdownAgents;
        private Integer unhealthyAgents;
        private Integer totalAgents;
        private Integer unknownAgents;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomerAgentInfo model) {
            this.activeAgents(model.activeAgents);
            this.healthyAgents(model.healthyAgents);
            this.blackListedAgents(model.blackListedAgents);
            this.shutdownAgents(model.shutdownAgents);
            this.unhealthyAgents(model.unhealthyAgents);
            this.totalAgents(model.totalAgents);
            this.unknownAgents(model.unknownAgents);
        }

        public final Integer getActiveAgents() {
            return this.activeAgents;
        }

        @Override
        public final Builder activeAgents(Integer activeAgents) {
            this.activeAgents = activeAgents;
            return this;
        }

        public final void setActiveAgents(Integer activeAgents) {
            this.activeAgents = activeAgents;
        }

        public final Integer getHealthyAgents() {
            return this.healthyAgents;
        }

        @Override
        public final Builder healthyAgents(Integer healthyAgents) {
            this.healthyAgents = healthyAgents;
            return this;
        }

        public final void setHealthyAgents(Integer healthyAgents) {
            this.healthyAgents = healthyAgents;
        }

        public final Integer getBlackListedAgents() {
            return this.blackListedAgents;
        }

        @Override
        public final Builder blackListedAgents(Integer blackListedAgents) {
            this.blackListedAgents = blackListedAgents;
            return this;
        }

        public final void setBlackListedAgents(Integer blackListedAgents) {
            this.blackListedAgents = blackListedAgents;
        }

        public final Integer getShutdownAgents() {
            return this.shutdownAgents;
        }

        @Override
        public final Builder shutdownAgents(Integer shutdownAgents) {
            this.shutdownAgents = shutdownAgents;
            return this;
        }

        public final void setShutdownAgents(Integer shutdownAgents) {
            this.shutdownAgents = shutdownAgents;
        }

        public final Integer getUnhealthyAgents() {
            return this.unhealthyAgents;
        }

        @Override
        public final Builder unhealthyAgents(Integer unhealthyAgents) {
            this.unhealthyAgents = unhealthyAgents;
            return this;
        }

        public final void setUnhealthyAgents(Integer unhealthyAgents) {
            this.unhealthyAgents = unhealthyAgents;
        }

        public final Integer getTotalAgents() {
            return this.totalAgents;
        }

        @Override
        public final Builder totalAgents(Integer totalAgents) {
            this.totalAgents = totalAgents;
            return this;
        }

        public final void setTotalAgents(Integer totalAgents) {
            this.totalAgents = totalAgents;
        }

        public final Integer getUnknownAgents() {
            return this.unknownAgents;
        }

        @Override
        public final Builder unknownAgents(Integer unknownAgents) {
            this.unknownAgents = unknownAgents;
            return this;
        }

        public final void setUnknownAgents(Integer unknownAgents) {
            this.unknownAgents = unknownAgents;
        }

        public CustomerAgentInfo build() {
            return new CustomerAgentInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CustomerAgentInfo> {
        public Builder activeAgents(Integer var1);

        public Builder healthyAgents(Integer var1);

        public Builder blackListedAgents(Integer var1);

        public Builder shutdownAgents(Integer var1);

        public Builder unhealthyAgents(Integer var1);

        public Builder totalAgents(Integer var1);

        public Builder unknownAgents(Integer var1);
    }
}

