/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.applicationdiscovery.model.ConfigurationItemType;
import software.amazon.awssdk.services.applicationdiscovery.transform.ConfigurationTagMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigurationTag
implements StructuredPojo,
ToCopyableBuilder<Builder, ConfigurationTag> {
    private final String configurationType;
    private final String configurationId;
    private final String key;
    private final String value;
    private final Instant timeOfCreation;

    private ConfigurationTag(BuilderImpl builder) {
        this.configurationType = builder.configurationType;
        this.configurationId = builder.configurationId;
        this.key = builder.key;
        this.value = builder.value;
        this.timeOfCreation = builder.timeOfCreation;
    }

    public ConfigurationItemType configurationType() {
        return ConfigurationItemType.fromValue(this.configurationType);
    }

    public String configurationTypeAsString() {
        return this.configurationType;
    }

    public String configurationId() {
        return this.configurationId;
    }

    public String key() {
        return this.key;
    }

    public String value() {
        return this.value;
    }

    public Instant timeOfCreation() {
        return this.timeOfCreation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeOfCreation());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationTag)) {
            return false;
        }
        ConfigurationTag other = (ConfigurationTag)obj;
        return Objects.equals(this.configurationTypeAsString(), other.configurationTypeAsString()) && Objects.equals(this.configurationId(), other.configurationId()) && Objects.equals(this.key(), other.key()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.timeOfCreation(), other.timeOfCreation());
    }

    public String toString() {
        return ToString.builder((String)"ConfigurationTag").add("ConfigurationType", (Object)this.configurationTypeAsString()).add("ConfigurationId", (Object)this.configurationId()).add("Key", (Object)this.key()).add("Value", (Object)this.value()).add("TimeOfCreation", (Object)this.timeOfCreation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configurationType": {
                return Optional.ofNullable(clazz.cast(this.configurationTypeAsString()));
            }
            case "configurationId": {
                return Optional.ofNullable(clazz.cast(this.configurationId()));
            }
            case "key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "timeOfCreation": {
                return Optional.ofNullable(clazz.cast(this.timeOfCreation()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConfigurationTagMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String configurationType;
        private String configurationId;
        private String key;
        private String value;
        private Instant timeOfCreation;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationTag model) {
            this.configurationType(model.configurationType);
            this.configurationId(model.configurationId);
            this.key(model.key);
            this.value(model.value);
            this.timeOfCreation(model.timeOfCreation);
        }

        public final String getConfigurationType() {
            return this.configurationType;
        }

        @Override
        public final Builder configurationType(String configurationType) {
            this.configurationType = configurationType;
            return this;
        }

        @Override
        public final Builder configurationType(ConfigurationItemType configurationType) {
            this.configurationType(configurationType.toString());
            return this;
        }

        public final void setConfigurationType(String configurationType) {
            this.configurationType = configurationType;
        }

        public final String getConfigurationId() {
            return this.configurationId;
        }

        @Override
        public final Builder configurationId(String configurationId) {
            this.configurationId = configurationId;
            return this;
        }

        public final void setConfigurationId(String configurationId) {
            this.configurationId = configurationId;
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final Instant getTimeOfCreation() {
            return this.timeOfCreation;
        }

        @Override
        public final Builder timeOfCreation(Instant timeOfCreation) {
            this.timeOfCreation = timeOfCreation;
            return this;
        }

        public final void setTimeOfCreation(Instant timeOfCreation) {
            this.timeOfCreation = timeOfCreation;
        }

        public ConfigurationTag build() {
            return new ConfigurationTag(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ConfigurationTag> {
        public Builder configurationType(String var1);

        public Builder configurationType(ConfigurationItemType var1);

        public Builder configurationId(String var1);

        public Builder key(String var1);

        public Builder value(String var1);

        public Builder timeOfCreation(Instant var1);
    }
}

