/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationcostprofiler.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutReportDefinitionRequest extends ApplicationCostProfilerRequest implements
        ToCopyableBuilder<PutReportDefinitionRequest.Builder, PutReportDefinitionRequest> {
    private static final SdkField<String> REPORT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("reportId").getter(getter(PutReportDefinitionRequest::reportId)).setter(setter(Builder::reportId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportId").build()).build();

    private static final SdkField<String> REPORT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("reportDescription").getter(getter(PutReportDefinitionRequest::reportDescription))
            .setter(setter(Builder::reportDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportDescription").build()).build();

    private static final SdkField<String> REPORT_FREQUENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("reportFrequency").getter(getter(PutReportDefinitionRequest::reportFrequencyAsString))
            .setter(setter(Builder::reportFrequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportFrequency").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("format")
            .getter(getter(PutReportDefinitionRequest::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()).build();

    private static final SdkField<S3Location> DESTINATION_S3_LOCATION_FIELD = SdkField
            .<S3Location> builder(MarshallingType.SDK_POJO).memberName("destinationS3Location")
            .getter(getter(PutReportDefinitionRequest::destinationS3Location)).setter(setter(Builder::destinationS3Location))
            .constructor(S3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationS3Location").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_ID_FIELD,
            REPORT_DESCRIPTION_FIELD, REPORT_FREQUENCY_FIELD, FORMAT_FIELD, DESTINATION_S3_LOCATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String reportId;

    private final String reportDescription;

    private final String reportFrequency;

    private final String format;

    private final S3Location destinationS3Location;

    private PutReportDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.reportId = builder.reportId;
        this.reportDescription = builder.reportDescription;
        this.reportFrequency = builder.reportFrequency;
        this.format = builder.format;
        this.destinationS3Location = builder.destinationS3Location;
    }

    /**
     * <p>
     * Required. ID of the report. You can choose any valid string matching the pattern for the ID.
     * </p>
     * 
     * @return Required. ID of the report. You can choose any valid string matching the pattern for the ID.
     */
    public final String reportId() {
        return reportId;
    }

    /**
     * <p>
     * Required. Description of the report.
     * </p>
     * 
     * @return Required. Description of the report.
     */
    public final String reportDescription() {
        return reportDescription;
    }

    /**
     * <p>
     * Required. The cadence to generate the report.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reportFrequency}
     * will return {@link ReportFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #reportFrequencyAsString}.
     * </p>
     * 
     * @return Required. The cadence to generate the report.
     * @see ReportFrequency
     */
    public final ReportFrequency reportFrequency() {
        return ReportFrequency.fromValue(reportFrequency);
    }

    /**
     * <p>
     * Required. The cadence to generate the report.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reportFrequency}
     * will return {@link ReportFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #reportFrequencyAsString}.
     * </p>
     * 
     * @return Required. The cadence to generate the report.
     * @see ReportFrequency
     */
    public final String reportFrequencyAsString() {
        return reportFrequency;
    }

    /**
     * <p>
     * Required. The format to use for the generated report.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link Format#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return Required. The format to use for the generated report.
     * @see Format
     */
    public final Format format() {
        return Format.fromValue(format);
    }

    /**
     * <p>
     * Required. The format to use for the generated report.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link Format#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return Required. The format to use for the generated report.
     * @see Format
     */
    public final String formatAsString() {
        return format;
    }

    /**
     * <p>
     * Required. Amazon Simple Storage Service (Amazon S3) location where Application Cost Profiler uploads the report.
     * </p>
     * 
     * @return Required. Amazon Simple Storage Service (Amazon S3) location where Application Cost Profiler uploads the
     *         report.
     */
    public final S3Location destinationS3Location() {
        return destinationS3Location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reportId());
        hashCode = 31 * hashCode + Objects.hashCode(reportDescription());
        hashCode = 31 * hashCode + Objects.hashCode(reportFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destinationS3Location());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutReportDefinitionRequest)) {
            return false;
        }
        PutReportDefinitionRequest other = (PutReportDefinitionRequest) obj;
        return Objects.equals(reportId(), other.reportId()) && Objects.equals(reportDescription(), other.reportDescription())
                && Objects.equals(reportFrequencyAsString(), other.reportFrequencyAsString())
                && Objects.equals(formatAsString(), other.formatAsString())
                && Objects.equals(destinationS3Location(), other.destinationS3Location());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutReportDefinitionRequest").add("ReportId", reportId())
                .add("ReportDescription", reportDescription()).add("ReportFrequency", reportFrequencyAsString())
                .add("Format", formatAsString()).add("DestinationS3Location", destinationS3Location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "reportId":
            return Optional.ofNullable(clazz.cast(reportId()));
        case "reportDescription":
            return Optional.ofNullable(clazz.cast(reportDescription()));
        case "reportFrequency":
            return Optional.ofNullable(clazz.cast(reportFrequencyAsString()));
        case "format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "destinationS3Location":
            return Optional.ofNullable(clazz.cast(destinationS3Location()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("reportId", REPORT_ID_FIELD);
        map.put("reportDescription", REPORT_DESCRIPTION_FIELD);
        map.put("reportFrequency", REPORT_FREQUENCY_FIELD);
        map.put("format", FORMAT_FIELD);
        map.put("destinationS3Location", DESTINATION_S3_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutReportDefinitionRequest, T> g) {
        return obj -> g.apply((PutReportDefinitionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ApplicationCostProfilerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutReportDefinitionRequest> {
        /**
         * <p>
         * Required. ID of the report. You can choose any valid string matching the pattern for the ID.
         * </p>
         * 
         * @param reportId
         *        Required. ID of the report. You can choose any valid string matching the pattern for the ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportId(String reportId);

        /**
         * <p>
         * Required. Description of the report.
         * </p>
         * 
         * @param reportDescription
         *        Required. Description of the report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportDescription(String reportDescription);

        /**
         * <p>
         * Required. The cadence to generate the report.
         * </p>
         * 
         * @param reportFrequency
         *        Required. The cadence to generate the report.
         * @see ReportFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportFrequency
         */
        Builder reportFrequency(String reportFrequency);

        /**
         * <p>
         * Required. The cadence to generate the report.
         * </p>
         * 
         * @param reportFrequency
         *        Required. The cadence to generate the report.
         * @see ReportFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportFrequency
         */
        Builder reportFrequency(ReportFrequency reportFrequency);

        /**
         * <p>
         * Required. The format to use for the generated report.
         * </p>
         * 
         * @param format
         *        Required. The format to use for the generated report.
         * @see Format
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Format
         */
        Builder format(String format);

        /**
         * <p>
         * Required. The format to use for the generated report.
         * </p>
         * 
         * @param format
         *        Required. The format to use for the generated report.
         * @see Format
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Format
         */
        Builder format(Format format);

        /**
         * <p>
         * Required. Amazon Simple Storage Service (Amazon S3) location where Application Cost Profiler uploads the
         * report.
         * </p>
         * 
         * @param destinationS3Location
         *        Required. Amazon Simple Storage Service (Amazon S3) location where Application Cost Profiler uploads
         *        the report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationS3Location(S3Location destinationS3Location);

        /**
         * <p>
         * Required. Amazon Simple Storage Service (Amazon S3) location where Application Cost Profiler uploads the
         * report.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Location.Builder} avoiding the need to
         * create one manually via {@link S3Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Location.Builder#build()} is called immediately and its result
         * is passed to {@link #destinationS3Location(S3Location)}.
         * 
         * @param destinationS3Location
         *        a consumer that will call methods on {@link S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationS3Location(S3Location)
         */
        default Builder destinationS3Location(Consumer<S3Location.Builder> destinationS3Location) {
            return destinationS3Location(S3Location.builder().applyMutation(destinationS3Location).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApplicationCostProfilerRequest.BuilderImpl implements Builder {
        private String reportId;

        private String reportDescription;

        private String reportFrequency;

        private String format;

        private S3Location destinationS3Location;

        private BuilderImpl() {
        }

        private BuilderImpl(PutReportDefinitionRequest model) {
            super(model);
            reportId(model.reportId);
            reportDescription(model.reportDescription);
            reportFrequency(model.reportFrequency);
            format(model.format);
            destinationS3Location(model.destinationS3Location);
        }

        public final String getReportId() {
            return reportId;
        }

        public final void setReportId(String reportId) {
            this.reportId = reportId;
        }

        @Override
        public final Builder reportId(String reportId) {
            this.reportId = reportId;
            return this;
        }

        public final String getReportDescription() {
            return reportDescription;
        }

        public final void setReportDescription(String reportDescription) {
            this.reportDescription = reportDescription;
        }

        @Override
        public final Builder reportDescription(String reportDescription) {
            this.reportDescription = reportDescription;
            return this;
        }

        public final String getReportFrequency() {
            return reportFrequency;
        }

        public final void setReportFrequency(String reportFrequency) {
            this.reportFrequency = reportFrequency;
        }

        @Override
        public final Builder reportFrequency(String reportFrequency) {
            this.reportFrequency = reportFrequency;
            return this;
        }

        @Override
        public final Builder reportFrequency(ReportFrequency reportFrequency) {
            this.reportFrequency(reportFrequency == null ? null : reportFrequency.toString());
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(Format format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final S3Location.Builder getDestinationS3Location() {
            return destinationS3Location != null ? destinationS3Location.toBuilder() : null;
        }

        public final void setDestinationS3Location(S3Location.BuilderImpl destinationS3Location) {
            this.destinationS3Location = destinationS3Location != null ? destinationS3Location.build() : null;
        }

        @Override
        public final Builder destinationS3Location(S3Location destinationS3Location) {
            this.destinationS3Location = destinationS3Location;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutReportDefinitionRequest build() {
            return new PutReportDefinitionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
