/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationcostprofiler.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ReportFrequency {
    MONTHLY("MONTHLY"),
    DAILY("DAILY"),
    ALL("ALL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ReportFrequency> VALUE_MAP;
    private final String value;

    private ReportFrequency(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ReportFrequency fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ReportFrequency> knownValues() {
        EnumSet<ReportFrequency> knownValues = EnumSet.allOf(ReportFrequency.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ReportFrequency.class, ReportFrequency::toString);
    }
}

