/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationcostprofiler;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.applicationcostprofiler.ApplicationCostProfilerClient;
import software.amazon.awssdk.services.applicationcostprofiler.ApplicationCostProfilerClientBuilder;
import software.amazon.awssdk.services.applicationcostprofiler.ApplicationCostProfilerServiceClientConfiguration;
import software.amazon.awssdk.services.applicationcostprofiler.DefaultApplicationCostProfilerBaseClientBuilder;
import software.amazon.awssdk.services.applicationcostprofiler.DefaultApplicationCostProfilerClient;
import software.amazon.awssdk.services.applicationcostprofiler.endpoints.ApplicationCostProfilerEndpointProvider;

@SdkInternalApi
final class DefaultApplicationCostProfilerClientBuilder
extends DefaultApplicationCostProfilerBaseClientBuilder<ApplicationCostProfilerClientBuilder, ApplicationCostProfilerClient>
implements ApplicationCostProfilerClientBuilder {
    DefaultApplicationCostProfilerClientBuilder() {
    }

    @Override
    public DefaultApplicationCostProfilerClientBuilder endpointProvider(ApplicationCostProfilerEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ApplicationCostProfilerClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultApplicationCostProfilerClientBuilder.validateClientOptions(clientConfiguration);
        ApplicationCostProfilerServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultApplicationCostProfilerClient client = new DefaultApplicationCostProfilerClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private ApplicationCostProfilerServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return ApplicationCostProfilerServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

