/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationcostprofiler.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.applicationcostprofiler.model.Format;
import software.amazon.awssdk.services.applicationcostprofiler.model.ReportFrequency;
import software.amazon.awssdk.services.applicationcostprofiler.model.S3Location;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReportDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReportDefinition> {
    private static final SdkField<String> REPORT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reportId").getter(ReportDefinition.getter(ReportDefinition::reportId)).setter(ReportDefinition.setter(Builder::reportId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportId").build()}).build();
    private static final SdkField<String> REPORT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reportDescription").getter(ReportDefinition.getter(ReportDefinition::reportDescription)).setter(ReportDefinition.setter(Builder::reportDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportDescription").build()}).build();
    private static final SdkField<String> REPORT_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reportFrequency").getter(ReportDefinition.getter(ReportDefinition::reportFrequencyAsString)).setter(ReportDefinition.setter(Builder::reportFrequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportFrequency").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("format").getter(ReportDefinition.getter(ReportDefinition::formatAsString)).setter(ReportDefinition.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()}).build();
    private static final SdkField<S3Location> DESTINATION_S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("destinationS3Location").getter(ReportDefinition.getter(ReportDefinition::destinationS3Location)).setter(ReportDefinition.setter(Builder::destinationS3Location)).constructor(S3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationS3Location").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(ReportDefinition.getter(ReportDefinition::createdAt)).setter(ReportDefinition.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(ReportDefinition.getter(ReportDefinition::lastUpdatedAt)).setter(ReportDefinition.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_ID_FIELD, REPORT_DESCRIPTION_FIELD, REPORT_FREQUENCY_FIELD, FORMAT_FIELD, DESTINATION_S3_LOCATION_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String reportId;
    private final String reportDescription;
    private final String reportFrequency;
    private final String format;
    private final S3Location destinationS3Location;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;

    private ReportDefinition(BuilderImpl builder) {
        this.reportId = builder.reportId;
        this.reportDescription = builder.reportDescription;
        this.reportFrequency = builder.reportFrequency;
        this.format = builder.format;
        this.destinationS3Location = builder.destinationS3Location;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
    }

    public final String reportId() {
        return this.reportId;
    }

    public final String reportDescription() {
        return this.reportDescription;
    }

    public final ReportFrequency reportFrequency() {
        return ReportFrequency.fromValue(this.reportFrequency);
    }

    public final String reportFrequencyAsString() {
        return this.reportFrequency;
    }

    public final Format format() {
        return Format.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final S3Location destinationS3Location() {
        return this.destinationS3Location;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reportId());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportDefinition)) {
            return false;
        }
        ReportDefinition other = (ReportDefinition)obj;
        return Objects.equals(this.reportId(), other.reportId()) && Objects.equals(this.reportDescription(), other.reportDescription()) && Objects.equals(this.reportFrequencyAsString(), other.reportFrequencyAsString()) && Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.destinationS3Location(), other.destinationS3Location()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"ReportDefinition").add("ReportId", (Object)this.reportId()).add("ReportDescription", (Object)this.reportDescription()).add("ReportFrequency", (Object)this.reportFrequencyAsString()).add("Format", (Object)this.formatAsString()).add("DestinationS3Location", (Object)this.destinationS3Location()).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "reportId": {
                return Optional.ofNullable(clazz.cast(this.reportId()));
            }
            case "reportDescription": {
                return Optional.ofNullable(clazz.cast(this.reportDescription()));
            }
            case "reportFrequency": {
                return Optional.ofNullable(clazz.cast(this.reportFrequencyAsString()));
            }
            case "format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "destinationS3Location": {
                return Optional.ofNullable(clazz.cast(this.destinationS3Location()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReportDefinition, T> g) {
        return obj -> g.apply((ReportDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String reportId;
        private String reportDescription;
        private String reportFrequency;
        private String format;
        private S3Location destinationS3Location;
        private Instant createdAt;
        private Instant lastUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportDefinition model) {
            this.reportId(model.reportId);
            this.reportDescription(model.reportDescription);
            this.reportFrequency(model.reportFrequency);
            this.format(model.format);
            this.destinationS3Location(model.destinationS3Location);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
        }

        public final String getReportId() {
            return this.reportId;
        }

        public final void setReportId(String reportId) {
            this.reportId = reportId;
        }

        @Override
        public final Builder reportId(String reportId) {
            this.reportId = reportId;
            return this;
        }

        public final String getReportDescription() {
            return this.reportDescription;
        }

        public final void setReportDescription(String reportDescription) {
            this.reportDescription = reportDescription;
        }

        @Override
        public final Builder reportDescription(String reportDescription) {
            this.reportDescription = reportDescription;
            return this;
        }

        public final String getReportFrequency() {
            return this.reportFrequency;
        }

        public final void setReportFrequency(String reportFrequency) {
            this.reportFrequency = reportFrequency;
        }

        @Override
        public final Builder reportFrequency(String reportFrequency) {
            this.reportFrequency = reportFrequency;
            return this;
        }

        @Override
        public final Builder reportFrequency(ReportFrequency reportFrequency) {
            this.reportFrequency(reportFrequency == null ? null : reportFrequency.toString());
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(Format format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final S3Location.Builder getDestinationS3Location() {
            return this.destinationS3Location != null ? this.destinationS3Location.toBuilder() : null;
        }

        public final void setDestinationS3Location(S3Location.BuilderImpl destinationS3Location) {
            this.destinationS3Location = destinationS3Location != null ? destinationS3Location.build() : null;
        }

        @Override
        public final Builder destinationS3Location(S3Location destinationS3Location) {
            this.destinationS3Location = destinationS3Location;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public ReportDefinition build() {
            return new ReportDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReportDefinition> {
        public Builder reportId(String var1);

        public Builder reportDescription(String var1);

        public Builder reportFrequency(String var1);

        public Builder reportFrequency(ReportFrequency var1);

        public Builder format(String var1);

        public Builder format(Format var1);

        public Builder destinationS3Location(S3Location var1);

        default public Builder destinationS3Location(Consumer<S3Location.Builder> destinationS3Location) {
            return this.destinationS3Location((S3Location)((S3Location.Builder)S3Location.builder().applyMutation(destinationS3Location)).build());
        }

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);
    }
}

