/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationcostprofiler.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Format {
    CSV("CSV"),
    PARQUET("PARQUET"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Format(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Format fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Format.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Format> knownValues() {
        return Stream.of(Format.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

