/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.applicationautoscaling.ApplicationAutoScalingAsyncClient;
import software.amazon.awssdk.services.applicationautoscaling.internal.UserAgentUtils;
import software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingPoliciesRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingPoliciesResponse;
import software.amazon.awssdk.services.applicationautoscaling.model.ScalingPolicy;

public class DescribeScalingPoliciesPublisher
implements SdkPublisher<DescribeScalingPoliciesResponse> {
    private final ApplicationAutoScalingAsyncClient client;
    private final DescribeScalingPoliciesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeScalingPoliciesPublisher(ApplicationAutoScalingAsyncClient client, DescribeScalingPoliciesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeScalingPoliciesPublisher(ApplicationAutoScalingAsyncClient client, DescribeScalingPoliciesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeScalingPoliciesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeScalingPoliciesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ScalingPolicy> scalingPolicies() {
        return this.flatMapIterable(response -> response.scalingPolicies());
    }

    private class DescribeScalingPoliciesResponseFetcher
    implements AsyncPageFetcher<DescribeScalingPoliciesResponse> {
        private DescribeScalingPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeScalingPoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeScalingPoliciesResponse> nextPage(DescribeScalingPoliciesResponse previousPage) {
            if (previousPage == null) {
                return DescribeScalingPoliciesPublisher.this.client.describeScalingPolicies(DescribeScalingPoliciesPublisher.this.firstRequest);
            }
            return DescribeScalingPoliciesPublisher.this.client.describeScalingPolicies((DescribeScalingPoliciesRequest)((Object)DescribeScalingPoliciesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

