/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.applicationautoscaling.ApplicationAutoScalingAsyncClient;
import software.amazon.awssdk.services.applicationautoscaling.ApplicationAutoScalingServiceClientConfiguration;
import software.amazon.awssdk.services.applicationautoscaling.internal.ApplicationAutoScalingServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.applicationautoscaling.model.ApplicationAutoScalingException;
import software.amazon.awssdk.services.applicationautoscaling.model.ConcurrentUpdateException;
import software.amazon.awssdk.services.applicationautoscaling.model.DeleteScalingPolicyRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.DeleteScalingPolicyResponse;
import software.amazon.awssdk.services.applicationautoscaling.model.DeleteScheduledActionRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.DeleteScheduledActionResponse;
import software.amazon.awssdk.services.applicationautoscaling.model.DeregisterScalableTargetRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.DeregisterScalableTargetResponse;
import software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalableTargetsRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalableTargetsResponse;
import software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingActivitiesRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingActivitiesResponse;
import software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingPoliciesRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingPoliciesResponse;
import software.amazon.awssdk.services.applicationautoscaling.model.DescribeScheduledActionsRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.DescribeScheduledActionsResponse;
import software.amazon.awssdk.services.applicationautoscaling.model.FailedResourceAccessException;
import software.amazon.awssdk.services.applicationautoscaling.model.GetPredictiveScalingForecastRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.GetPredictiveScalingForecastResponse;
import software.amazon.awssdk.services.applicationautoscaling.model.InternalServiceException;
import software.amazon.awssdk.services.applicationautoscaling.model.InvalidNextTokenException;
import software.amazon.awssdk.services.applicationautoscaling.model.LimitExceededException;
import software.amazon.awssdk.services.applicationautoscaling.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.applicationautoscaling.model.ObjectNotFoundException;
import software.amazon.awssdk.services.applicationautoscaling.model.PutScalingPolicyRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.PutScalingPolicyResponse;
import software.amazon.awssdk.services.applicationautoscaling.model.PutScheduledActionRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.PutScheduledActionResponse;
import software.amazon.awssdk.services.applicationautoscaling.model.RegisterScalableTargetRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.RegisterScalableTargetResponse;
import software.amazon.awssdk.services.applicationautoscaling.model.ResourceNotFoundException;
import software.amazon.awssdk.services.applicationautoscaling.model.TagResourceRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.TagResourceResponse;
import software.amazon.awssdk.services.applicationautoscaling.model.TooManyTagsException;
import software.amazon.awssdk.services.applicationautoscaling.model.UntagResourceRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.UntagResourceResponse;
import software.amazon.awssdk.services.applicationautoscaling.model.ValidationException;
import software.amazon.awssdk.services.applicationautoscaling.transform.DeleteScalingPolicyRequestMarshaller;
import software.amazon.awssdk.services.applicationautoscaling.transform.DeleteScheduledActionRequestMarshaller;
import software.amazon.awssdk.services.applicationautoscaling.transform.DeregisterScalableTargetRequestMarshaller;
import software.amazon.awssdk.services.applicationautoscaling.transform.DescribeScalableTargetsRequestMarshaller;
import software.amazon.awssdk.services.applicationautoscaling.transform.DescribeScalingActivitiesRequestMarshaller;
import software.amazon.awssdk.services.applicationautoscaling.transform.DescribeScalingPoliciesRequestMarshaller;
import software.amazon.awssdk.services.applicationautoscaling.transform.DescribeScheduledActionsRequestMarshaller;
import software.amazon.awssdk.services.applicationautoscaling.transform.GetPredictiveScalingForecastRequestMarshaller;
import software.amazon.awssdk.services.applicationautoscaling.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.applicationautoscaling.transform.PutScalingPolicyRequestMarshaller;
import software.amazon.awssdk.services.applicationautoscaling.transform.PutScheduledActionRequestMarshaller;
import software.amazon.awssdk.services.applicationautoscaling.transform.RegisterScalableTargetRequestMarshaller;
import software.amazon.awssdk.services.applicationautoscaling.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.applicationautoscaling.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultApplicationAutoScalingAsyncClient
implements ApplicationAutoScalingAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultApplicationAutoScalingAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultApplicationAutoScalingAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Application_Auto_Scaling#2.37.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<DeleteScalingPolicyResponse> deleteScalingPolicy(DeleteScalingPolicyRequest deleteScalingPolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteScalingPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultApplicationAutoScalingAsyncClient.resolveMetricPublishers(clientConfiguration, deleteScalingPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Application Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteScalingPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteScalingPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "FailedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedResourceAccessException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedResourceAccessException::builder).build());
                    }
                    case "ConcurrentUpdateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentUpdateException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "ObjectNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteScalingPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteScalingPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteScalingPolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultApplicationAutoScalingAsyncClient.lambda$deleteScalingPolicy$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultApplicationAutoScalingAsyncClient.lambda$deleteScalingPolicy$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteScheduledActionResponse> deleteScheduledAction(DeleteScheduledActionRequest deleteScheduledActionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteScheduledActionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultApplicationAutoScalingAsyncClient.resolveMetricPublishers(clientConfiguration, deleteScheduledActionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Application Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteScheduledAction");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteScheduledActionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "FailedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedResourceAccessException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedResourceAccessException::builder).build());
                    }
                    case "ConcurrentUpdateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentUpdateException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "ObjectNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteScheduledAction").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteScheduledActionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteScheduledActionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultApplicationAutoScalingAsyncClient.lambda$deleteScheduledAction$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultApplicationAutoScalingAsyncClient.lambda$deleteScheduledAction$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeregisterScalableTargetResponse> deregisterScalableTarget(DeregisterScalableTargetRequest deregisterScalableTargetRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deregisterScalableTargetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultApplicationAutoScalingAsyncClient.resolveMetricPublishers(clientConfiguration, deregisterScalableTargetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Application Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeregisterScalableTarget");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeregisterScalableTargetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "FailedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedResourceAccessException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedResourceAccessException::builder).build());
                    }
                    case "ConcurrentUpdateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentUpdateException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "ObjectNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterScalableTarget").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeregisterScalableTargetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deregisterScalableTargetRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultApplicationAutoScalingAsyncClient.lambda$deregisterScalableTarget$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultApplicationAutoScalingAsyncClient.lambda$deregisterScalableTarget$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeScalableTargetsResponse> describeScalableTargets(DescribeScalableTargetsRequest describeScalableTargetsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeScalableTargetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultApplicationAutoScalingAsyncClient.resolveMetricPublishers(clientConfiguration, describeScalableTargetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Application Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeScalableTargets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeScalableTargetsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "FailedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedResourceAccessException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedResourceAccessException::builder).build());
                    }
                    case "ConcurrentUpdateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentUpdateException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "ObjectNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeScalableTargets").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeScalableTargetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeScalableTargetsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultApplicationAutoScalingAsyncClient.lambda$describeScalableTargets$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultApplicationAutoScalingAsyncClient.lambda$describeScalableTargets$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeScalingActivitiesResponse> describeScalingActivities(DescribeScalingActivitiesRequest describeScalingActivitiesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeScalingActivitiesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultApplicationAutoScalingAsyncClient.resolveMetricPublishers(clientConfiguration, describeScalingActivitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Application Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeScalingActivities");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeScalingActivitiesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "FailedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedResourceAccessException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedResourceAccessException::builder).build());
                    }
                    case "ConcurrentUpdateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentUpdateException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "ObjectNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeScalingActivities").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeScalingActivitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeScalingActivitiesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultApplicationAutoScalingAsyncClient.lambda$describeScalingActivities$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultApplicationAutoScalingAsyncClient.lambda$describeScalingActivities$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeScalingPoliciesResponse> describeScalingPolicies(DescribeScalingPoliciesRequest describeScalingPoliciesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeScalingPoliciesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultApplicationAutoScalingAsyncClient.resolveMetricPublishers(clientConfiguration, describeScalingPoliciesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Application Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeScalingPolicies");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeScalingPoliciesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "FailedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedResourceAccessException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedResourceAccessException::builder).build());
                    }
                    case "ConcurrentUpdateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentUpdateException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "ObjectNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeScalingPolicies").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeScalingPoliciesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeScalingPoliciesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultApplicationAutoScalingAsyncClient.lambda$describeScalingPolicies$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultApplicationAutoScalingAsyncClient.lambda$describeScalingPolicies$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeScheduledActionsResponse> describeScheduledActions(DescribeScheduledActionsRequest describeScheduledActionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeScheduledActionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultApplicationAutoScalingAsyncClient.resolveMetricPublishers(clientConfiguration, describeScheduledActionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Application Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeScheduledActions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeScheduledActionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "FailedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedResourceAccessException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedResourceAccessException::builder).build());
                    }
                    case "ConcurrentUpdateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentUpdateException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "ObjectNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeScheduledActions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeScheduledActionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeScheduledActionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultApplicationAutoScalingAsyncClient.lambda$describeScheduledActions$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultApplicationAutoScalingAsyncClient.lambda$describeScheduledActions$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetPredictiveScalingForecastResponse> getPredictiveScalingForecast(GetPredictiveScalingForecastRequest getPredictiveScalingForecastRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getPredictiveScalingForecastRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultApplicationAutoScalingAsyncClient.resolveMetricPublishers(clientConfiguration, getPredictiveScalingForecastRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Application Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPredictiveScalingForecast");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPredictiveScalingForecastResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "FailedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedResourceAccessException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedResourceAccessException::builder).build());
                    }
                    case "ConcurrentUpdateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentUpdateException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "ObjectNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPredictiveScalingForecast").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetPredictiveScalingForecastRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getPredictiveScalingForecastRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultApplicationAutoScalingAsyncClient.lambda$getPredictiveScalingForecast$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultApplicationAutoScalingAsyncClient.lambda$getPredictiveScalingForecast$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultApplicationAutoScalingAsyncClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Application Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "FailedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedResourceAccessException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedResourceAccessException::builder).build());
                    }
                    case "ConcurrentUpdateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentUpdateException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "ObjectNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultApplicationAutoScalingAsyncClient.lambda$listTagsForResource$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultApplicationAutoScalingAsyncClient.lambda$listTagsForResource$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutScalingPolicyResponse> putScalingPolicy(PutScalingPolicyRequest putScalingPolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putScalingPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultApplicationAutoScalingAsyncClient.resolveMetricPublishers(clientConfiguration, putScalingPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Application Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutScalingPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutScalingPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "FailedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedResourceAccessException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedResourceAccessException::builder).build());
                    }
                    case "ConcurrentUpdateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentUpdateException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "ObjectNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutScalingPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutScalingPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putScalingPolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultApplicationAutoScalingAsyncClient.lambda$putScalingPolicy$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultApplicationAutoScalingAsyncClient.lambda$putScalingPolicy$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutScheduledActionResponse> putScheduledAction(PutScheduledActionRequest putScheduledActionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putScheduledActionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultApplicationAutoScalingAsyncClient.resolveMetricPublishers(clientConfiguration, putScheduledActionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Application Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutScheduledAction");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutScheduledActionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "FailedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedResourceAccessException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedResourceAccessException::builder).build());
                    }
                    case "ConcurrentUpdateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentUpdateException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "ObjectNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutScheduledAction").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutScheduledActionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putScheduledActionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultApplicationAutoScalingAsyncClient.lambda$putScheduledAction$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultApplicationAutoScalingAsyncClient.lambda$putScheduledAction$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RegisterScalableTargetResponse> registerScalableTarget(RegisterScalableTargetRequest registerScalableTargetRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)registerScalableTargetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultApplicationAutoScalingAsyncClient.resolveMetricPublishers(clientConfiguration, registerScalableTargetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Application Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterScalableTarget");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterScalableTargetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "FailedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedResourceAccessException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedResourceAccessException::builder).build());
                    }
                    case "ConcurrentUpdateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentUpdateException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "ObjectNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterScalableTarget").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RegisterScalableTargetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)registerScalableTargetRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultApplicationAutoScalingAsyncClient.lambda$registerScalableTarget$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultApplicationAutoScalingAsyncClient.lambda$registerScalableTarget$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultApplicationAutoScalingAsyncClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Application Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "FailedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedResourceAccessException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedResourceAccessException::builder).build());
                    }
                    case "ConcurrentUpdateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentUpdateException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "ObjectNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultApplicationAutoScalingAsyncClient.lambda$tagResource$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultApplicationAutoScalingAsyncClient.lambda$tagResource$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultApplicationAutoScalingAsyncClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Application Auto Scaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "FailedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedResourceAccessException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedResourceAccessException::builder).build());
                    }
                    case "ConcurrentUpdateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentUpdateException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "ObjectNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ObjectNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ObjectNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultApplicationAutoScalingAsyncClient.lambda$untagResource$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultApplicationAutoScalingAsyncClient.lambda$untagResource$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final ApplicationAutoScalingServiceClientConfiguration serviceClientConfiguration() {
        return new ApplicationAutoScalingServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "application-autoscaling";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(ApplicationAutoScalingException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        ApplicationAutoScalingServiceClientConfigurationBuilder serviceConfigBuilder = new ApplicationAutoScalingServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$untagResource$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$54(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$50(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$registerScalableTarget$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerScalableTarget$46(List metricPublishers, MetricCollector apiCallMetricCollector, RegisterScalableTargetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putScheduledAction$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putScheduledAction$42(List metricPublishers, MetricCollector apiCallMetricCollector, PutScheduledActionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putScalingPolicy$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putScalingPolicy$38(List metricPublishers, MetricCollector apiCallMetricCollector, PutScalingPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsForResource$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$34(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getPredictiveScalingForecast$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPredictiveScalingForecast$30(List metricPublishers, MetricCollector apiCallMetricCollector, GetPredictiveScalingForecastResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeScheduledActions$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeScheduledActions$26(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeScheduledActionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeScalingPolicies$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeScalingPolicies$22(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeScalingPoliciesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeScalingActivities$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeScalingActivities$18(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeScalingActivitiesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeScalableTargets$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeScalableTargets$14(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeScalableTargetsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deregisterScalableTarget$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deregisterScalableTarget$10(List metricPublishers, MetricCollector apiCallMetricCollector, DeregisterScalableTargetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteScheduledAction$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteScheduledAction$6(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteScheduledActionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteScalingPolicy$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteScalingPolicy$2(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteScalingPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

