/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationautoscaling.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum ScalableDimension {
    ECS_SERVICE_DESIRED_COUNT("ecs:service:DesiredCount"),

    EC2_SPOT_FLEET_REQUEST_TARGET_CAPACITY("ec2:spot-fleet-request:TargetCapacity"),

    ELASTICMAPREDUCE_INSTANCEGROUP_INSTANCE_COUNT("elasticmapreduce:instancegroup:InstanceCount"),

    APPSTREAM_FLEET_DESIRED_CAPACITY("appstream:fleet:DesiredCapacity"),

    DYNAMODB_TABLE_READ_CAPACITY_UNITS("dynamodb:table:ReadCapacityUnits"),

    DYNAMODB_TABLE_WRITE_CAPACITY_UNITS("dynamodb:table:WriteCapacityUnits"),

    DYNAMODB_INDEX_READ_CAPACITY_UNITS("dynamodb:index:ReadCapacityUnits"),

    DYNAMODB_INDEX_WRITE_CAPACITY_UNITS("dynamodb:index:WriteCapacityUnits"),

    RDS_CLUSTER_READ_REPLICA_COUNT("rds:cluster:ReadReplicaCount"),

    SAGEMAKER_VARIANT_DESIRED_INSTANCE_COUNT("sagemaker:variant:DesiredInstanceCount"),

    CUSTOM_RESOURCE_RESOURCE_TYPE_PROPERTY("custom-resource:ResourceType:Property"),

    COMPREHEND_DOCUMENT_CLASSIFIER_ENDPOINT_DESIRED_INFERENCE_UNITS(
            "comprehend:document-classifier-endpoint:DesiredInferenceUnits"),

    COMPREHEND_ENTITY_RECOGNIZER_ENDPOINT_DESIRED_INFERENCE_UNITS("comprehend:entity-recognizer-endpoint:DesiredInferenceUnits"),

    LAMBDA_FUNCTION_PROVISIONED_CONCURRENCY("lambda:function:ProvisionedConcurrency"),

    CASSANDRA_TABLE_READ_CAPACITY_UNITS("cassandra:table:ReadCapacityUnits"),

    CASSANDRA_TABLE_WRITE_CAPACITY_UNITS("cassandra:table:WriteCapacityUnits"),

    KAFKA_BROKER_STORAGE_VOLUME_SIZE("kafka:broker-storage:VolumeSize"),

    ELASTICACHE_REPLICATION_GROUP_NODE_GROUPS("elasticache:replication-group:NodeGroups"),

    ELASTICACHE_REPLICATION_GROUP_REPLICAS("elasticache:replication-group:Replicas"),

    NEPTUNE_CLUSTER_READ_REPLICA_COUNT("neptune:cluster:ReadReplicaCount"),

    SAGEMAKER_VARIANT_DESIRED_PROVISIONED_CONCURRENCY("sagemaker:variant:DesiredProvisionedConcurrency"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ScalableDimension> VALUE_MAP = EnumUtils.uniqueIndex(ScalableDimension.class,
            ScalableDimension::toString);

    private final String value;

    private ScalableDimension(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ScalableDimension corresponding to the value
     */
    public static ScalableDimension fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ScalableDimension}s
     */
    public static Set<ScalableDimension> knownValues() {
        Set<ScalableDimension> knownValues = EnumSet.allOf(ScalableDimension.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
