/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationautoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeScalingActivitiesResponse extends ApplicationAutoScalingResponse implements
        ToCopyableBuilder<DescribeScalingActivitiesResponse.Builder, DescribeScalingActivitiesResponse> {
    private static final SdkField<List<ScalingActivity>> SCALING_ACTIVITIES_FIELD = SdkField
            .<List<ScalingActivity>> builder(MarshallingType.LIST)
            .memberName("ScalingActivities")
            .getter(getter(DescribeScalingActivitiesResponse::scalingActivities))
            .setter(setter(Builder::scalingActivities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingActivities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ScalingActivity> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScalingActivity::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeScalingActivitiesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALING_ACTIVITIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ScalingActivity> scalingActivities;

    private final String nextToken;

    private DescribeScalingActivitiesResponse(BuilderImpl builder) {
        super(builder);
        this.scalingActivities = builder.scalingActivities;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ScalingActivities property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasScalingActivities() {
        return scalingActivities != null && !(scalingActivities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of scaling activity objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScalingActivities} method.
     * </p>
     * 
     * @return A list of scaling activity objects.
     */
    public final List<ScalingActivity> scalingActivities() {
        return scalingActivities;
    }

    /**
     * <p>
     * The token required to get the next set of results. This value is <code>null</code> if there are no more results
     * to return.
     * </p>
     * 
     * @return The token required to get the next set of results. This value is <code>null</code> if there are no more
     *         results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasScalingActivities() ? scalingActivities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScalingActivitiesResponse)) {
            return false;
        }
        DescribeScalingActivitiesResponse other = (DescribeScalingActivitiesResponse) obj;
        return hasScalingActivities() == other.hasScalingActivities()
                && Objects.equals(scalingActivities(), other.scalingActivities())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeScalingActivitiesResponse")
                .add("ScalingActivities", hasScalingActivities() ? scalingActivities() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScalingActivities":
            return Optional.ofNullable(clazz.cast(scalingActivities()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeScalingActivitiesResponse, T> g) {
        return obj -> g.apply((DescribeScalingActivitiesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationAutoScalingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeScalingActivitiesResponse> {
        /**
         * <p>
         * A list of scaling activity objects.
         * </p>
         * 
         * @param scalingActivities
         *        A list of scaling activity objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingActivities(Collection<ScalingActivity> scalingActivities);

        /**
         * <p>
         * A list of scaling activity objects.
         * </p>
         * 
         * @param scalingActivities
         *        A list of scaling activity objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingActivities(ScalingActivity... scalingActivities);

        /**
         * <p>
         * A list of scaling activity objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.applicationautoscaling.model.ScalingActivity.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.applicationautoscaling.model.ScalingActivity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.applicationautoscaling.model.ScalingActivity.Builder#build()} is
         * called immediately and its result is passed to {@link #scalingActivities(List<ScalingActivity>)}.
         * 
         * @param scalingActivities
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.applicationautoscaling.model.ScalingActivity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scalingActivities(java.util.Collection<ScalingActivity>)
         */
        Builder scalingActivities(Consumer<ScalingActivity.Builder>... scalingActivities);

        /**
         * <p>
         * The token required to get the next set of results. This value is <code>null</code> if there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token required to get the next set of results. This value is <code>null</code> if there are no
         *        more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ApplicationAutoScalingResponse.BuilderImpl implements Builder {
        private List<ScalingActivity> scalingActivities = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScalingActivitiesResponse model) {
            super(model);
            scalingActivities(model.scalingActivities);
            nextToken(model.nextToken);
        }

        public final List<ScalingActivity.Builder> getScalingActivities() {
            List<ScalingActivity.Builder> result = ScalingActivitiesCopier.copyToBuilder(this.scalingActivities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScalingActivities(Collection<ScalingActivity.BuilderImpl> scalingActivities) {
            this.scalingActivities = ScalingActivitiesCopier.copyFromBuilder(scalingActivities);
        }

        @Override
        public final Builder scalingActivities(Collection<ScalingActivity> scalingActivities) {
            this.scalingActivities = ScalingActivitiesCopier.copy(scalingActivities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingActivities(ScalingActivity... scalingActivities) {
            scalingActivities(Arrays.asList(scalingActivities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingActivities(Consumer<ScalingActivity.Builder>... scalingActivities) {
            scalingActivities(Stream.of(scalingActivities).map(c -> ScalingActivity.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeScalingActivitiesResponse build() {
            return new DescribeScalingActivitiesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
