/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appintegrations.model.IframePermissionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IframeConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IframeConfig> {
    private static final SdkField<List<String>> ALLOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Allow").getter(IframeConfig.getter(IframeConfig::allow)).setter(IframeConfig.setter(Builder::allow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Allow").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SANDBOX_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Sandbox").getter(IframeConfig.getter(IframeConfig::sandbox)).setter(IframeConfig.setter(Builder::sandbox)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sandbox").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOW_FIELD, SANDBOX_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IframeConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> allow;
    private final List<String> sandbox;

    private IframeConfig(BuilderImpl builder) {
        this.allow = builder.allow;
        this.sandbox = builder.sandbox;
    }

    public final boolean hasAllow() {
        return this.allow != null && !(this.allow instanceof SdkAutoConstructList);
    }

    public final List<String> allow() {
        return this.allow;
    }

    public final boolean hasSandbox() {
        return this.sandbox != null && !(this.sandbox instanceof SdkAutoConstructList);
    }

    public final List<String> sandbox() {
        return this.sandbox;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllow() ? this.allow() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSandbox() ? this.sandbox() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IframeConfig)) {
            return false;
        }
        IframeConfig other = (IframeConfig)obj;
        return this.hasAllow() == other.hasAllow() && Objects.equals(this.allow(), other.allow()) && this.hasSandbox() == other.hasSandbox() && Objects.equals(this.sandbox(), other.sandbox());
    }

    public final String toString() {
        return ToString.builder((String)"IframeConfig").add("Allow", this.hasAllow() ? this.allow() : null).add("Sandbox", this.hasSandbox() ? this.sandbox() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Allow": {
                return Optional.ofNullable(clazz.cast(this.allow()));
            }
            case "Sandbox": {
                return Optional.ofNullable(clazz.cast(this.sandbox()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("Allow", ALLOW_FIELD);
        map.put("Sandbox", SANDBOX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IframeConfig, T> g) {
        return obj -> g.apply((IframeConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> allow = DefaultSdkAutoConstructList.getInstance();
        private List<String> sandbox = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IframeConfig model) {
            this.allow(model.allow);
            this.sandbox(model.sandbox);
        }

        public final Collection<String> getAllow() {
            if (this.allow instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allow;
        }

        public final void setAllow(Collection<String> allow) {
            this.allow = IframePermissionListCopier.copy(allow);
        }

        @Override
        public final Builder allow(Collection<String> allow) {
            this.allow = IframePermissionListCopier.copy(allow);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allow(String ... allow) {
            this.allow(Arrays.asList(allow));
            return this;
        }

        public final Collection<String> getSandbox() {
            if (this.sandbox instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sandbox;
        }

        public final void setSandbox(Collection<String> sandbox) {
            this.sandbox = IframePermissionListCopier.copy(sandbox);
        }

        @Override
        public final Builder sandbox(Collection<String> sandbox) {
            this.sandbox = IframePermissionListCopier.copy(sandbox);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sandbox(String ... sandbox) {
            this.sandbox(Arrays.asList(sandbox));
            return this;
        }

        public IframeConfig build() {
            return new IframeConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IframeConfig> {
        public Builder allow(Collection<String> var1);

        public Builder allow(String ... var1);

        public Builder sandbox(Collection<String> var1);

        public Builder sandbox(String ... var1);
    }
}

