/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appintegrations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appintegrations.model.AppIntegrationsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDataIntegrationAssociationsRequest
extends AppIntegrationsRequest
implements ToCopyableBuilder<Builder, ListDataIntegrationAssociationsRequest> {
    private static final SdkField<String> DATA_INTEGRATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataIntegrationIdentifier").getter(ListDataIntegrationAssociationsRequest.getter(ListDataIntegrationAssociationsRequest::dataIntegrationIdentifier)).setter(ListDataIntegrationAssociationsRequest.setter(Builder::dataIntegrationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Identifier").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDataIntegrationAssociationsRequest.getter(ListDataIntegrationAssociationsRequest::nextToken)).setter(ListDataIntegrationAssociationsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListDataIntegrationAssociationsRequest.getter(ListDataIntegrationAssociationsRequest::maxResults)).setter(ListDataIntegrationAssociationsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_INTEGRATION_IDENTIFIER_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDataIntegrationAssociationsRequest.memberNameToFieldInitializer();
    private final String dataIntegrationIdentifier;
    private final String nextToken;
    private final Integer maxResults;

    private ListDataIntegrationAssociationsRequest(BuilderImpl builder) {
        super(builder);
        this.dataIntegrationIdentifier = builder.dataIntegrationIdentifier;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String dataIntegrationIdentifier() {
        return this.dataIntegrationIdentifier;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dataIntegrationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataIntegrationAssociationsRequest)) {
            return false;
        }
        ListDataIntegrationAssociationsRequest other = (ListDataIntegrationAssociationsRequest)((Object)obj);
        return Objects.equals(this.dataIntegrationIdentifier(), other.dataIntegrationIdentifier()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListDataIntegrationAssociationsRequest").add("DataIntegrationIdentifier", (Object)this.dataIntegrationIdentifier()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataIntegrationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dataIntegrationIdentifier()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Identifier", DATA_INTEGRATION_IDENTIFIER_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDataIntegrationAssociationsRequest, T> g) {
        return obj -> g.apply((ListDataIntegrationAssociationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppIntegrationsRequest.BuilderImpl
    implements Builder {
        private String dataIntegrationIdentifier;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataIntegrationAssociationsRequest model) {
            super(model);
            this.dataIntegrationIdentifier(model.dataIntegrationIdentifier);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getDataIntegrationIdentifier() {
            return this.dataIntegrationIdentifier;
        }

        public final void setDataIntegrationIdentifier(String dataIntegrationIdentifier) {
            this.dataIntegrationIdentifier = dataIntegrationIdentifier;
        }

        @Override
        public final Builder dataIntegrationIdentifier(String dataIntegrationIdentifier) {
            this.dataIntegrationIdentifier = dataIntegrationIdentifier;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDataIntegrationAssociationsRequest build() {
            return new ListDataIntegrationAssociationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AppIntegrationsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDataIntegrationAssociationsRequest> {
        public Builder dataIntegrationIdentifier(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

