/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appintegrations.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appintegrations.AppIntegrationsAsyncClient;
import software.amazon.awssdk.services.appintegrations.internal.UserAgentUtils;
import software.amazon.awssdk.services.appintegrations.model.EventIntegration;
import software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationsRequest;
import software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationsResponse;

public class ListEventIntegrationsPublisher
implements SdkPublisher<ListEventIntegrationsResponse> {
    private final AppIntegrationsAsyncClient client;
    private final ListEventIntegrationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEventIntegrationsPublisher(AppIntegrationsAsyncClient client, ListEventIntegrationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEventIntegrationsPublisher(AppIntegrationsAsyncClient client, ListEventIntegrationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEventIntegrationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEventIntegrationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EventIntegration> eventIntegrations() {
        Function<ListEventIntegrationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.eventIntegrations() != null) {
                return response.eventIntegrations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEventIntegrationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEventIntegrationsResponseFetcher
    implements AsyncPageFetcher<ListEventIntegrationsResponse> {
        private ListEventIntegrationsResponseFetcher() {
        }

        public boolean hasNextPage(ListEventIntegrationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEventIntegrationsResponse> nextPage(ListEventIntegrationsResponse previousPage) {
            if (previousPage == null) {
                return ListEventIntegrationsPublisher.this.client.listEventIntegrations(ListEventIntegrationsPublisher.this.firstRequest);
            }
            return ListEventIntegrationsPublisher.this.client.listEventIntegrations((ListEventIntegrationsRequest)((Object)ListEventIntegrationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

