/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFlowRequest extends AppflowRequest implements
        ToCopyableBuilder<UpdateFlowRequest.Builder, UpdateFlowRequest> {
    private static final SdkField<String> FLOW_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("flowName").getter(getter(UpdateFlowRequest::flowName)).setter(setter(Builder::flowName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateFlowRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<TriggerConfig> TRIGGER_CONFIG_FIELD = SdkField
            .<TriggerConfig> builder(MarshallingType.SDK_POJO).memberName("triggerConfig")
            .getter(getter(UpdateFlowRequest::triggerConfig)).setter(setter(Builder::triggerConfig))
            .constructor(TriggerConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggerConfig").build()).build();

    private static final SdkField<SourceFlowConfig> SOURCE_FLOW_CONFIG_FIELD = SdkField
            .<SourceFlowConfig> builder(MarshallingType.SDK_POJO).memberName("sourceFlowConfig")
            .getter(getter(UpdateFlowRequest::sourceFlowConfig)).setter(setter(Builder::sourceFlowConfig))
            .constructor(SourceFlowConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceFlowConfig").build()).build();

    private static final SdkField<List<DestinationFlowConfig>> DESTINATION_FLOW_CONFIG_LIST_FIELD = SdkField
            .<List<DestinationFlowConfig>> builder(MarshallingType.LIST)
            .memberName("destinationFlowConfigList")
            .getter(getter(UpdateFlowRequest::destinationFlowConfigList))
            .setter(setter(Builder::destinationFlowConfigList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationFlowConfigList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DestinationFlowConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(DestinationFlowConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Task>> TASKS_FIELD = SdkField
            .<List<Task>> builder(MarshallingType.LIST)
            .memberName("tasks")
            .getter(getter(UpdateFlowRequest::tasks))
            .setter(setter(Builder::tasks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tasks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Task> builder(MarshallingType.SDK_POJO)
                                            .constructor(Task::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<MetadataCatalogConfig> METADATA_CATALOG_CONFIG_FIELD = SdkField
            .<MetadataCatalogConfig> builder(MarshallingType.SDK_POJO).memberName("metadataCatalogConfig")
            .getter(getter(UpdateFlowRequest::metadataCatalogConfig)).setter(setter(Builder::metadataCatalogConfig))
            .constructor(MetadataCatalogConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataCatalogConfig").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateFlowRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_NAME_FIELD,
            DESCRIPTION_FIELD, TRIGGER_CONFIG_FIELD, SOURCE_FLOW_CONFIG_FIELD, DESTINATION_FLOW_CONFIG_LIST_FIELD, TASKS_FIELD,
            METADATA_CATALOG_CONFIG_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String flowName;

    private final String description;

    private final TriggerConfig triggerConfig;

    private final SourceFlowConfig sourceFlowConfig;

    private final List<DestinationFlowConfig> destinationFlowConfigList;

    private final List<Task> tasks;

    private final MetadataCatalogConfig metadataCatalogConfig;

    private final String clientToken;

    private UpdateFlowRequest(BuilderImpl builder) {
        super(builder);
        this.flowName = builder.flowName;
        this.description = builder.description;
        this.triggerConfig = builder.triggerConfig;
        this.sourceFlowConfig = builder.sourceFlowConfig;
        this.destinationFlowConfigList = builder.destinationFlowConfigList;
        this.tasks = builder.tasks;
        this.metadataCatalogConfig = builder.metadataCatalogConfig;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only.
     * </p>
     * 
     * @return The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only.
     */
    public final String flowName() {
        return flowName;
    }

    /**
     * <p>
     * A description of the flow.
     * </p>
     * 
     * @return A description of the flow.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The trigger settings that determine how and when the flow runs.
     * </p>
     * 
     * @return The trigger settings that determine how and when the flow runs.
     */
    public final TriggerConfig triggerConfig() {
        return triggerConfig;
    }

    /**
     * Returns the value of the SourceFlowConfig property for this object.
     * 
     * @return The value of the SourceFlowConfig property for this object.
     */
    public final SourceFlowConfig sourceFlowConfig() {
        return sourceFlowConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the DestinationFlowConfigList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDestinationFlowConfigList() {
        return destinationFlowConfigList != null && !(destinationFlowConfigList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configuration that controls how Amazon AppFlow transfers data to the destination connector.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDestinationFlowConfigList} method.
     * </p>
     * 
     * @return The configuration that controls how Amazon AppFlow transfers data to the destination connector.
     */
    public final List<DestinationFlowConfig> destinationFlowConfigList() {
        return destinationFlowConfigList;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tasks property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTasks() {
        return tasks != null && !(tasks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tasks that Amazon AppFlow performs while transferring the data in the flow run.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTasks} method.
     * </p>
     * 
     * @return A list of tasks that Amazon AppFlow performs while transferring the data in the flow run.
     */
    public final List<Task> tasks() {
        return tasks;
    }

    /**
     * <p>
     * Specifies the configuration that Amazon AppFlow uses when it catalogs the data that's transferred by the
     * associated flow. When Amazon AppFlow catalogs the data from a flow, it stores metadata in a data catalog.
     * </p>
     * 
     * @return Specifies the configuration that Amazon AppFlow uses when it catalogs the data that's transferred by the
     *         associated flow. When Amazon AppFlow catalogs the data from a flow, it stores metadata in a data catalog.
     */
    public final MetadataCatalogConfig metadataCatalogConfig() {
        return metadataCatalogConfig;
    }

    /**
     * <p>
     * The <code>clientToken</code> parameter is an idempotency token. It ensures that your <code>UpdateFlow</code>
     * request completes only once. You choose the value to pass. For example, if you don't receive a response from your
     * request, you can safely retry the request with the same <code>clientToken</code> parameter value.
     * </p>
     * <p>
     * If you omit a <code>clientToken</code> value, the Amazon Web Services SDK that you are using inserts a value for
     * you. This way, the SDK can safely retry requests multiple times after a network error. You must provide your own
     * value for other use cases.
     * </p>
     * <p>
     * If you specify input parameters that differ from your first request, an error occurs. If you use a different
     * value for <code>clientToken</code>, Amazon AppFlow considers it a new call to <code>UpdateFlow</code>. The token
     * is active for 8 hours.
     * </p>
     * 
     * @return The <code>clientToken</code> parameter is an idempotency token. It ensures that your
     *         <code>UpdateFlow</code> request completes only once. You choose the value to pass. For example, if you
     *         don't receive a response from your request, you can safely retry the request with the same
     *         <code>clientToken</code> parameter value.</p>
     *         <p>
     *         If you omit a <code>clientToken</code> value, the Amazon Web Services SDK that you are using inserts a
     *         value for you. This way, the SDK can safely retry requests multiple times after a network error. You must
     *         provide your own value for other use cases.
     *         </p>
     *         <p>
     *         If you specify input parameters that differ from your first request, an error occurs. If you use a
     *         different value for <code>clientToken</code>, Amazon AppFlow considers it a new call to
     *         <code>UpdateFlow</code>. The token is active for 8 hours.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(flowName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(triggerConfig());
        hashCode = 31 * hashCode + Objects.hashCode(sourceFlowConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinationFlowConfigList() ? destinationFlowConfigList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTasks() ? tasks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(metadataCatalogConfig());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFlowRequest)) {
            return false;
        }
        UpdateFlowRequest other = (UpdateFlowRequest) obj;
        return Objects.equals(flowName(), other.flowName()) && Objects.equals(description(), other.description())
                && Objects.equals(triggerConfig(), other.triggerConfig())
                && Objects.equals(sourceFlowConfig(), other.sourceFlowConfig())
                && hasDestinationFlowConfigList() == other.hasDestinationFlowConfigList()
                && Objects.equals(destinationFlowConfigList(), other.destinationFlowConfigList())
                && hasTasks() == other.hasTasks() && Objects.equals(tasks(), other.tasks())
                && Objects.equals(metadataCatalogConfig(), other.metadataCatalogConfig())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFlowRequest").add("FlowName", flowName()).add("Description", description())
                .add("TriggerConfig", triggerConfig()).add("SourceFlowConfig", sourceFlowConfig())
                .add("DestinationFlowConfigList", hasDestinationFlowConfigList() ? destinationFlowConfigList() : null)
                .add("Tasks", hasTasks() ? tasks() : null).add("MetadataCatalogConfig", metadataCatalogConfig())
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "flowName":
            return Optional.ofNullable(clazz.cast(flowName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "triggerConfig":
            return Optional.ofNullable(clazz.cast(triggerConfig()));
        case "sourceFlowConfig":
            return Optional.ofNullable(clazz.cast(sourceFlowConfig()));
        case "destinationFlowConfigList":
            return Optional.ofNullable(clazz.cast(destinationFlowConfigList()));
        case "tasks":
            return Optional.ofNullable(clazz.cast(tasks()));
        case "metadataCatalogConfig":
            return Optional.ofNullable(clazz.cast(metadataCatalogConfig()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("flowName", FLOW_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("triggerConfig", TRIGGER_CONFIG_FIELD);
        map.put("sourceFlowConfig", SOURCE_FLOW_CONFIG_FIELD);
        map.put("destinationFlowConfigList", DESTINATION_FLOW_CONFIG_LIST_FIELD);
        map.put("tasks", TASKS_FIELD);
        map.put("metadataCatalogConfig", METADATA_CATALOG_CONFIG_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateFlowRequest, T> g) {
        return obj -> g.apply((UpdateFlowRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AppflowRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFlowRequest> {
        /**
         * <p>
         * The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only.
         * </p>
         * 
         * @param flowName
         *        The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowName(String flowName);

        /**
         * <p>
         * A description of the flow.
         * </p>
         * 
         * @param description
         *        A description of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The trigger settings that determine how and when the flow runs.
         * </p>
         * 
         * @param triggerConfig
         *        The trigger settings that determine how and when the flow runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggerConfig(TriggerConfig triggerConfig);

        /**
         * <p>
         * The trigger settings that determine how and when the flow runs.
         * </p>
         * This is a convenience method that creates an instance of the {@link TriggerConfig.Builder} avoiding the need
         * to create one manually via {@link TriggerConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TriggerConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #triggerConfig(TriggerConfig)}.
         * 
         * @param triggerConfig
         *        a consumer that will call methods on {@link TriggerConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #triggerConfig(TriggerConfig)
         */
        default Builder triggerConfig(Consumer<TriggerConfig.Builder> triggerConfig) {
            return triggerConfig(TriggerConfig.builder().applyMutation(triggerConfig).build());
        }

        /**
         * Sets the value of the SourceFlowConfig property for this object.
         *
         * @param sourceFlowConfig
         *        The new value for the SourceFlowConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceFlowConfig(SourceFlowConfig sourceFlowConfig);

        /**
         * Sets the value of the SourceFlowConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SourceFlowConfig.Builder} avoiding the
         * need to create one manually via {@link SourceFlowConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SourceFlowConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceFlowConfig(SourceFlowConfig)}.
         * 
         * @param sourceFlowConfig
         *        a consumer that will call methods on {@link SourceFlowConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceFlowConfig(SourceFlowConfig)
         */
        default Builder sourceFlowConfig(Consumer<SourceFlowConfig.Builder> sourceFlowConfig) {
            return sourceFlowConfig(SourceFlowConfig.builder().applyMutation(sourceFlowConfig).build());
        }

        /**
         * <p>
         * The configuration that controls how Amazon AppFlow transfers data to the destination connector.
         * </p>
         * 
         * @param destinationFlowConfigList
         *        The configuration that controls how Amazon AppFlow transfers data to the destination connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationFlowConfigList(Collection<DestinationFlowConfig> destinationFlowConfigList);

        /**
         * <p>
         * The configuration that controls how Amazon AppFlow transfers data to the destination connector.
         * </p>
         * 
         * @param destinationFlowConfigList
         *        The configuration that controls how Amazon AppFlow transfers data to the destination connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationFlowConfigList(DestinationFlowConfig... destinationFlowConfigList);

        /**
         * <p>
         * The configuration that controls how Amazon AppFlow transfers data to the destination connector.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.appflow.model.DestinationFlowConfig.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.appflow.model.DestinationFlowConfig#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.appflow.model.DestinationFlowConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #destinationFlowConfigList(List<DestinationFlowConfig>)}.
         * 
         * @param destinationFlowConfigList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.appflow.model.DestinationFlowConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationFlowConfigList(java.util.Collection<DestinationFlowConfig>)
         */
        Builder destinationFlowConfigList(Consumer<DestinationFlowConfig.Builder>... destinationFlowConfigList);

        /**
         * <p>
         * A list of tasks that Amazon AppFlow performs while transferring the data in the flow run.
         * </p>
         * 
         * @param tasks
         *        A list of tasks that Amazon AppFlow performs while transferring the data in the flow run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tasks(Collection<Task> tasks);

        /**
         * <p>
         * A list of tasks that Amazon AppFlow performs while transferring the data in the flow run.
         * </p>
         * 
         * @param tasks
         *        A list of tasks that Amazon AppFlow performs while transferring the data in the flow run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tasks(Task... tasks);

        /**
         * <p>
         * A list of tasks that Amazon AppFlow performs while transferring the data in the flow run.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.appflow.model.Task.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.appflow.model.Task#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.appflow.model.Task.Builder#build()} is called immediately and its
         * result is passed to {@link #tasks(List<Task>)}.
         * 
         * @param tasks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.appflow.model.Task.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tasks(java.util.Collection<Task>)
         */
        Builder tasks(Consumer<Task.Builder>... tasks);

        /**
         * <p>
         * Specifies the configuration that Amazon AppFlow uses when it catalogs the data that's transferred by the
         * associated flow. When Amazon AppFlow catalogs the data from a flow, it stores metadata in a data catalog.
         * </p>
         * 
         * @param metadataCatalogConfig
         *        Specifies the configuration that Amazon AppFlow uses when it catalogs the data that's transferred by
         *        the associated flow. When Amazon AppFlow catalogs the data from a flow, it stores metadata in a data
         *        catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataCatalogConfig(MetadataCatalogConfig metadataCatalogConfig);

        /**
         * <p>
         * Specifies the configuration that Amazon AppFlow uses when it catalogs the data that's transferred by the
         * associated flow. When Amazon AppFlow catalogs the data from a flow, it stores metadata in a data catalog.
         * </p>
         * This is a convenience method that creates an instance of the {@link MetadataCatalogConfig.Builder} avoiding
         * the need to create one manually via {@link MetadataCatalogConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetadataCatalogConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #metadataCatalogConfig(MetadataCatalogConfig)}.
         * 
         * @param metadataCatalogConfig
         *        a consumer that will call methods on {@link MetadataCatalogConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadataCatalogConfig(MetadataCatalogConfig)
         */
        default Builder metadataCatalogConfig(Consumer<MetadataCatalogConfig.Builder> metadataCatalogConfig) {
            return metadataCatalogConfig(MetadataCatalogConfig.builder().applyMutation(metadataCatalogConfig).build());
        }

        /**
         * <p>
         * The <code>clientToken</code> parameter is an idempotency token. It ensures that your <code>UpdateFlow</code>
         * request completes only once. You choose the value to pass. For example, if you don't receive a response from
         * your request, you can safely retry the request with the same <code>clientToken</code> parameter value.
         * </p>
         * <p>
         * If you omit a <code>clientToken</code> value, the Amazon Web Services SDK that you are using inserts a value
         * for you. This way, the SDK can safely retry requests multiple times after a network error. You must provide
         * your own value for other use cases.
         * </p>
         * <p>
         * If you specify input parameters that differ from your first request, an error occurs. If you use a different
         * value for <code>clientToken</code>, Amazon AppFlow considers it a new call to <code>UpdateFlow</code>. The
         * token is active for 8 hours.
         * </p>
         * 
         * @param clientToken
         *        The <code>clientToken</code> parameter is an idempotency token. It ensures that your
         *        <code>UpdateFlow</code> request completes only once. You choose the value to pass. For example, if you
         *        don't receive a response from your request, you can safely retry the request with the same
         *        <code>clientToken</code> parameter value.</p>
         *        <p>
         *        If you omit a <code>clientToken</code> value, the Amazon Web Services SDK that you are using inserts a
         *        value for you. This way, the SDK can safely retry requests multiple times after a network error. You
         *        must provide your own value for other use cases.
         *        </p>
         *        <p>
         *        If you specify input parameters that differ from your first request, an error occurs. If you use a
         *        different value for <code>clientToken</code>, Amazon AppFlow considers it a new call to
         *        <code>UpdateFlow</code>. The token is active for 8 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppflowRequest.BuilderImpl implements Builder {
        private String flowName;

        private String description;

        private TriggerConfig triggerConfig;

        private SourceFlowConfig sourceFlowConfig;

        private List<DestinationFlowConfig> destinationFlowConfigList = DefaultSdkAutoConstructList.getInstance();

        private List<Task> tasks = DefaultSdkAutoConstructList.getInstance();

        private MetadataCatalogConfig metadataCatalogConfig;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFlowRequest model) {
            super(model);
            flowName(model.flowName);
            description(model.description);
            triggerConfig(model.triggerConfig);
            sourceFlowConfig(model.sourceFlowConfig);
            destinationFlowConfigList(model.destinationFlowConfigList);
            tasks(model.tasks);
            metadataCatalogConfig(model.metadataCatalogConfig);
            clientToken(model.clientToken);
        }

        public final String getFlowName() {
            return flowName;
        }

        public final void setFlowName(String flowName) {
            this.flowName = flowName;
        }

        @Override
        public final Builder flowName(String flowName) {
            this.flowName = flowName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final TriggerConfig.Builder getTriggerConfig() {
            return triggerConfig != null ? triggerConfig.toBuilder() : null;
        }

        public final void setTriggerConfig(TriggerConfig.BuilderImpl triggerConfig) {
            this.triggerConfig = triggerConfig != null ? triggerConfig.build() : null;
        }

        @Override
        public final Builder triggerConfig(TriggerConfig triggerConfig) {
            this.triggerConfig = triggerConfig;
            return this;
        }

        public final SourceFlowConfig.Builder getSourceFlowConfig() {
            return sourceFlowConfig != null ? sourceFlowConfig.toBuilder() : null;
        }

        public final void setSourceFlowConfig(SourceFlowConfig.BuilderImpl sourceFlowConfig) {
            this.sourceFlowConfig = sourceFlowConfig != null ? sourceFlowConfig.build() : null;
        }

        @Override
        public final Builder sourceFlowConfig(SourceFlowConfig sourceFlowConfig) {
            this.sourceFlowConfig = sourceFlowConfig;
            return this;
        }

        public final List<DestinationFlowConfig.Builder> getDestinationFlowConfigList() {
            List<DestinationFlowConfig.Builder> result = DestinationFlowConfigListCopier
                    .copyToBuilder(this.destinationFlowConfigList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinationFlowConfigList(Collection<DestinationFlowConfig.BuilderImpl> destinationFlowConfigList) {
            this.destinationFlowConfigList = DestinationFlowConfigListCopier.copyFromBuilder(destinationFlowConfigList);
        }

        @Override
        public final Builder destinationFlowConfigList(Collection<DestinationFlowConfig> destinationFlowConfigList) {
            this.destinationFlowConfigList = DestinationFlowConfigListCopier.copy(destinationFlowConfigList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationFlowConfigList(DestinationFlowConfig... destinationFlowConfigList) {
            destinationFlowConfigList(Arrays.asList(destinationFlowConfigList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationFlowConfigList(Consumer<DestinationFlowConfig.Builder>... destinationFlowConfigList) {
            destinationFlowConfigList(Stream.of(destinationFlowConfigList)
                    .map(c -> DestinationFlowConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Task.Builder> getTasks() {
            List<Task.Builder> result = TasksCopier.copyToBuilder(this.tasks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTasks(Collection<Task.BuilderImpl> tasks) {
            this.tasks = TasksCopier.copyFromBuilder(tasks);
        }

        @Override
        public final Builder tasks(Collection<Task> tasks) {
            this.tasks = TasksCopier.copy(tasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(Task... tasks) {
            tasks(Arrays.asList(tasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(Consumer<Task.Builder>... tasks) {
            tasks(Stream.of(tasks).map(c -> Task.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final MetadataCatalogConfig.Builder getMetadataCatalogConfig() {
            return metadataCatalogConfig != null ? metadataCatalogConfig.toBuilder() : null;
        }

        public final void setMetadataCatalogConfig(MetadataCatalogConfig.BuilderImpl metadataCatalogConfig) {
            this.metadataCatalogConfig = metadataCatalogConfig != null ? metadataCatalogConfig.build() : null;
        }

        @Override
        public final Builder metadataCatalogConfig(MetadataCatalogConfig metadataCatalogConfig) {
            this.metadataCatalogConfig = metadataCatalogConfig;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFlowRequest build() {
            return new UpdateFlowRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
