/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The properties that are applied when Amazon S3 is being used as the flow source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3SourceProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<S3SourceProperties.Builder, S3SourceProperties> {
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bucketName").getter(getter(S3SourceProperties::bucketName)).setter(setter(Builder::bucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketName").build()).build();

    private static final SdkField<String> BUCKET_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bucketPrefix").getter(getter(S3SourceProperties::bucketPrefix)).setter(setter(Builder::bucketPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketPrefix").build()).build();

    private static final SdkField<S3InputFormatConfig> S3_INPUT_FORMAT_CONFIG_FIELD = SdkField
            .<S3InputFormatConfig> builder(MarshallingType.SDK_POJO).memberName("s3InputFormatConfig")
            .getter(getter(S3SourceProperties::s3InputFormatConfig)).setter(setter(Builder::s3InputFormatConfig))
            .constructor(S3InputFormatConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3InputFormatConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_NAME_FIELD,
            BUCKET_PREFIX_FIELD, S3_INPUT_FORMAT_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String bucketName;

    private final String bucketPrefix;

    private final S3InputFormatConfig s3InputFormatConfig;

    private S3SourceProperties(BuilderImpl builder) {
        this.bucketName = builder.bucketName;
        this.bucketPrefix = builder.bucketPrefix;
        this.s3InputFormatConfig = builder.s3InputFormatConfig;
    }

    /**
     * <p>
     * The Amazon S3 bucket name where the source files are stored.
     * </p>
     * 
     * @return The Amazon S3 bucket name where the source files are stored.
     */
    public final String bucketName() {
        return bucketName;
    }

    /**
     * <p>
     * The object key for the Amazon S3 bucket in which the source files are stored.
     * </p>
     * 
     * @return The object key for the Amazon S3 bucket in which the source files are stored.
     */
    public final String bucketPrefix() {
        return bucketPrefix;
    }

    /**
     * Returns the value of the S3InputFormatConfig property for this object.
     * 
     * @return The value of the S3InputFormatConfig property for this object.
     */
    public final S3InputFormatConfig s3InputFormatConfig() {
        return s3InputFormatConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(bucketPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(s3InputFormatConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3SourceProperties)) {
            return false;
        }
        S3SourceProperties other = (S3SourceProperties) obj;
        return Objects.equals(bucketName(), other.bucketName()) && Objects.equals(bucketPrefix(), other.bucketPrefix())
                && Objects.equals(s3InputFormatConfig(), other.s3InputFormatConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3SourceProperties").add("BucketName", bucketName()).add("BucketPrefix", bucketPrefix())
                .add("S3InputFormatConfig", s3InputFormatConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bucketName":
            return Optional.ofNullable(clazz.cast(bucketName()));
        case "bucketPrefix":
            return Optional.ofNullable(clazz.cast(bucketPrefix()));
        case "s3InputFormatConfig":
            return Optional.ofNullable(clazz.cast(s3InputFormatConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("bucketName", BUCKET_NAME_FIELD);
        map.put("bucketPrefix", BUCKET_PREFIX_FIELD);
        map.put("s3InputFormatConfig", S3_INPUT_FORMAT_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3SourceProperties, T> g) {
        return obj -> g.apply((S3SourceProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3SourceProperties> {
        /**
         * <p>
         * The Amazon S3 bucket name where the source files are stored.
         * </p>
         * 
         * @param bucketName
         *        The Amazon S3 bucket name where the source files are stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketName(String bucketName);

        /**
         * <p>
         * The object key for the Amazon S3 bucket in which the source files are stored.
         * </p>
         * 
         * @param bucketPrefix
         *        The object key for the Amazon S3 bucket in which the source files are stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketPrefix(String bucketPrefix);

        /**
         * Sets the value of the S3InputFormatConfig property for this object.
         *
         * @param s3InputFormatConfig
         *        The new value for the S3InputFormatConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3InputFormatConfig(S3InputFormatConfig s3InputFormatConfig);

        /**
         * Sets the value of the S3InputFormatConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link S3InputFormatConfig.Builder} avoiding the
         * need to create one manually via {@link S3InputFormatConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3InputFormatConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #s3InputFormatConfig(S3InputFormatConfig)}.
         * 
         * @param s3InputFormatConfig
         *        a consumer that will call methods on {@link S3InputFormatConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3InputFormatConfig(S3InputFormatConfig)
         */
        default Builder s3InputFormatConfig(Consumer<S3InputFormatConfig.Builder> s3InputFormatConfig) {
            return s3InputFormatConfig(S3InputFormatConfig.builder().applyMutation(s3InputFormatConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String bucketName;

        private String bucketPrefix;

        private S3InputFormatConfig s3InputFormatConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(S3SourceProperties model) {
            bucketName(model.bucketName);
            bucketPrefix(model.bucketPrefix);
            s3InputFormatConfig(model.s3InputFormatConfig);
        }

        public final String getBucketName() {
            return bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final String getBucketPrefix() {
            return bucketPrefix;
        }

        public final void setBucketPrefix(String bucketPrefix) {
            this.bucketPrefix = bucketPrefix;
        }

        @Override
        public final Builder bucketPrefix(String bucketPrefix) {
            this.bucketPrefix = bucketPrefix;
            return this;
        }

        public final S3InputFormatConfig.Builder getS3InputFormatConfig() {
            return s3InputFormatConfig != null ? s3InputFormatConfig.toBuilder() : null;
        }

        public final void setS3InputFormatConfig(S3InputFormatConfig.BuilderImpl s3InputFormatConfig) {
            this.s3InputFormatConfig = s3InputFormatConfig != null ? s3InputFormatConfig.build() : null;
        }

        @Override
        public final Builder s3InputFormatConfig(S3InputFormatConfig s3InputFormatConfig) {
            this.s3InputFormatConfig = s3InputFormatConfig;
            return this;
        }

        @Override
        public S3SourceProperties build() {
            return new S3SourceProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
