/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The OAuth credentials required for OAuth type authentication.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OAuthCredentials implements SdkPojo, Serializable,
        ToCopyableBuilder<OAuthCredentials.Builder, OAuthCredentials> {
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientId").getter(getter(OAuthCredentials::clientId)).setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientId").build()).build();

    private static final SdkField<String> CLIENT_SECRET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientSecret").getter(getter(OAuthCredentials::clientSecret)).setter(setter(Builder::clientSecret))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientSecret").build()).build();

    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accessToken").getter(getter(OAuthCredentials::accessToken)).setter(setter(Builder::accessToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessToken").build()).build();

    private static final SdkField<String> REFRESH_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("refreshToken").getter(getter(OAuthCredentials::refreshToken)).setter(setter(Builder::refreshToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("refreshToken").build()).build();

    private static final SdkField<ConnectorOAuthRequest> O_AUTH_REQUEST_FIELD = SdkField
            .<ConnectorOAuthRequest> builder(MarshallingType.SDK_POJO).memberName("oAuthRequest")
            .getter(getter(OAuthCredentials::oAuthRequest)).setter(setter(Builder::oAuthRequest))
            .constructor(ConnectorOAuthRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oAuthRequest").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_ID_FIELD,
            CLIENT_SECRET_FIELD, ACCESS_TOKEN_FIELD, REFRESH_TOKEN_FIELD, O_AUTH_REQUEST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String clientId;

    private final String clientSecret;

    private final String accessToken;

    private final String refreshToken;

    private final ConnectorOAuthRequest oAuthRequest;

    private OAuthCredentials(BuilderImpl builder) {
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.accessToken = builder.accessToken;
        this.refreshToken = builder.refreshToken;
        this.oAuthRequest = builder.oAuthRequest;
    }

    /**
     * <p>
     * The identifier for the desired client.
     * </p>
     * 
     * @return The identifier for the desired client.
     */
    public final String clientId() {
        return clientId;
    }

    /**
     * <p>
     * The client secret used by the OAuth client to authenticate to the authorization server.
     * </p>
     * 
     * @return The client secret used by the OAuth client to authenticate to the authorization server.
     */
    public final String clientSecret() {
        return clientSecret;
    }

    /**
     * <p>
     * The access token used to access protected SAPOData resources.
     * </p>
     * 
     * @return The access token used to access protected SAPOData resources.
     */
    public final String accessToken() {
        return accessToken;
    }

    /**
     * <p>
     * The refresh token used to refresh expired access token.
     * </p>
     * 
     * @return The refresh token used to refresh expired access token.
     */
    public final String refreshToken() {
        return refreshToken;
    }

    /**
     * <p>
     * The OAuth requirement needed to request security tokens from the connector endpoint.
     * </p>
     * 
     * @return The OAuth requirement needed to request security tokens from the connector endpoint.
     */
    public final ConnectorOAuthRequest oAuthRequest() {
        return oAuthRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(clientSecret());
        hashCode = 31 * hashCode + Objects.hashCode(accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(refreshToken());
        hashCode = 31 * hashCode + Objects.hashCode(oAuthRequest());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OAuthCredentials)) {
            return false;
        }
        OAuthCredentials other = (OAuthCredentials) obj;
        return Objects.equals(clientId(), other.clientId()) && Objects.equals(clientSecret(), other.clientSecret())
                && Objects.equals(accessToken(), other.accessToken()) && Objects.equals(refreshToken(), other.refreshToken())
                && Objects.equals(oAuthRequest(), other.oAuthRequest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OAuthCredentials").add("ClientId", clientId())
                .add("ClientSecret", clientSecret() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AccessToken", accessToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("RefreshToken", refreshToken()).add("OAuthRequest", oAuthRequest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "clientSecret":
            return Optional.ofNullable(clazz.cast(clientSecret()));
        case "accessToken":
            return Optional.ofNullable(clazz.cast(accessToken()));
        case "refreshToken":
            return Optional.ofNullable(clazz.cast(refreshToken()));
        case "oAuthRequest":
            return Optional.ofNullable(clazz.cast(oAuthRequest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientId", CLIENT_ID_FIELD);
        map.put("clientSecret", CLIENT_SECRET_FIELD);
        map.put("accessToken", ACCESS_TOKEN_FIELD);
        map.put("refreshToken", REFRESH_TOKEN_FIELD);
        map.put("oAuthRequest", O_AUTH_REQUEST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OAuthCredentials, T> g) {
        return obj -> g.apply((OAuthCredentials) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OAuthCredentials> {
        /**
         * <p>
         * The identifier for the desired client.
         * </p>
         * 
         * @param clientId
         *        The identifier for the desired client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * The client secret used by the OAuth client to authenticate to the authorization server.
         * </p>
         * 
         * @param clientSecret
         *        The client secret used by the OAuth client to authenticate to the authorization server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientSecret(String clientSecret);

        /**
         * <p>
         * The access token used to access protected SAPOData resources.
         * </p>
         * 
         * @param accessToken
         *        The access token used to access protected SAPOData resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessToken(String accessToken);

        /**
         * <p>
         * The refresh token used to refresh expired access token.
         * </p>
         * 
         * @param refreshToken
         *        The refresh token used to refresh expired access token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshToken(String refreshToken);

        /**
         * <p>
         * The OAuth requirement needed to request security tokens from the connector endpoint.
         * </p>
         * 
         * @param oAuthRequest
         *        The OAuth requirement needed to request security tokens from the connector endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oAuthRequest(ConnectorOAuthRequest oAuthRequest);

        /**
         * <p>
         * The OAuth requirement needed to request security tokens from the connector endpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConnectorOAuthRequest.Builder} avoiding
         * the need to create one manually via {@link ConnectorOAuthRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectorOAuthRequest.Builder#build()} is called immediately and
         * its result is passed to {@link #oAuthRequest(ConnectorOAuthRequest)}.
         * 
         * @param oAuthRequest
         *        a consumer that will call methods on {@link ConnectorOAuthRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oAuthRequest(ConnectorOAuthRequest)
         */
        default Builder oAuthRequest(Consumer<ConnectorOAuthRequest.Builder> oAuthRequest) {
            return oAuthRequest(ConnectorOAuthRequest.builder().applyMutation(oAuthRequest).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String clientId;

        private String clientSecret;

        private String accessToken;

        private String refreshToken;

        private ConnectorOAuthRequest oAuthRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(OAuthCredentials model) {
            clientId(model.clientId);
            clientSecret(model.clientSecret);
            accessToken(model.accessToken);
            refreshToken(model.refreshToken);
            oAuthRequest(model.oAuthRequest);
        }

        public final String getClientId() {
            return clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final String getClientSecret() {
            return clientSecret;
        }

        public final void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        @Override
        public final Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public final String getAccessToken() {
            return accessToken;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final String getRefreshToken() {
            return refreshToken;
        }

        public final void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        @Override
        public final Builder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public final ConnectorOAuthRequest.Builder getOAuthRequest() {
            return oAuthRequest != null ? oAuthRequest.toBuilder() : null;
        }

        public final void setOAuthRequest(ConnectorOAuthRequest.BuilderImpl oAuthRequest) {
            this.oAuthRequest = oAuthRequest != null ? oAuthRequest.build() : null;
        }

        @Override
        public final Builder oAuthRequest(ConnectorOAuthRequest oAuthRequest) {
            this.oAuthRequest = oAuthRequest;
            return this;
        }

        @Override
        public OAuthCredentials build() {
            return new OAuthCredentials(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
