/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Custom parameter required for OAuth 2.0 authentication.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OAuth2CustomParameter implements SdkPojo, Serializable,
        ToCopyableBuilder<OAuth2CustomParameter.Builder, OAuth2CustomParameter> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("key")
            .getter(getter(OAuth2CustomParameter::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()).build();

    private static final SdkField<Boolean> IS_REQUIRED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isRequired").getter(getter(OAuth2CustomParameter::isRequired)).setter(setter(Builder::isRequired))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isRequired").build()).build();

    private static final SdkField<String> LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("label")
            .getter(getter(OAuth2CustomParameter::label)).setter(setter(Builder::label))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("label").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(OAuth2CustomParameter::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Boolean> IS_SENSITIVE_FIELD_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isSensitiveField").getter(getter(OAuth2CustomParameter::isSensitiveField))
            .setter(setter(Builder::isSensitiveField))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isSensitiveField").build()).build();

    private static final SdkField<List<String>> CONNECTOR_SUPPLIED_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("connectorSuppliedValues")
            .getter(getter(OAuth2CustomParameter::connectorSuppliedValues))
            .setter(setter(Builder::connectorSuppliedValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorSuppliedValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(OAuth2CustomParameter::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, IS_REQUIRED_FIELD,
            LABEL_FIELD, DESCRIPTION_FIELD, IS_SENSITIVE_FIELD_FIELD, CONNECTOR_SUPPLIED_VALUES_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String key;

    private final Boolean isRequired;

    private final String label;

    private final String description;

    private final Boolean isSensitiveField;

    private final List<String> connectorSuppliedValues;

    private final String type;

    private OAuth2CustomParameter(BuilderImpl builder) {
        this.key = builder.key;
        this.isRequired = builder.isRequired;
        this.label = builder.label;
        this.description = builder.description;
        this.isSensitiveField = builder.isSensitiveField;
        this.connectorSuppliedValues = builder.connectorSuppliedValues;
        this.type = builder.type;
    }

    /**
     * <p>
     * The key of the custom parameter required for OAuth 2.0 authentication.
     * </p>
     * 
     * @return The key of the custom parameter required for OAuth 2.0 authentication.
     */
    public final String key() {
        return key;
    }

    /**
     * <p>
     * Indicates whether the custom parameter for OAuth 2.0 authentication is required.
     * </p>
     * 
     * @return Indicates whether the custom parameter for OAuth 2.0 authentication is required.
     */
    public final Boolean isRequired() {
        return isRequired;
    }

    /**
     * <p>
     * The label of the custom parameter used for OAuth 2.0 authentication.
     * </p>
     * 
     * @return The label of the custom parameter used for OAuth 2.0 authentication.
     */
    public final String label() {
        return label;
    }

    /**
     * <p>
     * A description about the custom parameter used for OAuth 2.0 authentication.
     * </p>
     * 
     * @return A description about the custom parameter used for OAuth 2.0 authentication.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Indicates whether this authentication custom parameter is a sensitive field.
     * </p>
     * 
     * @return Indicates whether this authentication custom parameter is a sensitive field.
     */
    public final Boolean isSensitiveField() {
        return isSensitiveField;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConnectorSuppliedValues property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasConnectorSuppliedValues() {
        return connectorSuppliedValues != null && !(connectorSuppliedValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains default values for this authentication parameter that are supplied by the connector.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConnectorSuppliedValues} method.
     * </p>
     * 
     * @return Contains default values for this authentication parameter that are supplied by the connector.
     */
    public final List<String> connectorSuppliedValues() {
        return connectorSuppliedValues;
    }

    /**
     * <p>
     * Indicates whether custom parameter is used with TokenUrl or AuthUrl.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link OAuth2CustomPropType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Indicates whether custom parameter is used with TokenUrl or AuthUrl.
     * @see OAuth2CustomPropType
     */
    public final OAuth2CustomPropType type() {
        return OAuth2CustomPropType.fromValue(type);
    }

    /**
     * <p>
     * Indicates whether custom parameter is used with TokenUrl or AuthUrl.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link OAuth2CustomPropType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Indicates whether custom parameter is used with TokenUrl or AuthUrl.
     * @see OAuth2CustomPropType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(isRequired());
        hashCode = 31 * hashCode + Objects.hashCode(label());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(isSensitiveField());
        hashCode = 31 * hashCode + Objects.hashCode(hasConnectorSuppliedValues() ? connectorSuppliedValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OAuth2CustomParameter)) {
            return false;
        }
        OAuth2CustomParameter other = (OAuth2CustomParameter) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(isRequired(), other.isRequired())
                && Objects.equals(label(), other.label()) && Objects.equals(description(), other.description())
                && Objects.equals(isSensitiveField(), other.isSensitiveField())
                && hasConnectorSuppliedValues() == other.hasConnectorSuppliedValues()
                && Objects.equals(connectorSuppliedValues(), other.connectorSuppliedValues())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OAuth2CustomParameter").add("Key", key()).add("IsRequired", isRequired()).add("Label", label())
                .add("Description", description()).add("IsSensitiveField", isSensitiveField())
                .add("ConnectorSuppliedValues", hasConnectorSuppliedValues() ? connectorSuppliedValues() : null)
                .add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "key":
            return Optional.ofNullable(clazz.cast(key()));
        case "isRequired":
            return Optional.ofNullable(clazz.cast(isRequired()));
        case "label":
            return Optional.ofNullable(clazz.cast(label()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "isSensitiveField":
            return Optional.ofNullable(clazz.cast(isSensitiveField()));
        case "connectorSuppliedValues":
            return Optional.ofNullable(clazz.cast(connectorSuppliedValues()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("key", KEY_FIELD);
        map.put("isRequired", IS_REQUIRED_FIELD);
        map.put("label", LABEL_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("isSensitiveField", IS_SENSITIVE_FIELD_FIELD);
        map.put("connectorSuppliedValues", CONNECTOR_SUPPLIED_VALUES_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OAuth2CustomParameter, T> g) {
        return obj -> g.apply((OAuth2CustomParameter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OAuth2CustomParameter> {
        /**
         * <p>
         * The key of the custom parameter required for OAuth 2.0 authentication.
         * </p>
         * 
         * @param key
         *        The key of the custom parameter required for OAuth 2.0 authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * Indicates whether the custom parameter for OAuth 2.0 authentication is required.
         * </p>
         * 
         * @param isRequired
         *        Indicates whether the custom parameter for OAuth 2.0 authentication is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isRequired(Boolean isRequired);

        /**
         * <p>
         * The label of the custom parameter used for OAuth 2.0 authentication.
         * </p>
         * 
         * @param label
         *        The label of the custom parameter used for OAuth 2.0 authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder label(String label);

        /**
         * <p>
         * A description about the custom parameter used for OAuth 2.0 authentication.
         * </p>
         * 
         * @param description
         *        A description about the custom parameter used for OAuth 2.0 authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Indicates whether this authentication custom parameter is a sensitive field.
         * </p>
         * 
         * @param isSensitiveField
         *        Indicates whether this authentication custom parameter is a sensitive field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isSensitiveField(Boolean isSensitiveField);

        /**
         * <p>
         * Contains default values for this authentication parameter that are supplied by the connector.
         * </p>
         * 
         * @param connectorSuppliedValues
         *        Contains default values for this authentication parameter that are supplied by the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorSuppliedValues(Collection<String> connectorSuppliedValues);

        /**
         * <p>
         * Contains default values for this authentication parameter that are supplied by the connector.
         * </p>
         * 
         * @param connectorSuppliedValues
         *        Contains default values for this authentication parameter that are supplied by the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorSuppliedValues(String... connectorSuppliedValues);

        /**
         * <p>
         * Indicates whether custom parameter is used with TokenUrl or AuthUrl.
         * </p>
         * 
         * @param type
         *        Indicates whether custom parameter is used with TokenUrl or AuthUrl.
         * @see OAuth2CustomPropType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OAuth2CustomPropType
         */
        Builder type(String type);

        /**
         * <p>
         * Indicates whether custom parameter is used with TokenUrl or AuthUrl.
         * </p>
         * 
         * @param type
         *        Indicates whether custom parameter is used with TokenUrl or AuthUrl.
         * @see OAuth2CustomPropType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OAuth2CustomPropType
         */
        Builder type(OAuth2CustomPropType type);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private Boolean isRequired;

        private String label;

        private String description;

        private Boolean isSensitiveField;

        private List<String> connectorSuppliedValues = DefaultSdkAutoConstructList.getInstance();

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(OAuth2CustomParameter model) {
            key(model.key);
            isRequired(model.isRequired);
            label(model.label);
            description(model.description);
            isSensitiveField(model.isSensitiveField);
            connectorSuppliedValues(model.connectorSuppliedValues);
            type(model.type);
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final Boolean getIsRequired() {
            return isRequired;
        }

        public final void setIsRequired(Boolean isRequired) {
            this.isRequired = isRequired;
        }

        @Override
        public final Builder isRequired(Boolean isRequired) {
            this.isRequired = isRequired;
            return this;
        }

        public final String getLabel() {
            return label;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getIsSensitiveField() {
            return isSensitiveField;
        }

        public final void setIsSensitiveField(Boolean isSensitiveField) {
            this.isSensitiveField = isSensitiveField;
        }

        @Override
        public final Builder isSensitiveField(Boolean isSensitiveField) {
            this.isSensitiveField = isSensitiveField;
            return this;
        }

        public final Collection<String> getConnectorSuppliedValues() {
            if (connectorSuppliedValues instanceof SdkAutoConstructList) {
                return null;
            }
            return connectorSuppliedValues;
        }

        public final void setConnectorSuppliedValues(Collection<String> connectorSuppliedValues) {
            this.connectorSuppliedValues = ConnectorSuppliedValueListCopier.copy(connectorSuppliedValues);
        }

        @Override
        public final Builder connectorSuppliedValues(Collection<String> connectorSuppliedValues) {
            this.connectorSuppliedValues = ConnectorSuppliedValueListCopier.copy(connectorSuppliedValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectorSuppliedValues(String... connectorSuppliedValues) {
            connectorSuppliedValues(Arrays.asList(connectorSuppliedValues));
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(OAuth2CustomPropType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public OAuth2CustomParameter build() {
            return new OAuth2CustomParameter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
