/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The connector metadata specific to Amazon Honeycode.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HoneycodeMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<HoneycodeMetadata.Builder, HoneycodeMetadata> {
    private static final SdkField<List<String>> O_AUTH_SCOPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("oAuthScopes")
            .getter(getter(HoneycodeMetadata::oAuthScopes))
            .setter(setter(Builder::oAuthScopes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oAuthScopes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(O_AUTH_SCOPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> oAuthScopes;

    private HoneycodeMetadata(BuilderImpl builder) {
        this.oAuthScopes = builder.oAuthScopes;
    }

    /**
     * For responses, this returns true if the service returned a value for the OAuthScopes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOAuthScopes() {
        return oAuthScopes != null && !(oAuthScopes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The desired authorization scope for the Amazon Honeycode account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOAuthScopes} method.
     * </p>
     * 
     * @return The desired authorization scope for the Amazon Honeycode account.
     */
    public final List<String> oAuthScopes() {
        return oAuthScopes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasOAuthScopes() ? oAuthScopes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HoneycodeMetadata)) {
            return false;
        }
        HoneycodeMetadata other = (HoneycodeMetadata) obj;
        return hasOAuthScopes() == other.hasOAuthScopes() && Objects.equals(oAuthScopes(), other.oAuthScopes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HoneycodeMetadata").add("OAuthScopes", hasOAuthScopes() ? oAuthScopes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "oAuthScopes":
            return Optional.ofNullable(clazz.cast(oAuthScopes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("oAuthScopes", O_AUTH_SCOPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HoneycodeMetadata, T> g) {
        return obj -> g.apply((HoneycodeMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HoneycodeMetadata> {
        /**
         * <p>
         * The desired authorization scope for the Amazon Honeycode account.
         * </p>
         * 
         * @param oAuthScopes
         *        The desired authorization scope for the Amazon Honeycode account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oAuthScopes(Collection<String> oAuthScopes);

        /**
         * <p>
         * The desired authorization scope for the Amazon Honeycode account.
         * </p>
         * 
         * @param oAuthScopes
         *        The desired authorization scope for the Amazon Honeycode account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oAuthScopes(String... oAuthScopes);
    }

    static final class BuilderImpl implements Builder {
        private List<String> oAuthScopes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HoneycodeMetadata model) {
            oAuthScopes(model.oAuthScopes);
        }

        public final Collection<String> getOAuthScopes() {
            if (oAuthScopes instanceof SdkAutoConstructList) {
                return null;
            }
            return oAuthScopes;
        }

        public final void setOAuthScopes(Collection<String> oAuthScopes) {
            this.oAuthScopes = OAuthScopeListCopier.copy(oAuthScopes);
        }

        @Override
        public final Builder oAuthScopes(Collection<String> oAuthScopes) {
            this.oAuthScopes = OAuthScopeListCopier.copy(oAuthScopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder oAuthScopes(String... oAuthScopes) {
            oAuthScopes(Arrays.asList(oAuthScopes));
            return this;
        }

        @Override
        public HoneycodeMetadata build() {
            return new HoneycodeMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
