/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration settings related to a given connector.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectorConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectorConfiguration.Builder, ConnectorConfiguration> {
    private static final SdkField<Boolean> CAN_USE_AS_SOURCE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("canUseAsSource").getter(getter(ConnectorConfiguration::canUseAsSource))
            .setter(setter(Builder::canUseAsSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canUseAsSource").build()).build();

    private static final SdkField<Boolean> CAN_USE_AS_DESTINATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("canUseAsDestination").getter(getter(ConnectorConfiguration::canUseAsDestination))
            .setter(setter(Builder::canUseAsDestination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canUseAsDestination").build())
            .build();

    private static final SdkField<List<String>> SUPPORTED_DESTINATION_CONNECTORS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("supportedDestinationConnectors")
            .getter(getter(ConnectorConfiguration::supportedDestinationConnectorsAsStrings))
            .setter(setter(Builder::supportedDestinationConnectorsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedDestinationConnectors")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUPPORTED_SCHEDULING_FREQUENCIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("supportedSchedulingFrequencies")
            .getter(getter(ConnectorConfiguration::supportedSchedulingFrequenciesAsStrings))
            .setter(setter(Builder::supportedSchedulingFrequenciesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedSchedulingFrequencies")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> IS_PRIVATE_LINK_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isPrivateLinkEnabled").getter(getter(ConnectorConfiguration::isPrivateLinkEnabled))
            .setter(setter(Builder::isPrivateLinkEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isPrivateLinkEnabled").build())
            .build();

    private static final SdkField<Boolean> IS_PRIVATE_LINK_ENDPOINT_URL_REQUIRED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isPrivateLinkEndpointUrlRequired")
            .getter(getter(ConnectorConfiguration::isPrivateLinkEndpointUrlRequired))
            .setter(setter(Builder::isPrivateLinkEndpointUrlRequired))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isPrivateLinkEndpointUrlRequired")
                    .build()).build();

    private static final SdkField<List<String>> SUPPORTED_TRIGGER_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("supportedTriggerTypes")
            .getter(getter(ConnectorConfiguration::supportedTriggerTypesAsStrings))
            .setter(setter(Builder::supportedTriggerTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedTriggerTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ConnectorMetadata> CONNECTOR_METADATA_FIELD = SdkField
            .<ConnectorMetadata> builder(MarshallingType.SDK_POJO).memberName("connectorMetadata")
            .getter(getter(ConnectorConfiguration::connectorMetadata)).setter(setter(Builder::connectorMetadata))
            .constructor(ConnectorMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorMetadata").build()).build();

    private static final SdkField<String> CONNECTOR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorType").getter(getter(ConnectorConfiguration::connectorTypeAsString))
            .setter(setter(Builder::connectorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorType").build()).build();

    private static final SdkField<String> CONNECTOR_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorLabel").getter(getter(ConnectorConfiguration::connectorLabel))
            .setter(setter(Builder::connectorLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorLabel").build()).build();

    private static final SdkField<String> CONNECTOR_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorDescription").getter(getter(ConnectorConfiguration::connectorDescription))
            .setter(setter(Builder::connectorDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorDescription").build())
            .build();

    private static final SdkField<String> CONNECTOR_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorOwner").getter(getter(ConnectorConfiguration::connectorOwner))
            .setter(setter(Builder::connectorOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorOwner").build()).build();

    private static final SdkField<String> CONNECTOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorName").getter(getter(ConnectorConfiguration::connectorName))
            .setter(setter(Builder::connectorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorName").build()).build();

    private static final SdkField<String> CONNECTOR_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorVersion").getter(getter(ConnectorConfiguration::connectorVersion))
            .setter(setter(Builder::connectorVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorVersion").build()).build();

    private static final SdkField<String> CONNECTOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorArn").getter(getter(ConnectorConfiguration::connectorArn))
            .setter(setter(Builder::connectorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorArn").build()).build();

    private static final SdkField<List<String>> CONNECTOR_MODES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("connectorModes")
            .getter(getter(ConnectorConfiguration::connectorModes))
            .setter(setter(Builder::connectorModes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorModes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AuthenticationConfig> AUTHENTICATION_CONFIG_FIELD = SdkField
            .<AuthenticationConfig> builder(MarshallingType.SDK_POJO).memberName("authenticationConfig")
            .getter(getter(ConnectorConfiguration::authenticationConfig)).setter(setter(Builder::authenticationConfig))
            .constructor(AuthenticationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationConfig").build())
            .build();

    private static final SdkField<List<ConnectorRuntimeSetting>> CONNECTOR_RUNTIME_SETTINGS_FIELD = SdkField
            .<List<ConnectorRuntimeSetting>> builder(MarshallingType.LIST)
            .memberName("connectorRuntimeSettings")
            .getter(getter(ConnectorConfiguration::connectorRuntimeSettings))
            .setter(setter(Builder::connectorRuntimeSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorRuntimeSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConnectorRuntimeSetting> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConnectorRuntimeSetting::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUPPORTED_API_VERSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("supportedApiVersions")
            .getter(getter(ConnectorConfiguration::supportedApiVersions))
            .setter(setter(Builder::supportedApiVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedApiVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUPPORTED_OPERATORS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("supportedOperators")
            .getter(getter(ConnectorConfiguration::supportedOperatorsAsStrings))
            .setter(setter(Builder::supportedOperatorsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedOperators").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUPPORTED_WRITE_OPERATIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("supportedWriteOperations")
            .getter(getter(ConnectorConfiguration::supportedWriteOperationsAsStrings))
            .setter(setter(Builder::supportedWriteOperationsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedWriteOperations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CONNECTOR_PROVISIONING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorProvisioningType").getter(getter(ConnectorConfiguration::connectorProvisioningTypeAsString))
            .setter(setter(Builder::connectorProvisioningType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorProvisioningType").build())
            .build();

    private static final SdkField<ConnectorProvisioningConfig> CONNECTOR_PROVISIONING_CONFIG_FIELD = SdkField
            .<ConnectorProvisioningConfig> builder(MarshallingType.SDK_POJO)
            .memberName("connectorProvisioningConfig")
            .getter(getter(ConnectorConfiguration::connectorProvisioningConfig))
            .setter(setter(Builder::connectorProvisioningConfig))
            .constructor(ConnectorProvisioningConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorProvisioningConfig")
                    .build()).build();

    private static final SdkField<String> LOGO_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logoURL").getter(getter(ConnectorConfiguration::logoURL)).setter(setter(Builder::logoURL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logoURL").build()).build();

    private static final SdkField<Instant> REGISTERED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("registeredAt").getter(getter(ConnectorConfiguration::registeredAt))
            .setter(setter(Builder::registeredAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registeredAt").build()).build();

    private static final SdkField<String> REGISTERED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registeredBy").getter(getter(ConnectorConfiguration::registeredBy))
            .setter(setter(Builder::registeredBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registeredBy").build()).build();

    private static final SdkField<List<String>> SUPPORTED_DATA_TRANSFER_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("supportedDataTransferTypes")
            .getter(getter(ConnectorConfiguration::supportedDataTransferTypesAsStrings))
            .setter(setter(Builder::supportedDataTransferTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedDataTransferTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DataTransferApi>> SUPPORTED_DATA_TRANSFER_APIS_FIELD = SdkField
            .<List<DataTransferApi>> builder(MarshallingType.LIST)
            .memberName("supportedDataTransferApis")
            .getter(getter(ConnectorConfiguration::supportedDataTransferApis))
            .setter(setter(Builder::supportedDataTransferApis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedDataTransferApis").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataTransferApi> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataTransferApi::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAN_USE_AS_SOURCE_FIELD,
            CAN_USE_AS_DESTINATION_FIELD, SUPPORTED_DESTINATION_CONNECTORS_FIELD, SUPPORTED_SCHEDULING_FREQUENCIES_FIELD,
            IS_PRIVATE_LINK_ENABLED_FIELD, IS_PRIVATE_LINK_ENDPOINT_URL_REQUIRED_FIELD, SUPPORTED_TRIGGER_TYPES_FIELD,
            CONNECTOR_METADATA_FIELD, CONNECTOR_TYPE_FIELD, CONNECTOR_LABEL_FIELD, CONNECTOR_DESCRIPTION_FIELD,
            CONNECTOR_OWNER_FIELD, CONNECTOR_NAME_FIELD, CONNECTOR_VERSION_FIELD, CONNECTOR_ARN_FIELD, CONNECTOR_MODES_FIELD,
            AUTHENTICATION_CONFIG_FIELD, CONNECTOR_RUNTIME_SETTINGS_FIELD, SUPPORTED_API_VERSIONS_FIELD,
            SUPPORTED_OPERATORS_FIELD, SUPPORTED_WRITE_OPERATIONS_FIELD, CONNECTOR_PROVISIONING_TYPE_FIELD,
            CONNECTOR_PROVISIONING_CONFIG_FIELD, LOGO_URL_FIELD, REGISTERED_AT_FIELD, REGISTERED_BY_FIELD,
            SUPPORTED_DATA_TRANSFER_TYPES_FIELD, SUPPORTED_DATA_TRANSFER_APIS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean canUseAsSource;

    private final Boolean canUseAsDestination;

    private final List<String> supportedDestinationConnectors;

    private final List<String> supportedSchedulingFrequencies;

    private final Boolean isPrivateLinkEnabled;

    private final Boolean isPrivateLinkEndpointUrlRequired;

    private final List<String> supportedTriggerTypes;

    private final ConnectorMetadata connectorMetadata;

    private final String connectorType;

    private final String connectorLabel;

    private final String connectorDescription;

    private final String connectorOwner;

    private final String connectorName;

    private final String connectorVersion;

    private final String connectorArn;

    private final List<String> connectorModes;

    private final AuthenticationConfig authenticationConfig;

    private final List<ConnectorRuntimeSetting> connectorRuntimeSettings;

    private final List<String> supportedApiVersions;

    private final List<String> supportedOperators;

    private final List<String> supportedWriteOperations;

    private final String connectorProvisioningType;

    private final ConnectorProvisioningConfig connectorProvisioningConfig;

    private final String logoURL;

    private final Instant registeredAt;

    private final String registeredBy;

    private final List<String> supportedDataTransferTypes;

    private final List<DataTransferApi> supportedDataTransferApis;

    private ConnectorConfiguration(BuilderImpl builder) {
        this.canUseAsSource = builder.canUseAsSource;
        this.canUseAsDestination = builder.canUseAsDestination;
        this.supportedDestinationConnectors = builder.supportedDestinationConnectors;
        this.supportedSchedulingFrequencies = builder.supportedSchedulingFrequencies;
        this.isPrivateLinkEnabled = builder.isPrivateLinkEnabled;
        this.isPrivateLinkEndpointUrlRequired = builder.isPrivateLinkEndpointUrlRequired;
        this.supportedTriggerTypes = builder.supportedTriggerTypes;
        this.connectorMetadata = builder.connectorMetadata;
        this.connectorType = builder.connectorType;
        this.connectorLabel = builder.connectorLabel;
        this.connectorDescription = builder.connectorDescription;
        this.connectorOwner = builder.connectorOwner;
        this.connectorName = builder.connectorName;
        this.connectorVersion = builder.connectorVersion;
        this.connectorArn = builder.connectorArn;
        this.connectorModes = builder.connectorModes;
        this.authenticationConfig = builder.authenticationConfig;
        this.connectorRuntimeSettings = builder.connectorRuntimeSettings;
        this.supportedApiVersions = builder.supportedApiVersions;
        this.supportedOperators = builder.supportedOperators;
        this.supportedWriteOperations = builder.supportedWriteOperations;
        this.connectorProvisioningType = builder.connectorProvisioningType;
        this.connectorProvisioningConfig = builder.connectorProvisioningConfig;
        this.logoURL = builder.logoURL;
        this.registeredAt = builder.registeredAt;
        this.registeredBy = builder.registeredBy;
        this.supportedDataTransferTypes = builder.supportedDataTransferTypes;
        this.supportedDataTransferApis = builder.supportedDataTransferApis;
    }

    /**
     * <p>
     * Specifies whether the connector can be used as a source.
     * </p>
     * 
     * @return Specifies whether the connector can be used as a source.
     */
    public final Boolean canUseAsSource() {
        return canUseAsSource;
    }

    /**
     * <p>
     * Specifies whether the connector can be used as a destination.
     * </p>
     * 
     * @return Specifies whether the connector can be used as a destination.
     */
    public final Boolean canUseAsDestination() {
        return canUseAsDestination;
    }

    /**
     * <p>
     * Lists the connectors that are available for use as destinations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedDestinationConnectors} method.
     * </p>
     * 
     * @return Lists the connectors that are available for use as destinations.
     */
    public final List<ConnectorType> supportedDestinationConnectors() {
        return ConnectorTypeListCopier.copyStringToEnum(supportedDestinationConnectors);
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedDestinationConnectors property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSupportedDestinationConnectors() {
        return supportedDestinationConnectors != null && !(supportedDestinationConnectors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists the connectors that are available for use as destinations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedDestinationConnectors} method.
     * </p>
     * 
     * @return Lists the connectors that are available for use as destinations.
     */
    public final List<String> supportedDestinationConnectorsAsStrings() {
        return supportedDestinationConnectors;
    }

    /**
     * <p>
     * Specifies the supported flow frequency for that connector.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedSchedulingFrequencies} method.
     * </p>
     * 
     * @return Specifies the supported flow frequency for that connector.
     */
    public final List<ScheduleFrequencyType> supportedSchedulingFrequencies() {
        return SchedulingFrequencyTypeListCopier.copyStringToEnum(supportedSchedulingFrequencies);
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedSchedulingFrequencies property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSupportedSchedulingFrequencies() {
        return supportedSchedulingFrequencies != null && !(supportedSchedulingFrequencies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the supported flow frequency for that connector.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedSchedulingFrequencies} method.
     * </p>
     * 
     * @return Specifies the supported flow frequency for that connector.
     */
    public final List<String> supportedSchedulingFrequenciesAsStrings() {
        return supportedSchedulingFrequencies;
    }

    /**
     * <p>
     * Specifies if PrivateLink is enabled for that connector.
     * </p>
     * 
     * @return Specifies if PrivateLink is enabled for that connector.
     */
    public final Boolean isPrivateLinkEnabled() {
        return isPrivateLinkEnabled;
    }

    /**
     * <p>
     * Specifies if a PrivateLink endpoint URL is required.
     * </p>
     * 
     * @return Specifies if a PrivateLink endpoint URL is required.
     */
    public final Boolean isPrivateLinkEndpointUrlRequired() {
        return isPrivateLinkEndpointUrlRequired;
    }

    /**
     * <p>
     * Specifies the supported trigger types for the flow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedTriggerTypes} method.
     * </p>
     * 
     * @return Specifies the supported trigger types for the flow.
     */
    public final List<TriggerType> supportedTriggerTypes() {
        return TriggerTypeListCopier.copyStringToEnum(supportedTriggerTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedTriggerTypes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSupportedTriggerTypes() {
        return supportedTriggerTypes != null && !(supportedTriggerTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the supported trigger types for the flow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedTriggerTypes} method.
     * </p>
     * 
     * @return Specifies the supported trigger types for the flow.
     */
    public final List<String> supportedTriggerTypesAsStrings() {
        return supportedTriggerTypes;
    }

    /**
     * <p>
     * Specifies connector-specific metadata such as <code>oAuthScopes</code>, <code>supportedRegions</code>,
     * <code>privateLinkServiceUrl</code>, and so on.
     * </p>
     * 
     * @return Specifies connector-specific metadata such as <code>oAuthScopes</code>, <code>supportedRegions</code>,
     *         <code>privateLinkServiceUrl</code>, and so on.
     */
    public final ConnectorMetadata connectorMetadata() {
        return connectorMetadata;
    }

    /**
     * <p>
     * The connector type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectorType}
     * will return {@link ConnectorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #connectorTypeAsString}.
     * </p>
     * 
     * @return The connector type.
     * @see ConnectorType
     */
    public final ConnectorType connectorType() {
        return ConnectorType.fromValue(connectorType);
    }

    /**
     * <p>
     * The connector type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectorType}
     * will return {@link ConnectorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #connectorTypeAsString}.
     * </p>
     * 
     * @return The connector type.
     * @see ConnectorType
     */
    public final String connectorTypeAsString() {
        return connectorType;
    }

    /**
     * <p>
     * The label used for registering the connector.
     * </p>
     * 
     * @return The label used for registering the connector.
     */
    public final String connectorLabel() {
        return connectorLabel;
    }

    /**
     * <p>
     * A description about the connector.
     * </p>
     * 
     * @return A description about the connector.
     */
    public final String connectorDescription() {
        return connectorDescription;
    }

    /**
     * <p>
     * The owner who developed the connector.
     * </p>
     * 
     * @return The owner who developed the connector.
     */
    public final String connectorOwner() {
        return connectorOwner;
    }

    /**
     * <p>
     * The connector name.
     * </p>
     * 
     * @return The connector name.
     */
    public final String connectorName() {
        return connectorName;
    }

    /**
     * <p>
     * The connector version.
     * </p>
     * 
     * @return The connector version.
     */
    public final String connectorVersion() {
        return connectorVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the registered connector.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the registered connector.
     */
    public final String connectorArn() {
        return connectorArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConnectorModes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConnectorModes() {
        return connectorModes != null && !(connectorModes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The connection modes that the connector supports.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConnectorModes} method.
     * </p>
     * 
     * @return The connection modes that the connector supports.
     */
    public final List<String> connectorModes() {
        return connectorModes;
    }

    /**
     * <p>
     * The authentication config required for the connector.
     * </p>
     * 
     * @return The authentication config required for the connector.
     */
    public final AuthenticationConfig authenticationConfig() {
        return authenticationConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConnectorRuntimeSettings property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasConnectorRuntimeSettings() {
        return connectorRuntimeSettings != null && !(connectorRuntimeSettings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The required connector runtime settings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConnectorRuntimeSettings} method.
     * </p>
     * 
     * @return The required connector runtime settings.
     */
    public final List<ConnectorRuntimeSetting> connectorRuntimeSettings() {
        return connectorRuntimeSettings;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedApiVersions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSupportedApiVersions() {
        return supportedApiVersions != null && !(supportedApiVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of API versions that are supported by the connector.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedApiVersions} method.
     * </p>
     * 
     * @return A list of API versions that are supported by the connector.
     */
    public final List<String> supportedApiVersions() {
        return supportedApiVersions;
    }

    /**
     * <p>
     * A list of operators supported by the connector.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedOperators} method.
     * </p>
     * 
     * @return A list of operators supported by the connector.
     */
    public final List<Operators> supportedOperators() {
        return SupportedOperatorListCopier.copyStringToEnum(supportedOperators);
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedOperators property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSupportedOperators() {
        return supportedOperators != null && !(supportedOperators instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of operators supported by the connector.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedOperators} method.
     * </p>
     * 
     * @return A list of operators supported by the connector.
     */
    public final List<String> supportedOperatorsAsStrings() {
        return supportedOperators;
    }

    /**
     * <p>
     * A list of write operations supported by the connector.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedWriteOperations} method.
     * </p>
     * 
     * @return A list of write operations supported by the connector.
     */
    public final List<WriteOperationType> supportedWriteOperations() {
        return SupportedWriteOperationListCopier.copyStringToEnum(supportedWriteOperations);
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedWriteOperations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSupportedWriteOperations() {
        return supportedWriteOperations != null && !(supportedWriteOperations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of write operations supported by the connector.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedWriteOperations} method.
     * </p>
     * 
     * @return A list of write operations supported by the connector.
     */
    public final List<String> supportedWriteOperationsAsStrings() {
        return supportedWriteOperations;
    }

    /**
     * <p>
     * The provisioning type used to register the connector.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #connectorProvisioningType} will return {@link ConnectorProvisioningType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #connectorProvisioningTypeAsString}.
     * </p>
     * 
     * @return The provisioning type used to register the connector.
     * @see ConnectorProvisioningType
     */
    public final ConnectorProvisioningType connectorProvisioningType() {
        return ConnectorProvisioningType.fromValue(connectorProvisioningType);
    }

    /**
     * <p>
     * The provisioning type used to register the connector.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #connectorProvisioningType} will return {@link ConnectorProvisioningType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #connectorProvisioningTypeAsString}.
     * </p>
     * 
     * @return The provisioning type used to register the connector.
     * @see ConnectorProvisioningType
     */
    public final String connectorProvisioningTypeAsString() {
        return connectorProvisioningType;
    }

    /**
     * <p>
     * The configuration required for registering the connector.
     * </p>
     * 
     * @return The configuration required for registering the connector.
     */
    public final ConnectorProvisioningConfig connectorProvisioningConfig() {
        return connectorProvisioningConfig;
    }

    /**
     * <p>
     * Logo URL of the connector.
     * </p>
     * 
     * @return Logo URL of the connector.
     */
    public final String logoURL() {
        return logoURL;
    }

    /**
     * <p>
     * The date on which the connector was registered.
     * </p>
     * 
     * @return The date on which the connector was registered.
     */
    public final Instant registeredAt() {
        return registeredAt;
    }

    /**
     * <p>
     * Information about who registered the connector.
     * </p>
     * 
     * @return Information about who registered the connector.
     */
    public final String registeredBy() {
        return registeredBy;
    }

    /**
     * <p>
     * The data transfer types that the connector supports.
     * </p>
     * <dl>
     * <dt>RECORD</dt>
     * <dd>
     * <p>
     * Structured records.
     * </p>
     * </dd>
     * <dt>FILE</dt>
     * <dd>
     * <p>
     * Files or binary data.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedDataTransferTypes} method.
     * </p>
     * 
     * @return The data transfer types that the connector supports.</p>
     *         <dl>
     *         <dt>RECORD</dt>
     *         <dd>
     *         <p>
     *         Structured records.
     *         </p>
     *         </dd>
     *         <dt>FILE</dt>
     *         <dd>
     *         <p>
     *         Files or binary data.
     *         </p>
     *         </dd>
     */
    public final List<SupportedDataTransferType> supportedDataTransferTypes() {
        return SupportedDataTransferTypeListCopier.copyStringToEnum(supportedDataTransferTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedDataTransferTypes property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSupportedDataTransferTypes() {
        return supportedDataTransferTypes != null && !(supportedDataTransferTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data transfer types that the connector supports.
     * </p>
     * <dl>
     * <dt>RECORD</dt>
     * <dd>
     * <p>
     * Structured records.
     * </p>
     * </dd>
     * <dt>FILE</dt>
     * <dd>
     * <p>
     * Files or binary data.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedDataTransferTypes} method.
     * </p>
     * 
     * @return The data transfer types that the connector supports.</p>
     *         <dl>
     *         <dt>RECORD</dt>
     *         <dd>
     *         <p>
     *         Structured records.
     *         </p>
     *         </dd>
     *         <dt>FILE</dt>
     *         <dd>
     *         <p>
     *         Files or binary data.
     *         </p>
     *         </dd>
     */
    public final List<String> supportedDataTransferTypesAsStrings() {
        return supportedDataTransferTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedDataTransferApis property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSupportedDataTransferApis() {
        return supportedDataTransferApis != null && !(supportedDataTransferApis instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The APIs of the connector application that Amazon AppFlow can use to transfer your data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedDataTransferApis} method.
     * </p>
     * 
     * @return The APIs of the connector application that Amazon AppFlow can use to transfer your data.
     */
    public final List<DataTransferApi> supportedDataTransferApis() {
        return supportedDataTransferApis;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(canUseAsSource());
        hashCode = 31 * hashCode + Objects.hashCode(canUseAsDestination());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasSupportedDestinationConnectors() ? supportedDestinationConnectorsAsStrings() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasSupportedSchedulingFrequencies() ? supportedSchedulingFrequenciesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isPrivateLinkEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(isPrivateLinkEndpointUrlRequired());
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedTriggerTypes() ? supportedTriggerTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(connectorMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(connectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(connectorLabel());
        hashCode = 31 * hashCode + Objects.hashCode(connectorDescription());
        hashCode = 31 * hashCode + Objects.hashCode(connectorOwner());
        hashCode = 31 * hashCode + Objects.hashCode(connectorName());
        hashCode = 31 * hashCode + Objects.hashCode(connectorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(connectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasConnectorModes() ? connectorModes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(authenticationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasConnectorRuntimeSettings() ? connectorRuntimeSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedApiVersions() ? supportedApiVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedOperators() ? supportedOperatorsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedWriteOperations() ? supportedWriteOperationsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(connectorProvisioningTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(connectorProvisioningConfig());
        hashCode = 31 * hashCode + Objects.hashCode(logoURL());
        hashCode = 31 * hashCode + Objects.hashCode(registeredAt());
        hashCode = 31 * hashCode + Objects.hashCode(registeredBy());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasSupportedDataTransferTypes() ? supportedDataTransferTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedDataTransferApis() ? supportedDataTransferApis() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorConfiguration)) {
            return false;
        }
        ConnectorConfiguration other = (ConnectorConfiguration) obj;
        return Objects.equals(canUseAsSource(), other.canUseAsSource())
                && Objects.equals(canUseAsDestination(), other.canUseAsDestination())
                && hasSupportedDestinationConnectors() == other.hasSupportedDestinationConnectors()
                && Objects.equals(supportedDestinationConnectorsAsStrings(), other.supportedDestinationConnectorsAsStrings())
                && hasSupportedSchedulingFrequencies() == other.hasSupportedSchedulingFrequencies()
                && Objects.equals(supportedSchedulingFrequenciesAsStrings(), other.supportedSchedulingFrequenciesAsStrings())
                && Objects.equals(isPrivateLinkEnabled(), other.isPrivateLinkEnabled())
                && Objects.equals(isPrivateLinkEndpointUrlRequired(), other.isPrivateLinkEndpointUrlRequired())
                && hasSupportedTriggerTypes() == other.hasSupportedTriggerTypes()
                && Objects.equals(supportedTriggerTypesAsStrings(), other.supportedTriggerTypesAsStrings())
                && Objects.equals(connectorMetadata(), other.connectorMetadata())
                && Objects.equals(connectorTypeAsString(), other.connectorTypeAsString())
                && Objects.equals(connectorLabel(), other.connectorLabel())
                && Objects.equals(connectorDescription(), other.connectorDescription())
                && Objects.equals(connectorOwner(), other.connectorOwner())
                && Objects.equals(connectorName(), other.connectorName())
                && Objects.equals(connectorVersion(), other.connectorVersion())
                && Objects.equals(connectorArn(), other.connectorArn()) && hasConnectorModes() == other.hasConnectorModes()
                && Objects.equals(connectorModes(), other.connectorModes())
                && Objects.equals(authenticationConfig(), other.authenticationConfig())
                && hasConnectorRuntimeSettings() == other.hasConnectorRuntimeSettings()
                && Objects.equals(connectorRuntimeSettings(), other.connectorRuntimeSettings())
                && hasSupportedApiVersions() == other.hasSupportedApiVersions()
                && Objects.equals(supportedApiVersions(), other.supportedApiVersions())
                && hasSupportedOperators() == other.hasSupportedOperators()
                && Objects.equals(supportedOperatorsAsStrings(), other.supportedOperatorsAsStrings())
                && hasSupportedWriteOperations() == other.hasSupportedWriteOperations()
                && Objects.equals(supportedWriteOperationsAsStrings(), other.supportedWriteOperationsAsStrings())
                && Objects.equals(connectorProvisioningTypeAsString(), other.connectorProvisioningTypeAsString())
                && Objects.equals(connectorProvisioningConfig(), other.connectorProvisioningConfig())
                && Objects.equals(logoURL(), other.logoURL()) && Objects.equals(registeredAt(), other.registeredAt())
                && Objects.equals(registeredBy(), other.registeredBy())
                && hasSupportedDataTransferTypes() == other.hasSupportedDataTransferTypes()
                && Objects.equals(supportedDataTransferTypesAsStrings(), other.supportedDataTransferTypesAsStrings())
                && hasSupportedDataTransferApis() == other.hasSupportedDataTransferApis()
                && Objects.equals(supportedDataTransferApis(), other.supportedDataTransferApis());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ConnectorConfiguration")
                .add("CanUseAsSource", canUseAsSource())
                .add("CanUseAsDestination", canUseAsDestination())
                .add("SupportedDestinationConnectors",
                        hasSupportedDestinationConnectors() ? supportedDestinationConnectorsAsStrings() : null)
                .add("SupportedSchedulingFrequencies",
                        hasSupportedSchedulingFrequencies() ? supportedSchedulingFrequenciesAsStrings() : null)
                .add("IsPrivateLinkEnabled", isPrivateLinkEnabled())
                .add("IsPrivateLinkEndpointUrlRequired", isPrivateLinkEndpointUrlRequired())
                .add("SupportedTriggerTypes", hasSupportedTriggerTypes() ? supportedTriggerTypesAsStrings() : null)
                .add("ConnectorMetadata", connectorMetadata())
                .add("ConnectorType", connectorTypeAsString())
                .add("ConnectorLabel", connectorLabel())
                .add("ConnectorDescription", connectorDescription())
                .add("ConnectorOwner", connectorOwner())
                .add("ConnectorName", connectorName())
                .add("ConnectorVersion", connectorVersion())
                .add("ConnectorArn", connectorArn())
                .add("ConnectorModes", hasConnectorModes() ? connectorModes() : null)
                .add("AuthenticationConfig", authenticationConfig())
                .add("ConnectorRuntimeSettings", hasConnectorRuntimeSettings() ? connectorRuntimeSettings() : null)
                .add("SupportedApiVersions", hasSupportedApiVersions() ? supportedApiVersions() : null)
                .add("SupportedOperators", hasSupportedOperators() ? supportedOperatorsAsStrings() : null)
                .add("SupportedWriteOperations", hasSupportedWriteOperations() ? supportedWriteOperationsAsStrings() : null)
                .add("ConnectorProvisioningType", connectorProvisioningTypeAsString())
                .add("ConnectorProvisioningConfig", connectorProvisioningConfig())
                .add("LogoURL", logoURL())
                .add("RegisteredAt", registeredAt())
                .add("RegisteredBy", registeredBy())
                .add("SupportedDataTransferTypes", hasSupportedDataTransferTypes() ? supportedDataTransferTypesAsStrings() : null)
                .add("SupportedDataTransferApis", hasSupportedDataTransferApis() ? supportedDataTransferApis() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "canUseAsSource":
            return Optional.ofNullable(clazz.cast(canUseAsSource()));
        case "canUseAsDestination":
            return Optional.ofNullable(clazz.cast(canUseAsDestination()));
        case "supportedDestinationConnectors":
            return Optional.ofNullable(clazz.cast(supportedDestinationConnectorsAsStrings()));
        case "supportedSchedulingFrequencies":
            return Optional.ofNullable(clazz.cast(supportedSchedulingFrequenciesAsStrings()));
        case "isPrivateLinkEnabled":
            return Optional.ofNullable(clazz.cast(isPrivateLinkEnabled()));
        case "isPrivateLinkEndpointUrlRequired":
            return Optional.ofNullable(clazz.cast(isPrivateLinkEndpointUrlRequired()));
        case "supportedTriggerTypes":
            return Optional.ofNullable(clazz.cast(supportedTriggerTypesAsStrings()));
        case "connectorMetadata":
            return Optional.ofNullable(clazz.cast(connectorMetadata()));
        case "connectorType":
            return Optional.ofNullable(clazz.cast(connectorTypeAsString()));
        case "connectorLabel":
            return Optional.ofNullable(clazz.cast(connectorLabel()));
        case "connectorDescription":
            return Optional.ofNullable(clazz.cast(connectorDescription()));
        case "connectorOwner":
            return Optional.ofNullable(clazz.cast(connectorOwner()));
        case "connectorName":
            return Optional.ofNullable(clazz.cast(connectorName()));
        case "connectorVersion":
            return Optional.ofNullable(clazz.cast(connectorVersion()));
        case "connectorArn":
            return Optional.ofNullable(clazz.cast(connectorArn()));
        case "connectorModes":
            return Optional.ofNullable(clazz.cast(connectorModes()));
        case "authenticationConfig":
            return Optional.ofNullable(clazz.cast(authenticationConfig()));
        case "connectorRuntimeSettings":
            return Optional.ofNullable(clazz.cast(connectorRuntimeSettings()));
        case "supportedApiVersions":
            return Optional.ofNullable(clazz.cast(supportedApiVersions()));
        case "supportedOperators":
            return Optional.ofNullable(clazz.cast(supportedOperatorsAsStrings()));
        case "supportedWriteOperations":
            return Optional.ofNullable(clazz.cast(supportedWriteOperationsAsStrings()));
        case "connectorProvisioningType":
            return Optional.ofNullable(clazz.cast(connectorProvisioningTypeAsString()));
        case "connectorProvisioningConfig":
            return Optional.ofNullable(clazz.cast(connectorProvisioningConfig()));
        case "logoURL":
            return Optional.ofNullable(clazz.cast(logoURL()));
        case "registeredAt":
            return Optional.ofNullable(clazz.cast(registeredAt()));
        case "registeredBy":
            return Optional.ofNullable(clazz.cast(registeredBy()));
        case "supportedDataTransferTypes":
            return Optional.ofNullable(clazz.cast(supportedDataTransferTypesAsStrings()));
        case "supportedDataTransferApis":
            return Optional.ofNullable(clazz.cast(supportedDataTransferApis()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("canUseAsSource", CAN_USE_AS_SOURCE_FIELD);
        map.put("canUseAsDestination", CAN_USE_AS_DESTINATION_FIELD);
        map.put("supportedDestinationConnectors", SUPPORTED_DESTINATION_CONNECTORS_FIELD);
        map.put("supportedSchedulingFrequencies", SUPPORTED_SCHEDULING_FREQUENCIES_FIELD);
        map.put("isPrivateLinkEnabled", IS_PRIVATE_LINK_ENABLED_FIELD);
        map.put("isPrivateLinkEndpointUrlRequired", IS_PRIVATE_LINK_ENDPOINT_URL_REQUIRED_FIELD);
        map.put("supportedTriggerTypes", SUPPORTED_TRIGGER_TYPES_FIELD);
        map.put("connectorMetadata", CONNECTOR_METADATA_FIELD);
        map.put("connectorType", CONNECTOR_TYPE_FIELD);
        map.put("connectorLabel", CONNECTOR_LABEL_FIELD);
        map.put("connectorDescription", CONNECTOR_DESCRIPTION_FIELD);
        map.put("connectorOwner", CONNECTOR_OWNER_FIELD);
        map.put("connectorName", CONNECTOR_NAME_FIELD);
        map.put("connectorVersion", CONNECTOR_VERSION_FIELD);
        map.put("connectorArn", CONNECTOR_ARN_FIELD);
        map.put("connectorModes", CONNECTOR_MODES_FIELD);
        map.put("authenticationConfig", AUTHENTICATION_CONFIG_FIELD);
        map.put("connectorRuntimeSettings", CONNECTOR_RUNTIME_SETTINGS_FIELD);
        map.put("supportedApiVersions", SUPPORTED_API_VERSIONS_FIELD);
        map.put("supportedOperators", SUPPORTED_OPERATORS_FIELD);
        map.put("supportedWriteOperations", SUPPORTED_WRITE_OPERATIONS_FIELD);
        map.put("connectorProvisioningType", CONNECTOR_PROVISIONING_TYPE_FIELD);
        map.put("connectorProvisioningConfig", CONNECTOR_PROVISIONING_CONFIG_FIELD);
        map.put("logoURL", LOGO_URL_FIELD);
        map.put("registeredAt", REGISTERED_AT_FIELD);
        map.put("registeredBy", REGISTERED_BY_FIELD);
        map.put("supportedDataTransferTypes", SUPPORTED_DATA_TRANSFER_TYPES_FIELD);
        map.put("supportedDataTransferApis", SUPPORTED_DATA_TRANSFER_APIS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectorConfiguration, T> g) {
        return obj -> g.apply((ConnectorConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectorConfiguration> {
        /**
         * <p>
         * Specifies whether the connector can be used as a source.
         * </p>
         * 
         * @param canUseAsSource
         *        Specifies whether the connector can be used as a source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canUseAsSource(Boolean canUseAsSource);

        /**
         * <p>
         * Specifies whether the connector can be used as a destination.
         * </p>
         * 
         * @param canUseAsDestination
         *        Specifies whether the connector can be used as a destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canUseAsDestination(Boolean canUseAsDestination);

        /**
         * <p>
         * Lists the connectors that are available for use as destinations.
         * </p>
         * 
         * @param supportedDestinationConnectors
         *        Lists the connectors that are available for use as destinations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedDestinationConnectorsWithStrings(Collection<String> supportedDestinationConnectors);

        /**
         * <p>
         * Lists the connectors that are available for use as destinations.
         * </p>
         * 
         * @param supportedDestinationConnectors
         *        Lists the connectors that are available for use as destinations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedDestinationConnectorsWithStrings(String... supportedDestinationConnectors);

        /**
         * <p>
         * Lists the connectors that are available for use as destinations.
         * </p>
         * 
         * @param supportedDestinationConnectors
         *        Lists the connectors that are available for use as destinations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedDestinationConnectors(Collection<ConnectorType> supportedDestinationConnectors);

        /**
         * <p>
         * Lists the connectors that are available for use as destinations.
         * </p>
         * 
         * @param supportedDestinationConnectors
         *        Lists the connectors that are available for use as destinations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedDestinationConnectors(ConnectorType... supportedDestinationConnectors);

        /**
         * <p>
         * Specifies the supported flow frequency for that connector.
         * </p>
         * 
         * @param supportedSchedulingFrequencies
         *        Specifies the supported flow frequency for that connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedSchedulingFrequenciesWithStrings(Collection<String> supportedSchedulingFrequencies);

        /**
         * <p>
         * Specifies the supported flow frequency for that connector.
         * </p>
         * 
         * @param supportedSchedulingFrequencies
         *        Specifies the supported flow frequency for that connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedSchedulingFrequenciesWithStrings(String... supportedSchedulingFrequencies);

        /**
         * <p>
         * Specifies the supported flow frequency for that connector.
         * </p>
         * 
         * @param supportedSchedulingFrequencies
         *        Specifies the supported flow frequency for that connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedSchedulingFrequencies(Collection<ScheduleFrequencyType> supportedSchedulingFrequencies);

        /**
         * <p>
         * Specifies the supported flow frequency for that connector.
         * </p>
         * 
         * @param supportedSchedulingFrequencies
         *        Specifies the supported flow frequency for that connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedSchedulingFrequencies(ScheduleFrequencyType... supportedSchedulingFrequencies);

        /**
         * <p>
         * Specifies if PrivateLink is enabled for that connector.
         * </p>
         * 
         * @param isPrivateLinkEnabled
         *        Specifies if PrivateLink is enabled for that connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isPrivateLinkEnabled(Boolean isPrivateLinkEnabled);

        /**
         * <p>
         * Specifies if a PrivateLink endpoint URL is required.
         * </p>
         * 
         * @param isPrivateLinkEndpointUrlRequired
         *        Specifies if a PrivateLink endpoint URL is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isPrivateLinkEndpointUrlRequired(Boolean isPrivateLinkEndpointUrlRequired);

        /**
         * <p>
         * Specifies the supported trigger types for the flow.
         * </p>
         * 
         * @param supportedTriggerTypes
         *        Specifies the supported trigger types for the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedTriggerTypesWithStrings(Collection<String> supportedTriggerTypes);

        /**
         * <p>
         * Specifies the supported trigger types for the flow.
         * </p>
         * 
         * @param supportedTriggerTypes
         *        Specifies the supported trigger types for the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedTriggerTypesWithStrings(String... supportedTriggerTypes);

        /**
         * <p>
         * Specifies the supported trigger types for the flow.
         * </p>
         * 
         * @param supportedTriggerTypes
         *        Specifies the supported trigger types for the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedTriggerTypes(Collection<TriggerType> supportedTriggerTypes);

        /**
         * <p>
         * Specifies the supported trigger types for the flow.
         * </p>
         * 
         * @param supportedTriggerTypes
         *        Specifies the supported trigger types for the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedTriggerTypes(TriggerType... supportedTriggerTypes);

        /**
         * <p>
         * Specifies connector-specific metadata such as <code>oAuthScopes</code>, <code>supportedRegions</code>,
         * <code>privateLinkServiceUrl</code>, and so on.
         * </p>
         * 
         * @param connectorMetadata
         *        Specifies connector-specific metadata such as <code>oAuthScopes</code>, <code>supportedRegions</code>,
         *        <code>privateLinkServiceUrl</code>, and so on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorMetadata(ConnectorMetadata connectorMetadata);

        /**
         * <p>
         * Specifies connector-specific metadata such as <code>oAuthScopes</code>, <code>supportedRegions</code>,
         * <code>privateLinkServiceUrl</code>, and so on.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConnectorMetadata.Builder} avoiding the
         * need to create one manually via {@link ConnectorMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectorMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #connectorMetadata(ConnectorMetadata)}.
         * 
         * @param connectorMetadata
         *        a consumer that will call methods on {@link ConnectorMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectorMetadata(ConnectorMetadata)
         */
        default Builder connectorMetadata(Consumer<ConnectorMetadata.Builder> connectorMetadata) {
            return connectorMetadata(ConnectorMetadata.builder().applyMutation(connectorMetadata).build());
        }

        /**
         * <p>
         * The connector type.
         * </p>
         * 
         * @param connectorType
         *        The connector type.
         * @see ConnectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorType
         */
        Builder connectorType(String connectorType);

        /**
         * <p>
         * The connector type.
         * </p>
         * 
         * @param connectorType
         *        The connector type.
         * @see ConnectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorType
         */
        Builder connectorType(ConnectorType connectorType);

        /**
         * <p>
         * The label used for registering the connector.
         * </p>
         * 
         * @param connectorLabel
         *        The label used for registering the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorLabel(String connectorLabel);

        /**
         * <p>
         * A description about the connector.
         * </p>
         * 
         * @param connectorDescription
         *        A description about the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorDescription(String connectorDescription);

        /**
         * <p>
         * The owner who developed the connector.
         * </p>
         * 
         * @param connectorOwner
         *        The owner who developed the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorOwner(String connectorOwner);

        /**
         * <p>
         * The connector name.
         * </p>
         * 
         * @param connectorName
         *        The connector name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorName(String connectorName);

        /**
         * <p>
         * The connector version.
         * </p>
         * 
         * @param connectorVersion
         *        The connector version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorVersion(String connectorVersion);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the registered connector.
         * </p>
         * 
         * @param connectorArn
         *        The Amazon Resource Name (ARN) for the registered connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorArn(String connectorArn);

        /**
         * <p>
         * The connection modes that the connector supports.
         * </p>
         * 
         * @param connectorModes
         *        The connection modes that the connector supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorModes(Collection<String> connectorModes);

        /**
         * <p>
         * The connection modes that the connector supports.
         * </p>
         * 
         * @param connectorModes
         *        The connection modes that the connector supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorModes(String... connectorModes);

        /**
         * <p>
         * The authentication config required for the connector.
         * </p>
         * 
         * @param authenticationConfig
         *        The authentication config required for the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationConfig(AuthenticationConfig authenticationConfig);

        /**
         * <p>
         * The authentication config required for the connector.
         * </p>
         * This is a convenience method that creates an instance of the {@link AuthenticationConfig.Builder} avoiding
         * the need to create one manually via {@link AuthenticationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AuthenticationConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #authenticationConfig(AuthenticationConfig)}.
         * 
         * @param authenticationConfig
         *        a consumer that will call methods on {@link AuthenticationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authenticationConfig(AuthenticationConfig)
         */
        default Builder authenticationConfig(Consumer<AuthenticationConfig.Builder> authenticationConfig) {
            return authenticationConfig(AuthenticationConfig.builder().applyMutation(authenticationConfig).build());
        }

        /**
         * <p>
         * The required connector runtime settings.
         * </p>
         * 
         * @param connectorRuntimeSettings
         *        The required connector runtime settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorRuntimeSettings(Collection<ConnectorRuntimeSetting> connectorRuntimeSettings);

        /**
         * <p>
         * The required connector runtime settings.
         * </p>
         * 
         * @param connectorRuntimeSettings
         *        The required connector runtime settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorRuntimeSettings(ConnectorRuntimeSetting... connectorRuntimeSettings);

        /**
         * <p>
         * The required connector runtime settings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.appflow.model.ConnectorRuntimeSetting.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.appflow.model.ConnectorRuntimeSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.appflow.model.ConnectorRuntimeSetting.Builder#build()} is called
         * immediately and its result is passed to {@link #connectorRuntimeSettings(List<ConnectorRuntimeSetting>)}.
         * 
         * @param connectorRuntimeSettings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.appflow.model.ConnectorRuntimeSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectorRuntimeSettings(java.util.Collection<ConnectorRuntimeSetting>)
         */
        Builder connectorRuntimeSettings(Consumer<ConnectorRuntimeSetting.Builder>... connectorRuntimeSettings);

        /**
         * <p>
         * A list of API versions that are supported by the connector.
         * </p>
         * 
         * @param supportedApiVersions
         *        A list of API versions that are supported by the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedApiVersions(Collection<String> supportedApiVersions);

        /**
         * <p>
         * A list of API versions that are supported by the connector.
         * </p>
         * 
         * @param supportedApiVersions
         *        A list of API versions that are supported by the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedApiVersions(String... supportedApiVersions);

        /**
         * <p>
         * A list of operators supported by the connector.
         * </p>
         * 
         * @param supportedOperators
         *        A list of operators supported by the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedOperatorsWithStrings(Collection<String> supportedOperators);

        /**
         * <p>
         * A list of operators supported by the connector.
         * </p>
         * 
         * @param supportedOperators
         *        A list of operators supported by the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedOperatorsWithStrings(String... supportedOperators);

        /**
         * <p>
         * A list of operators supported by the connector.
         * </p>
         * 
         * @param supportedOperators
         *        A list of operators supported by the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedOperators(Collection<Operators> supportedOperators);

        /**
         * <p>
         * A list of operators supported by the connector.
         * </p>
         * 
         * @param supportedOperators
         *        A list of operators supported by the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedOperators(Operators... supportedOperators);

        /**
         * <p>
         * A list of write operations supported by the connector.
         * </p>
         * 
         * @param supportedWriteOperations
         *        A list of write operations supported by the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedWriteOperationsWithStrings(Collection<String> supportedWriteOperations);

        /**
         * <p>
         * A list of write operations supported by the connector.
         * </p>
         * 
         * @param supportedWriteOperations
         *        A list of write operations supported by the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedWriteOperationsWithStrings(String... supportedWriteOperations);

        /**
         * <p>
         * A list of write operations supported by the connector.
         * </p>
         * 
         * @param supportedWriteOperations
         *        A list of write operations supported by the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedWriteOperations(Collection<WriteOperationType> supportedWriteOperations);

        /**
         * <p>
         * A list of write operations supported by the connector.
         * </p>
         * 
         * @param supportedWriteOperations
         *        A list of write operations supported by the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedWriteOperations(WriteOperationType... supportedWriteOperations);

        /**
         * <p>
         * The provisioning type used to register the connector.
         * </p>
         * 
         * @param connectorProvisioningType
         *        The provisioning type used to register the connector.
         * @see ConnectorProvisioningType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorProvisioningType
         */
        Builder connectorProvisioningType(String connectorProvisioningType);

        /**
         * <p>
         * The provisioning type used to register the connector.
         * </p>
         * 
         * @param connectorProvisioningType
         *        The provisioning type used to register the connector.
         * @see ConnectorProvisioningType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorProvisioningType
         */
        Builder connectorProvisioningType(ConnectorProvisioningType connectorProvisioningType);

        /**
         * <p>
         * The configuration required for registering the connector.
         * </p>
         * 
         * @param connectorProvisioningConfig
         *        The configuration required for registering the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorProvisioningConfig(ConnectorProvisioningConfig connectorProvisioningConfig);

        /**
         * <p>
         * The configuration required for registering the connector.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConnectorProvisioningConfig.Builder}
         * avoiding the need to create one manually via {@link ConnectorProvisioningConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectorProvisioningConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #connectorProvisioningConfig(ConnectorProvisioningConfig)}.
         * 
         * @param connectorProvisioningConfig
         *        a consumer that will call methods on {@link ConnectorProvisioningConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectorProvisioningConfig(ConnectorProvisioningConfig)
         */
        default Builder connectorProvisioningConfig(Consumer<ConnectorProvisioningConfig.Builder> connectorProvisioningConfig) {
            return connectorProvisioningConfig(ConnectorProvisioningConfig.builder().applyMutation(connectorProvisioningConfig)
                    .build());
        }

        /**
         * <p>
         * Logo URL of the connector.
         * </p>
         * 
         * @param logoURL
         *        Logo URL of the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logoURL(String logoURL);

        /**
         * <p>
         * The date on which the connector was registered.
         * </p>
         * 
         * @param registeredAt
         *        The date on which the connector was registered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registeredAt(Instant registeredAt);

        /**
         * <p>
         * Information about who registered the connector.
         * </p>
         * 
         * @param registeredBy
         *        Information about who registered the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registeredBy(String registeredBy);

        /**
         * <p>
         * The data transfer types that the connector supports.
         * </p>
         * <dl>
         * <dt>RECORD</dt>
         * <dd>
         * <p>
         * Structured records.
         * </p>
         * </dd>
         * <dt>FILE</dt>
         * <dd>
         * <p>
         * Files or binary data.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param supportedDataTransferTypes
         *        The data transfer types that the connector supports.</p>
         *        <dl>
         *        <dt>RECORD</dt>
         *        <dd>
         *        <p>
         *        Structured records.
         *        </p>
         *        </dd>
         *        <dt>FILE</dt>
         *        <dd>
         *        <p>
         *        Files or binary data.
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedDataTransferTypesWithStrings(Collection<String> supportedDataTransferTypes);

        /**
         * <p>
         * The data transfer types that the connector supports.
         * </p>
         * <dl>
         * <dt>RECORD</dt>
         * <dd>
         * <p>
         * Structured records.
         * </p>
         * </dd>
         * <dt>FILE</dt>
         * <dd>
         * <p>
         * Files or binary data.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param supportedDataTransferTypes
         *        The data transfer types that the connector supports.</p>
         *        <dl>
         *        <dt>RECORD</dt>
         *        <dd>
         *        <p>
         *        Structured records.
         *        </p>
         *        </dd>
         *        <dt>FILE</dt>
         *        <dd>
         *        <p>
         *        Files or binary data.
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedDataTransferTypesWithStrings(String... supportedDataTransferTypes);

        /**
         * <p>
         * The data transfer types that the connector supports.
         * </p>
         * <dl>
         * <dt>RECORD</dt>
         * <dd>
         * <p>
         * Structured records.
         * </p>
         * </dd>
         * <dt>FILE</dt>
         * <dd>
         * <p>
         * Files or binary data.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param supportedDataTransferTypes
         *        The data transfer types that the connector supports.</p>
         *        <dl>
         *        <dt>RECORD</dt>
         *        <dd>
         *        <p>
         *        Structured records.
         *        </p>
         *        </dd>
         *        <dt>FILE</dt>
         *        <dd>
         *        <p>
         *        Files or binary data.
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedDataTransferTypes(Collection<SupportedDataTransferType> supportedDataTransferTypes);

        /**
         * <p>
         * The data transfer types that the connector supports.
         * </p>
         * <dl>
         * <dt>RECORD</dt>
         * <dd>
         * <p>
         * Structured records.
         * </p>
         * </dd>
         * <dt>FILE</dt>
         * <dd>
         * <p>
         * Files or binary data.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param supportedDataTransferTypes
         *        The data transfer types that the connector supports.</p>
         *        <dl>
         *        <dt>RECORD</dt>
         *        <dd>
         *        <p>
         *        Structured records.
         *        </p>
         *        </dd>
         *        <dt>FILE</dt>
         *        <dd>
         *        <p>
         *        Files or binary data.
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedDataTransferTypes(SupportedDataTransferType... supportedDataTransferTypes);

        /**
         * <p>
         * The APIs of the connector application that Amazon AppFlow can use to transfer your data.
         * </p>
         * 
         * @param supportedDataTransferApis
         *        The APIs of the connector application that Amazon AppFlow can use to transfer your data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedDataTransferApis(Collection<DataTransferApi> supportedDataTransferApis);

        /**
         * <p>
         * The APIs of the connector application that Amazon AppFlow can use to transfer your data.
         * </p>
         * 
         * @param supportedDataTransferApis
         *        The APIs of the connector application that Amazon AppFlow can use to transfer your data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedDataTransferApis(DataTransferApi... supportedDataTransferApis);

        /**
         * <p>
         * The APIs of the connector application that Amazon AppFlow can use to transfer your data.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.appflow.model.DataTransferApi.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.appflow.model.DataTransferApi#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.appflow.model.DataTransferApi.Builder#build()} is called immediately
         * and its result is passed to {@link #supportedDataTransferApis(List<DataTransferApi>)}.
         * 
         * @param supportedDataTransferApis
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.appflow.model.DataTransferApi.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #supportedDataTransferApis(java.util.Collection<DataTransferApi>)
         */
        Builder supportedDataTransferApis(Consumer<DataTransferApi.Builder>... supportedDataTransferApis);
    }

    static final class BuilderImpl implements Builder {
        private Boolean canUseAsSource;

        private Boolean canUseAsDestination;

        private List<String> supportedDestinationConnectors = DefaultSdkAutoConstructList.getInstance();

        private List<String> supportedSchedulingFrequencies = DefaultSdkAutoConstructList.getInstance();

        private Boolean isPrivateLinkEnabled;

        private Boolean isPrivateLinkEndpointUrlRequired;

        private List<String> supportedTriggerTypes = DefaultSdkAutoConstructList.getInstance();

        private ConnectorMetadata connectorMetadata;

        private String connectorType;

        private String connectorLabel;

        private String connectorDescription;

        private String connectorOwner;

        private String connectorName;

        private String connectorVersion;

        private String connectorArn;

        private List<String> connectorModes = DefaultSdkAutoConstructList.getInstance();

        private AuthenticationConfig authenticationConfig;

        private List<ConnectorRuntimeSetting> connectorRuntimeSettings = DefaultSdkAutoConstructList.getInstance();

        private List<String> supportedApiVersions = DefaultSdkAutoConstructList.getInstance();

        private List<String> supportedOperators = DefaultSdkAutoConstructList.getInstance();

        private List<String> supportedWriteOperations = DefaultSdkAutoConstructList.getInstance();

        private String connectorProvisioningType;

        private ConnectorProvisioningConfig connectorProvisioningConfig;

        private String logoURL;

        private Instant registeredAt;

        private String registeredBy;

        private List<String> supportedDataTransferTypes = DefaultSdkAutoConstructList.getInstance();

        private List<DataTransferApi> supportedDataTransferApis = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectorConfiguration model) {
            canUseAsSource(model.canUseAsSource);
            canUseAsDestination(model.canUseAsDestination);
            supportedDestinationConnectorsWithStrings(model.supportedDestinationConnectors);
            supportedSchedulingFrequenciesWithStrings(model.supportedSchedulingFrequencies);
            isPrivateLinkEnabled(model.isPrivateLinkEnabled);
            isPrivateLinkEndpointUrlRequired(model.isPrivateLinkEndpointUrlRequired);
            supportedTriggerTypesWithStrings(model.supportedTriggerTypes);
            connectorMetadata(model.connectorMetadata);
            connectorType(model.connectorType);
            connectorLabel(model.connectorLabel);
            connectorDescription(model.connectorDescription);
            connectorOwner(model.connectorOwner);
            connectorName(model.connectorName);
            connectorVersion(model.connectorVersion);
            connectorArn(model.connectorArn);
            connectorModes(model.connectorModes);
            authenticationConfig(model.authenticationConfig);
            connectorRuntimeSettings(model.connectorRuntimeSettings);
            supportedApiVersions(model.supportedApiVersions);
            supportedOperatorsWithStrings(model.supportedOperators);
            supportedWriteOperationsWithStrings(model.supportedWriteOperations);
            connectorProvisioningType(model.connectorProvisioningType);
            connectorProvisioningConfig(model.connectorProvisioningConfig);
            logoURL(model.logoURL);
            registeredAt(model.registeredAt);
            registeredBy(model.registeredBy);
            supportedDataTransferTypesWithStrings(model.supportedDataTransferTypes);
            supportedDataTransferApis(model.supportedDataTransferApis);
        }

        public final Boolean getCanUseAsSource() {
            return canUseAsSource;
        }

        public final void setCanUseAsSource(Boolean canUseAsSource) {
            this.canUseAsSource = canUseAsSource;
        }

        @Override
        public final Builder canUseAsSource(Boolean canUseAsSource) {
            this.canUseAsSource = canUseAsSource;
            return this;
        }

        public final Boolean getCanUseAsDestination() {
            return canUseAsDestination;
        }

        public final void setCanUseAsDestination(Boolean canUseAsDestination) {
            this.canUseAsDestination = canUseAsDestination;
        }

        @Override
        public final Builder canUseAsDestination(Boolean canUseAsDestination) {
            this.canUseAsDestination = canUseAsDestination;
            return this;
        }

        public final Collection<String> getSupportedDestinationConnectors() {
            if (supportedDestinationConnectors instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedDestinationConnectors;
        }

        public final void setSupportedDestinationConnectors(Collection<String> supportedDestinationConnectors) {
            this.supportedDestinationConnectors = ConnectorTypeListCopier.copy(supportedDestinationConnectors);
        }

        @Override
        public final Builder supportedDestinationConnectorsWithStrings(Collection<String> supportedDestinationConnectors) {
            this.supportedDestinationConnectors = ConnectorTypeListCopier.copy(supportedDestinationConnectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedDestinationConnectorsWithStrings(String... supportedDestinationConnectors) {
            supportedDestinationConnectorsWithStrings(Arrays.asList(supportedDestinationConnectors));
            return this;
        }

        @Override
        public final Builder supportedDestinationConnectors(Collection<ConnectorType> supportedDestinationConnectors) {
            this.supportedDestinationConnectors = ConnectorTypeListCopier.copyEnumToString(supportedDestinationConnectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedDestinationConnectors(ConnectorType... supportedDestinationConnectors) {
            supportedDestinationConnectors(Arrays.asList(supportedDestinationConnectors));
            return this;
        }

        public final Collection<String> getSupportedSchedulingFrequencies() {
            if (supportedSchedulingFrequencies instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedSchedulingFrequencies;
        }

        public final void setSupportedSchedulingFrequencies(Collection<String> supportedSchedulingFrequencies) {
            this.supportedSchedulingFrequencies = SchedulingFrequencyTypeListCopier.copy(supportedSchedulingFrequencies);
        }

        @Override
        public final Builder supportedSchedulingFrequenciesWithStrings(Collection<String> supportedSchedulingFrequencies) {
            this.supportedSchedulingFrequencies = SchedulingFrequencyTypeListCopier.copy(supportedSchedulingFrequencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedSchedulingFrequenciesWithStrings(String... supportedSchedulingFrequencies) {
            supportedSchedulingFrequenciesWithStrings(Arrays.asList(supportedSchedulingFrequencies));
            return this;
        }

        @Override
        public final Builder supportedSchedulingFrequencies(Collection<ScheduleFrequencyType> supportedSchedulingFrequencies) {
            this.supportedSchedulingFrequencies = SchedulingFrequencyTypeListCopier
                    .copyEnumToString(supportedSchedulingFrequencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedSchedulingFrequencies(ScheduleFrequencyType... supportedSchedulingFrequencies) {
            supportedSchedulingFrequencies(Arrays.asList(supportedSchedulingFrequencies));
            return this;
        }

        public final Boolean getIsPrivateLinkEnabled() {
            return isPrivateLinkEnabled;
        }

        public final void setIsPrivateLinkEnabled(Boolean isPrivateLinkEnabled) {
            this.isPrivateLinkEnabled = isPrivateLinkEnabled;
        }

        @Override
        public final Builder isPrivateLinkEnabled(Boolean isPrivateLinkEnabled) {
            this.isPrivateLinkEnabled = isPrivateLinkEnabled;
            return this;
        }

        public final Boolean getIsPrivateLinkEndpointUrlRequired() {
            return isPrivateLinkEndpointUrlRequired;
        }

        public final void setIsPrivateLinkEndpointUrlRequired(Boolean isPrivateLinkEndpointUrlRequired) {
            this.isPrivateLinkEndpointUrlRequired = isPrivateLinkEndpointUrlRequired;
        }

        @Override
        public final Builder isPrivateLinkEndpointUrlRequired(Boolean isPrivateLinkEndpointUrlRequired) {
            this.isPrivateLinkEndpointUrlRequired = isPrivateLinkEndpointUrlRequired;
            return this;
        }

        public final Collection<String> getSupportedTriggerTypes() {
            if (supportedTriggerTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedTriggerTypes;
        }

        public final void setSupportedTriggerTypes(Collection<String> supportedTriggerTypes) {
            this.supportedTriggerTypes = TriggerTypeListCopier.copy(supportedTriggerTypes);
        }

        @Override
        public final Builder supportedTriggerTypesWithStrings(Collection<String> supportedTriggerTypes) {
            this.supportedTriggerTypes = TriggerTypeListCopier.copy(supportedTriggerTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedTriggerTypesWithStrings(String... supportedTriggerTypes) {
            supportedTriggerTypesWithStrings(Arrays.asList(supportedTriggerTypes));
            return this;
        }

        @Override
        public final Builder supportedTriggerTypes(Collection<TriggerType> supportedTriggerTypes) {
            this.supportedTriggerTypes = TriggerTypeListCopier.copyEnumToString(supportedTriggerTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedTriggerTypes(TriggerType... supportedTriggerTypes) {
            supportedTriggerTypes(Arrays.asList(supportedTriggerTypes));
            return this;
        }

        public final ConnectorMetadata.Builder getConnectorMetadata() {
            return connectorMetadata != null ? connectorMetadata.toBuilder() : null;
        }

        public final void setConnectorMetadata(ConnectorMetadata.BuilderImpl connectorMetadata) {
            this.connectorMetadata = connectorMetadata != null ? connectorMetadata.build() : null;
        }

        @Override
        public final Builder connectorMetadata(ConnectorMetadata connectorMetadata) {
            this.connectorMetadata = connectorMetadata;
            return this;
        }

        public final String getConnectorType() {
            return connectorType;
        }

        public final void setConnectorType(String connectorType) {
            this.connectorType = connectorType;
        }

        @Override
        public final Builder connectorType(String connectorType) {
            this.connectorType = connectorType;
            return this;
        }

        @Override
        public final Builder connectorType(ConnectorType connectorType) {
            this.connectorType(connectorType == null ? null : connectorType.toString());
            return this;
        }

        public final String getConnectorLabel() {
            return connectorLabel;
        }

        public final void setConnectorLabel(String connectorLabel) {
            this.connectorLabel = connectorLabel;
        }

        @Override
        public final Builder connectorLabel(String connectorLabel) {
            this.connectorLabel = connectorLabel;
            return this;
        }

        public final String getConnectorDescription() {
            return connectorDescription;
        }

        public final void setConnectorDescription(String connectorDescription) {
            this.connectorDescription = connectorDescription;
        }

        @Override
        public final Builder connectorDescription(String connectorDescription) {
            this.connectorDescription = connectorDescription;
            return this;
        }

        public final String getConnectorOwner() {
            return connectorOwner;
        }

        public final void setConnectorOwner(String connectorOwner) {
            this.connectorOwner = connectorOwner;
        }

        @Override
        public final Builder connectorOwner(String connectorOwner) {
            this.connectorOwner = connectorOwner;
            return this;
        }

        public final String getConnectorName() {
            return connectorName;
        }

        public final void setConnectorName(String connectorName) {
            this.connectorName = connectorName;
        }

        @Override
        public final Builder connectorName(String connectorName) {
            this.connectorName = connectorName;
            return this;
        }

        public final String getConnectorVersion() {
            return connectorVersion;
        }

        public final void setConnectorVersion(String connectorVersion) {
            this.connectorVersion = connectorVersion;
        }

        @Override
        public final Builder connectorVersion(String connectorVersion) {
            this.connectorVersion = connectorVersion;
            return this;
        }

        public final String getConnectorArn() {
            return connectorArn;
        }

        public final void setConnectorArn(String connectorArn) {
            this.connectorArn = connectorArn;
        }

        @Override
        public final Builder connectorArn(String connectorArn) {
            this.connectorArn = connectorArn;
            return this;
        }

        public final Collection<String> getConnectorModes() {
            if (connectorModes instanceof SdkAutoConstructList) {
                return null;
            }
            return connectorModes;
        }

        public final void setConnectorModes(Collection<String> connectorModes) {
            this.connectorModes = ConnectorModeListCopier.copy(connectorModes);
        }

        @Override
        public final Builder connectorModes(Collection<String> connectorModes) {
            this.connectorModes = ConnectorModeListCopier.copy(connectorModes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectorModes(String... connectorModes) {
            connectorModes(Arrays.asList(connectorModes));
            return this;
        }

        public final AuthenticationConfig.Builder getAuthenticationConfig() {
            return authenticationConfig != null ? authenticationConfig.toBuilder() : null;
        }

        public final void setAuthenticationConfig(AuthenticationConfig.BuilderImpl authenticationConfig) {
            this.authenticationConfig = authenticationConfig != null ? authenticationConfig.build() : null;
        }

        @Override
        public final Builder authenticationConfig(AuthenticationConfig authenticationConfig) {
            this.authenticationConfig = authenticationConfig;
            return this;
        }

        public final List<ConnectorRuntimeSetting.Builder> getConnectorRuntimeSettings() {
            List<ConnectorRuntimeSetting.Builder> result = ConnectorRuntimeSettingListCopier
                    .copyToBuilder(this.connectorRuntimeSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConnectorRuntimeSettings(Collection<ConnectorRuntimeSetting.BuilderImpl> connectorRuntimeSettings) {
            this.connectorRuntimeSettings = ConnectorRuntimeSettingListCopier.copyFromBuilder(connectorRuntimeSettings);
        }

        @Override
        public final Builder connectorRuntimeSettings(Collection<ConnectorRuntimeSetting> connectorRuntimeSettings) {
            this.connectorRuntimeSettings = ConnectorRuntimeSettingListCopier.copy(connectorRuntimeSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectorRuntimeSettings(ConnectorRuntimeSetting... connectorRuntimeSettings) {
            connectorRuntimeSettings(Arrays.asList(connectorRuntimeSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectorRuntimeSettings(Consumer<ConnectorRuntimeSetting.Builder>... connectorRuntimeSettings) {
            connectorRuntimeSettings(Stream.of(connectorRuntimeSettings)
                    .map(c -> ConnectorRuntimeSetting.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSupportedApiVersions() {
            if (supportedApiVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedApiVersions;
        }

        public final void setSupportedApiVersions(Collection<String> supportedApiVersions) {
            this.supportedApiVersions = SupportedApiVersionListCopier.copy(supportedApiVersions);
        }

        @Override
        public final Builder supportedApiVersions(Collection<String> supportedApiVersions) {
            this.supportedApiVersions = SupportedApiVersionListCopier.copy(supportedApiVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedApiVersions(String... supportedApiVersions) {
            supportedApiVersions(Arrays.asList(supportedApiVersions));
            return this;
        }

        public final Collection<String> getSupportedOperators() {
            if (supportedOperators instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedOperators;
        }

        public final void setSupportedOperators(Collection<String> supportedOperators) {
            this.supportedOperators = SupportedOperatorListCopier.copy(supportedOperators);
        }

        @Override
        public final Builder supportedOperatorsWithStrings(Collection<String> supportedOperators) {
            this.supportedOperators = SupportedOperatorListCopier.copy(supportedOperators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedOperatorsWithStrings(String... supportedOperators) {
            supportedOperatorsWithStrings(Arrays.asList(supportedOperators));
            return this;
        }

        @Override
        public final Builder supportedOperators(Collection<Operators> supportedOperators) {
            this.supportedOperators = SupportedOperatorListCopier.copyEnumToString(supportedOperators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedOperators(Operators... supportedOperators) {
            supportedOperators(Arrays.asList(supportedOperators));
            return this;
        }

        public final Collection<String> getSupportedWriteOperations() {
            if (supportedWriteOperations instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedWriteOperations;
        }

        public final void setSupportedWriteOperations(Collection<String> supportedWriteOperations) {
            this.supportedWriteOperations = SupportedWriteOperationListCopier.copy(supportedWriteOperations);
        }

        @Override
        public final Builder supportedWriteOperationsWithStrings(Collection<String> supportedWriteOperations) {
            this.supportedWriteOperations = SupportedWriteOperationListCopier.copy(supportedWriteOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedWriteOperationsWithStrings(String... supportedWriteOperations) {
            supportedWriteOperationsWithStrings(Arrays.asList(supportedWriteOperations));
            return this;
        }

        @Override
        public final Builder supportedWriteOperations(Collection<WriteOperationType> supportedWriteOperations) {
            this.supportedWriteOperations = SupportedWriteOperationListCopier.copyEnumToString(supportedWriteOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedWriteOperations(WriteOperationType... supportedWriteOperations) {
            supportedWriteOperations(Arrays.asList(supportedWriteOperations));
            return this;
        }

        public final String getConnectorProvisioningType() {
            return connectorProvisioningType;
        }

        public final void setConnectorProvisioningType(String connectorProvisioningType) {
            this.connectorProvisioningType = connectorProvisioningType;
        }

        @Override
        public final Builder connectorProvisioningType(String connectorProvisioningType) {
            this.connectorProvisioningType = connectorProvisioningType;
            return this;
        }

        @Override
        public final Builder connectorProvisioningType(ConnectorProvisioningType connectorProvisioningType) {
            this.connectorProvisioningType(connectorProvisioningType == null ? null : connectorProvisioningType.toString());
            return this;
        }

        public final ConnectorProvisioningConfig.Builder getConnectorProvisioningConfig() {
            return connectorProvisioningConfig != null ? connectorProvisioningConfig.toBuilder() : null;
        }

        public final void setConnectorProvisioningConfig(ConnectorProvisioningConfig.BuilderImpl connectorProvisioningConfig) {
            this.connectorProvisioningConfig = connectorProvisioningConfig != null ? connectorProvisioningConfig.build() : null;
        }

        @Override
        public final Builder connectorProvisioningConfig(ConnectorProvisioningConfig connectorProvisioningConfig) {
            this.connectorProvisioningConfig = connectorProvisioningConfig;
            return this;
        }

        public final String getLogoURL() {
            return logoURL;
        }

        public final void setLogoURL(String logoURL) {
            this.logoURL = logoURL;
        }

        @Override
        public final Builder logoURL(String logoURL) {
            this.logoURL = logoURL;
            return this;
        }

        public final Instant getRegisteredAt() {
            return registeredAt;
        }

        public final void setRegisteredAt(Instant registeredAt) {
            this.registeredAt = registeredAt;
        }

        @Override
        public final Builder registeredAt(Instant registeredAt) {
            this.registeredAt = registeredAt;
            return this;
        }

        public final String getRegisteredBy() {
            return registeredBy;
        }

        public final void setRegisteredBy(String registeredBy) {
            this.registeredBy = registeredBy;
        }

        @Override
        public final Builder registeredBy(String registeredBy) {
            this.registeredBy = registeredBy;
            return this;
        }

        public final Collection<String> getSupportedDataTransferTypes() {
            if (supportedDataTransferTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedDataTransferTypes;
        }

        public final void setSupportedDataTransferTypes(Collection<String> supportedDataTransferTypes) {
            this.supportedDataTransferTypes = SupportedDataTransferTypeListCopier.copy(supportedDataTransferTypes);
        }

        @Override
        public final Builder supportedDataTransferTypesWithStrings(Collection<String> supportedDataTransferTypes) {
            this.supportedDataTransferTypes = SupportedDataTransferTypeListCopier.copy(supportedDataTransferTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedDataTransferTypesWithStrings(String... supportedDataTransferTypes) {
            supportedDataTransferTypesWithStrings(Arrays.asList(supportedDataTransferTypes));
            return this;
        }

        @Override
        public final Builder supportedDataTransferTypes(Collection<SupportedDataTransferType> supportedDataTransferTypes) {
            this.supportedDataTransferTypes = SupportedDataTransferTypeListCopier.copyEnumToString(supportedDataTransferTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedDataTransferTypes(SupportedDataTransferType... supportedDataTransferTypes) {
            supportedDataTransferTypes(Arrays.asList(supportedDataTransferTypes));
            return this;
        }

        public final List<DataTransferApi.Builder> getSupportedDataTransferApis() {
            List<DataTransferApi.Builder> result = SupportedDataTransferApisCopier.copyToBuilder(this.supportedDataTransferApis);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSupportedDataTransferApis(Collection<DataTransferApi.BuilderImpl> supportedDataTransferApis) {
            this.supportedDataTransferApis = SupportedDataTransferApisCopier.copyFromBuilder(supportedDataTransferApis);
        }

        @Override
        public final Builder supportedDataTransferApis(Collection<DataTransferApi> supportedDataTransferApis) {
            this.supportedDataTransferApis = SupportedDataTransferApisCopier.copy(supportedDataTransferApis);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedDataTransferApis(DataTransferApi... supportedDataTransferApis) {
            supportedDataTransferApis(Arrays.asList(supportedDataTransferApis));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedDataTransferApis(Consumer<DataTransferApi.Builder>... supportedDataTransferApis) {
            supportedDataTransferApis(Stream.of(supportedDataTransferApis)
                    .map(c -> DataTransferApi.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ConnectorConfiguration build() {
            return new ConnectorConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
